/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.recycle;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.LogChannel;
import pluto.schedule.ScheduledMonitor;
import pluto.util.FIFOBuffer;
import pluto.util.recycle.BufferBin;
import pluto.util.recycle.Bufferable;

public abstract class BufferedObjectPool
extends ScheduledMonitor
implements BufferBin {
    private static final Logger log = LoggerFactory.getLogger(BufferedObjectPool.class);
    protected static final boolean POOL_DEBUG = false;
    protected static final boolean INOUT_DEBUG = false;
    protected volatile boolean FLUSH_LOCKING_FLAG = false;
    protected Object LOCK_OF_PRIORITY_INPUT = new Object();
    protected Object LOCK_OF_NORMAL_INPUT = new Object();
    protected Object LOCK_OF_OUTPUT = new Object();
    protected LogChannel LOG_CHANNEL_INSTANCE = null;
    protected FIFOBuffer STACK_OF_BUFFERED_OBJECT = null;
    protected FIFOBuffer STACK_PRIORITY_OF_BUFFERED_OBJECT = null;
    protected LinkedList WORKER_LIST = null;
    protected int CAPACITY = 0;
    protected int RESET_SIZE = 0;
    protected int LEVEL_OF_BUFFERABLE = 0;
    protected int INDEX_OF_BUFFERABLE = 0;
    protected int NAME_INDEX_OF_CREATE_BUFFERABLE = 0;
    protected long LAST_TOUCH_TIME = -1L;
    protected long LAST_FLUSH_TIME = -1L;
    protected boolean NEXT_FLUSH_FLAG = false;
    protected boolean BUFFER_IS_MODIFIED = false;

    public BufferedObjectPool() {
        throw new RuntimeException("NOT IMPLEMENT CONSTRUCTOR");
    }

    protected BufferedObjectPool(long flush_check_interval, String name) {
        super(flush_check_interval, name);
        log.info("BUFFEROBJECTPOOL NAME : {}", (Object)name);
        this.CAPACITY = 0;
        this.LEVEL_OF_BUFFERABLE = 0;
        this.STACK_OF_BUFFERED_OBJECT = new FIFOBuffer(10);
        this.STACK_PRIORITY_OF_BUFFERED_OBJECT = new FIFOBuffer(10);
        this.WORKER_LIST = new LinkedList();
    }

    @Override
    protected void check() throws Exception {
        if (this.NEXT_FLUSH_FLAG || System.currentTimeMillis() > this.LAST_FLUSH_TIME + 300000L) {
            this.flush();
            this.LAST_FLUSH_TIME = System.currentTimeMillis();
            this.NEXT_FLUSH_FLAG = false;
        }
    }

    public synchronized void registFlush() {
        this.log("CALL registFlush() method");
        this.NEXT_FLUSH_FLAG = true;
        this.interruptInnerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(Bufferable src) {
        log.info("{} is remove", (Object)src.getName());
        LinkedList linkedList = this.WORKER_LIST;
        synchronized (linkedList) {
            this.WORKER_LIST.remove(src);
        }
        try {
            this.resetWorkerSize(this.CAPACITY);
        }
        catch (Exception e) {
            log.debug("destroy reSize Error: {}", (Object)e.toString());
        }
    }

    @Override
    public synchronized int getWorkerSize() {
        return this.CAPACITY;
    }

    @Override
    public int getBufferSize() {
        log.debug("CALL getBufferSize()");
        int totalSize = 0;
        totalSize += this.STACK_PRIORITY_OF_BUFFERED_OBJECT.size();
        return totalSize += this.STACK_OF_BUFFERED_OBJECT.size();
    }

    @Override
    public synchronized void resetBufferSize(int size) {
        this.STACK_OF_BUFFERED_OBJECT.reSize(size);
        this.STACK_PRIORITY_OF_BUFFERED_OBJECT.reSize(size);
    }

    protected synchronized void setWorkerSize(int size) throws Exception {
        this.log("CALL setWorkerSize()");
        this.CAPACITY = size;
        Bufferable target = null;
        while (this.CAPACITY > this.WORKER_LIST.size()) {
            target = this.create(this.LEVEL_OF_BUFFERABLE++, this.INDEX_OF_BUFFERABLE++);
            this.WORKER_LIST.addLast(target);
            target.execute();
        }
        log.info("this.WORKER_LIST toString     : {}", (Object)this.WORKER_LIST.toString());
        log.info("this.WORKER_LIST addressValue : {}", (Object)this.WORKER_LIST);
    }

    protected synchronized void setWorkerSize(int size, int rsize) throws Exception {
        this.RESET_SIZE = rsize;
        this.setWorkerSize(size);
    }

    @Override
    public synchronized void resetWorkerSize(int size) throws Exception {
        log.info("CALL resetWorkerSize()");
        this.CAPACITY = size;
        if (this.CAPACITY == this.WORKER_LIST.size()) {
            return;
        }
        this.flush();
        if (this.CAPACITY < this.WORKER_LIST.size()) {
            Bufferable target = null;
            while (this.CAPACITY < this.WORKER_LIST.size()) {
                target = (Bufferable)this.WORKER_LIST.removeLast();
                target.setEnd();
            }
            this.notifyAll();
            return;
        }
        if (this.CAPACITY > this.WORKER_LIST.size()) {
            Bufferable target = null;
            while (this.CAPACITY > this.WORKER_LIST.size()) {
                target = this.create(this.LEVEL_OF_BUFFERABLE++, this.INDEX_OF_BUFFERABLE++);
                this.WORKER_LIST.addLast(target);
                target.execute();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object popup() {
        Object returnValue = null;
        int wait_count = 0;
        while (true) {
            if ((returnValue = this.STACK_PRIORITY_OF_BUFFERED_OBJECT.pop()) == null) {
                returnValue = this.STACK_OF_BUFFERED_OBJECT.pop();
            }
            Object object = this.LOCK_OF_PRIORITY_INPUT;
            synchronized (object) {
                this.LOCK_OF_PRIORITY_INPUT.notifyAll();
            }
            object = this.LOCK_OF_NORMAL_INPUT;
            synchronized (object) {
                this.LOCK_OF_NORMAL_INPUT.notifyAll();
            }
            if (returnValue != null) {
                this.LAST_TOUCH_TIME = System.currentTimeMillis();
                return returnValue;
            }
            object = this.LOCK_OF_OUTPUT;
            synchronized (object) {
                if (wait_count < 10) {
                    ++wait_count;
                    try {
                        this.LOCK_OF_OUTPUT.wait(5000L);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        this.LOCK_OF_OUTPUT.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object popupNoWait() {
        Object returnValue = null;
        returnValue = this.STACK_PRIORITY_OF_BUFFERED_OBJECT.pop();
        if (returnValue != null) {
            this.LAST_TOUCH_TIME = System.currentTimeMillis();
        } else {
            returnValue = this.STACK_OF_BUFFERED_OBJECT.pop();
            if (returnValue != null) {
                this.LAST_TOUCH_TIME = System.currentTimeMillis();
            }
        }
        Object object = this.LOCK_OF_PRIORITY_INPUT;
        synchronized (object) {
            this.LOCK_OF_PRIORITY_INPUT.notifyAll();
        }
        object = this.LOCK_OF_NORMAL_INPUT;
        synchronized (object) {
            this.LOCK_OF_NORMAL_INPUT.notifyAll();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void normalPush(Object src) {
        if (src == null) {
            return;
        }
        int wait_count = 0;
        boolean success_flag = false;
        while (true) {
            this.LAST_TOUCH_TIME = System.currentTimeMillis();
            success_flag = this.STACK_OF_BUFFERED_OBJECT.push(src);
            Object object = this.LOCK_OF_OUTPUT;
            synchronized (object) {
                try {
                    this.LOCK_OF_OUTPUT.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (success_flag) {
                this.BUFFER_IS_MODIFIED = true;
                return;
            }
            object = this.LOCK_OF_NORMAL_INPUT;
            synchronized (object) {
                if (wait_count < 5) {
                    ++wait_count;
                    try {
                        this.LOCK_OF_NORMAL_INPUT.wait(5000L);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        this.LOCK_OF_NORMAL_INPUT.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("OUT WAIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastPush(Object src) {
        log.info("FAST SEND USE : Y");
        int wait_count = 0;
        boolean success_flag = false;
        while (true) {
            this.LAST_TOUCH_TIME = System.currentTimeMillis();
            if (src.toString().indexOf("FASTSEND") > 0) {
                log.info("PRIORITY : STACK_PRIORITY_OF_BUFFERED_OBJECT");
                success_flag = this.STACK_PRIORITY_OF_BUFFERED_OBJECT.push(src);
            }
            Object object = this.LOCK_OF_OUTPUT;
            synchronized (object) {
                try {
                    this.LOCK_OF_OUTPUT.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (success_flag) {
                this.BUFFER_IS_MODIFIED = true;
                return;
            }
            object = this.LOCK_OF_PRIORITY_INPUT;
            synchronized (object) {
                if (wait_count < 5) {
                    ++wait_count;
                    try {
                        this.LOCK_OF_PRIORITY_INPUT.wait(5000L);
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        this.LOCK_OF_PRIORITY_INPUT.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("OUT WAIT");
        }
    }

    @Override
    public void push(Object src) {
        if (src == null) {
            return;
        }
        if (src.toString().indexOf("FASTSEND") > 0) {
            this.fastPush(src);
        } else {
            this.normalPush(src);
        }
    }

    @Override
    public void log(String logStr) {
        if (log.isDebugEnabled()) {
            log.debug(logStr);
        }
    }

    protected abstract void flush() throws Exception;

    protected abstract Bufferable create(int var1, int var2) throws Exception;
}

