/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsFileReader;
import pluto.io.eMsFileWriter;

public class eMsProperties
extends Properties {
    private static final Logger log = LoggerFactory.getLogger(eMsProperties.class);
    private static final long serialVersionUID = 573073693526452524L;

    public eMsProperties() {
        this((Properties)null);
    }

    public eMsProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        String line;
        eMsFileReader in = new eMsFileReader(inStream);
        while ((line = in.readLine()) != null) {
            char firstChar;
            if (line.length() < 1 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.iscontinueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = new String("");
                }
                String loppedLine = line.substring(0, line.length() - 1);
                line = loppedLine.concat("\r\n").concat(nextLine);
            }
            int idx = line.indexOf("=");
            if (idx < 0) continue;
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            this.put(key, value);
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean iscontinueLine(String line) {
        if (line == null) {
            return false;
        }
        return line.endsWith("\\");
    }

    @Override
    public synchronized void store(OutputStream out, String header) throws IOException {
        eMsFileWriter awriter = new eMsFileWriter(out);
        if (header != null) {
            awriter.println("#" + header);
        }
        awriter.println("#" + new Date().toString());
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.get(key);
            awriter.write(key);
            awriter.write("=");
            awriter.println(this.ConvertSave(val));
        }
        awriter.flush();
        try {
            awriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String ConvertSave(String theString) throws IOException {
        if (theString == null || theString.length() < 1) {
            return "";
        }
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(128);
            BufferedReader tmpReader = new BufferedReader(new StringReader(theString));
            String read_line = tmpReader.readLine();
            if (read_line == null) {
                String string = "";
                return string;
            }
            buffer.append(read_line);
            while (tmpReader.ready() && (read_line = tmpReader.readLine()) != null) {
                buffer.append("\\\r\n");
                buffer.append(read_line);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }
}

