/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import freemarker20.template.SimpleHash;
import freemarker20.tm.TemplateHashModelData;
import freemarker20.tm.TemplateHashModelListTM;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.util.Cal;
import pluto.util.PlutoLinkedList;
import pluto.util.SunToLunar;
import pluto.util.eMsStringTokenizer;

public class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    public static final int PROPERTY_DELIM = 34;
    public static final char CHAR_OF_BLANK = ' ';
    public static final char CHAR_OF_LF = '\n';
    public static final char CHAR_OF_CR = '\r';
    private static Class STRING_UTIL_CLASS = null;
    private static List LINKED_LIST_OF_METHOD_CALL;
    private static eMsStringTokenizer INNER_STRING_TOKENIZER;
    private static DecimalFormat number_formatter;
    private static String sDeskey;

    public static final String ConvertString(String source, List infos) {
        Iterator iter = infos.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)iter.next();
            source = StringUtil.ConvertString(source, key, value);
        }
        return source;
    }

    public static final String ConvertString(String source, String target, String dest) {
        if (source == null) {
            return null;
        }
        StringBuffer myBuffer = new StringBuffer(source.length());
        int idx1 = 0;
        int idx2 = 0;
        while ((idx1 = source.indexOf(target, idx2)) >= 0) {
            myBuffer.append(source.substring(idx2, idx1));
            myBuffer.append(dest);
            idx2 = idx1 + target.length();
        }
        myBuffer.append(source.substring(idx2));
        return myBuffer.toString();
    }

    public static final String SecondMappingString(String __SOURCE__, Object __INFO1__, String __START1__, String __END1__, Object __INFO2__, String __START2__, String __END2__) {
        if (__SOURCE__ == null) {
            return null;
        }
        if (__INFO1__ instanceof Map) {
            return StringUtil.ConvertString(__SOURCE__, (Map)__INFO1__, __START1__, __END1__, __INFO2__, __START2__, __END2__);
        }
        if (__INFO1__ instanceof SimpleHash) {
            return StringUtil.ConvertString(__SOURCE__, ((SimpleHash)__INFO1__).getAsHashmap(), __START1__, __END1__, __INFO2__, __START2__, __END2__);
        }
        return __SOURCE__;
    }

    public static final String ConvertString(String __SOURCE__, Map __INFO1__, String __START1__, String __END1__, Object __INFO2__, String __START2__, String __END2__) {
        if (__SOURCE__ == null) {
            return null;
        }
        StringBuffer ReturnValue = new StringBuffer();
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        Object value = null;
        while ((idx1 = __SOURCE__.indexOf(__START1__, idx3)) >= 0 && (idx2 = __SOURCE__.indexOf(__END1__, idx1 + __START1__.length())) >= 0) {
            key = __SOURCE__.substring(idx1 + __START1__.length(), idx2);
            value = __INFO1__.get(key);
            ReturnValue.append(__SOURCE__.substring(idx3, idx1));
            if (value != null) {
                ReturnValue.append(StringUtil.ConvertString(value.toString(), __INFO2__, __START2__, __END2__));
            }
            idx3 = idx2 + __END1__.length();
        }
        ReturnValue.append(__SOURCE__.substring(idx3));
        return ReturnValue.toString();
    }

    public static final String ConvertString(String src, Object map, String start, String end) {
        if (src == null) {
            return null;
        }
        if (map == null) {
            return src;
        }
        if (map instanceof Map) {
            return StringUtil.ConvertString(src, (Map)map, start, end);
        }
        if (map instanceof SimpleHash) {
            return StringUtil.ConvertString(src, ((SimpleHash)map).getAsHashmap(), start, end);
        }
        return src;
    }

    public static final String ConvertString(String src, Map map, String start, String end) {
        return StringUtil.ConvertString(src, map, start, end, false);
    }

    public static final String ConvertString(String src, Map map, String start, String end, boolean query) {
        if (src == null) {
            return null;
        }
        if (map == null) {
            return src;
        }
        StringBuffer ReturnValue = new StringBuffer();
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        String value = null;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            key = src.substring(idx1 + start.length(), idx2);
            if (key.startsWith("\"") && key.endsWith("\"")) {
                try {
                    value = StringUtil.getMethodResult(key);
                }
                catch (Exception e) {
                    log.error("error", (Throwable)e);
                    value = e.toString();
                }
            } else if (key.startsWith("util.")) {
                try {
                    value = StringUtil.getStringUtilMethodResult(key, map);
                }
                catch (Exception e) {
                    log.error("error", (Throwable)e);
                    value = e.toString();
                }
            } else {
                value = map.get(key);
            }
            ReturnValue.append(src.substring(idx3, idx1));
            if (value != null) {
                if (query) {
                    ReturnValue.append(StringUtil.ConvertString(value.toString(), "'", "''"));
                } else {
                    ReturnValue.append(value.toString());
                }
            }
            idx3 = idx2 + end.length();
        }
        ReturnValue.append(src.substring(idx3));
        return ReturnValue.toString();
    }

    public static final String ConvertContainKeyOnlyString(String src, Object map, String start, String end) {
        if (src == null) {
            return null;
        }
        if (map == null) {
            return src;
        }
        if (map instanceof Map) {
            return StringUtil.ConvertContainKeyOnlyString(src, (Map)map, start, end);
        }
        if (map instanceof SimpleHash) {
            return StringUtil.ConvertContainKeyOnlyString(src, ((SimpleHash)map).getAsHashmap(), start, end);
        }
        return src;
    }

    public static final String ConvertContainKeyOnlyString(String src, Map map, String start, String end) {
        if (src == null) {
            return null;
        }
        if (map == null) {
            return src;
        }
        StringBuffer ReturnValue = new StringBuffer();
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String key = null;
        Object value = null;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            key = src.substring(idx1 + start.length(), idx2);
            value = map.get(key);
            ReturnValue.append(src.substring(idx3, idx1));
            if (value == null) {
                ReturnValue.append(start);
                ReturnValue.append(key);
                ReturnValue.append(end);
            } else {
                ReturnValue.append(value.toString());
            }
            idx3 = idx2 + end.length();
        }
        ReturnValue.append(src.substring(idx3));
        return ReturnValue.toString();
    }

    public static final String ConvertQueryString(String src, Object map, String start, String end) {
        if (src == null) {
            return null;
        }
        if (map == null) {
            return src;
        }
        if (map instanceof Map) {
            return StringUtil.ConvertQueryString(src, (Map)map, start, end);
        }
        if (map instanceof SimpleHash) {
            return StringUtil.ConvertQueryString(src, ((SimpleHash)map).getAsHashmap(), start, end);
        }
        return src;
    }

    public static final String ConvertQueryString(String src, Map map, String start, String end) {
        return StringUtil.ConvertString(src, map, start, end, true);
    }

    public static String getMethodResult(String src) throws Exception {
        if (src == null) {
            return "";
        }
        int last_idx = src.lastIndexOf(".");
        if (last_idx < 0) {
            return "";
        }
        String class_name = src.substring(1, last_idx);
        int open = src.indexOf("(", last_idx);
        if (open < 0) {
            return "";
        }
        String method_name = src.substring(last_idx + 1, open);
        return (String)Class.forName(class_name).getDeclaredMethod(method_name, null).invoke(null, null);
    }

    public static synchronized String getStringUtilMethodResult(String src, Map __MAP__) throws Exception {
        if (src == null) {
            return "";
        }
        int last_idx = src.lastIndexOf(".");
        if (last_idx < 0) {
            return "";
        }
        int open = src.indexOf("(", last_idx);
        if (open < 0) {
            return "";
        }
        int close = src.indexOf(")", open);
        if (close < 0) {
            return "";
        }
        String method_name = src.substring(last_idx + 1, open);
        String key = src.substring(open + 1, close);
        LINKED_LIST_OF_METHOD_CALL.clear();
        LINKED_LIST_OF_METHOD_CALL = StringUtil.toStringList(key, ",", LINKED_LIST_OF_METHOD_CALL);
        Object[] values = LINKED_LIST_OF_METHOD_CALL.size() == 0 ? null : new Object[LINKED_LIST_OF_METHOD_CALL.size()];
        Class[] variable_type = LINKED_LIST_OF_METHOD_CALL.size() == 0 ? null : new Class[LINKED_LIST_OF_METHOD_CALL.size()];
        int idx = 0;
        Iterator iter = LINKED_LIST_OF_METHOD_CALL.iterator();
        while (iter.hasNext()) {
            if (values != null) {
                values[idx] = __MAP__.get(iter.next());
            }
            if (variable_type != null) {
                variable_type[idx] = Object.class;
            }
            ++idx;
        }
        return (String)STRING_UTIL_CLASS.getDeclaredMethod(method_name, variable_type).invoke(null, values);
    }

    public static final String removeSpecial(String html) {
        return StringUtil.removeSpecial(new StringBuffer(html));
    }

    public static final String removeSpecial(StringBuffer html) {
        for (int i = 0; i < html.length() - 6; ++i) {
            if (!html.substring(i, i + 5).equals("&amp;")) continue;
            html.replace(i, i + 5, "&");
        }
        return html.toString();
    }

    public static final synchronized List toStringList(String source, String delim, List target) {
        INNER_STRING_TOKENIZER.parse(source, delim);
        return INNER_STRING_TOKENIZER.toList(target);
    }

    public static String[] split(String str, String delimit) {
        int tmpIdx;
        String[] ret = new String[1];
        if (delimit == null || delimit.equals("")) {
            ret[0] = str;
            return ret;
        }
        int len = delimit.length();
        int idx = 0;
        int count = 1;
        while ((idx = str.indexOf(delimit, idx)) != -1) {
            idx += len;
            ++count;
        }
        ret = new String[count];
        count = 0;
        idx = 0;
        while ((tmpIdx = str.indexOf(delimit, idx)) != -1) {
            ret[count] = str.substring(idx, tmpIdx);
            idx = tmpIdx + len;
            ++count;
        }
        ret[count] = str.substring(idx);
        return ret;
    }

    public static final String getListTable_asis(String post_id, String channel_type) {
        if ("EM".equals(channel_type)) {
            return StringUtil.getEmailTable(post_id);
        }
        if ("PU".equals(channel_type)) {
            return StringUtil.getPushTable(post_id);
        }
        if ("SS".equals(channel_type)) {
            return StringUtil.getSmsTable(post_id);
        }
        if ("SM".equals(channel_type)) {
            return StringUtil.getSmsTable(post_id);
        }
        return "";
    }

    public static final String getListTable(String post_id, String channel_type) {
        if (post_id == null) {
            return " ";
        }
        if (post_id.length() < 6) {
            return " ";
        }
        return "TMS_CAMP_SEND_LIST_" + post_id.substring(4, 6);
    }

    public static final String getEmailTable(String post_id) {
        if (post_id == null) {
            return " ";
        }
        if (post_id.length() < 6) {
            return " ";
        }
        return "TMS_CAMP_SEND_LIST_" + post_id.substring(4, 6);
    }

    public static final String getPushTable(String post_id) {
        if (post_id == null) {
            return " ";
        }
        if (post_id.length() < 6) {
            return " ";
        }
        return "TMS_CAMP_SEND_LIST_" + post_id.substring(4, 6);
    }

    public static final String getSmsTable(String post_id) {
        if (post_id == null) {
            return " ";
        }
        if (post_id.length() < 6) {
            return " ";
        }
        return "TMS_CAMP_SEND_LIST_" + post_id.substring(4, 6);
    }

    public static final String FindIndexOfDelimString(String source, String delim, int idx) {
        int idx1 = 0;
        int idx2 = 0;
        int count = 1;
        String returnValue = "";
        while ((idx1 = source.indexOf(delim, idx2)) >= 0) {
            if (count == idx) {
                return source.substring(idx2, idx1);
            }
            ++count;
            idx2 = idx1 + delim.length();
        }
        if (count == idx) {
            returnValue = source.substring(idx2);
        }
        return returnValue;
    }

    public static final String getDomain(String str) {
        if (str == null) {
            return "";
        }
        int index = str.indexOf(64);
        if (index < 0) {
            if (str.indexOf("01") > -1) {
                return "noDomain";
            }
            return str;
        }
        return str.substring(index + 1);
    }

    public static final String getTeleCom(String str) {
        if (str == null || str.length() < 10) {
            return "";
        }
        return str.substring(0, 3);
    }

    public static final boolean isError(String inemail) {
        String email = inemail.trim();
        if (email.indexOf(64) < 0) {
            return true;
        }
        return !StringUtil.isValidHost(StringUtil.getDomain(email));
    }

    public static final boolean isSmsError(String inSms) {
        String SMS = inSms.trim();
        if (SMS == null) {
            return true;
        }
        return !Pattern.matches("^(01[016789]{1}|02|0[3-9]{1}[0-9]{1,2})-?[0-9]{3,4}-?[0-9]{4}$", SMS);
    }

    public static final boolean isValidHost(String host) {
        if (host.indexOf("@") > 0 || host.indexOf(".") < 0 || host.indexOf(" ") > 0 || host.startsWith(".") || host.endsWith(".") || host.indexOf("..") > 0 || host.startsWith("-")) {
            return false;
        }
        for (int i = 0; i < host.length(); ++i) {
            char ch = host.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '-' || ch == '.' || ch == '_') continue;
            return false;
        }
        return true;
    }

    public static final String trimNull(Object src) {
        if (src == null) {
            return "";
        }
        return src.toString().trim();
    }

    public static final int CountString(String src, String target) {
        if (src == null) {
            return -1;
        }
        int idx1 = 0;
        int idx2 = 0;
        int returnValue = 0;
        while ((idx1 = src.indexOf(target, idx2)) >= 0) {
            ++returnValue;
            idx2 = idx1 + target.length();
        }
        return returnValue;
    }

    public static String getPercent(String src, int leng) {
        if ((src = src == null ? "" : src.trim()).length() <= leng) {
            String returnValue = "0.";
            for (int i = 0; i < leng - src.length(); ++i) {
                returnValue = returnValue + "0";
            }
            returnValue = returnValue + src;
            return returnValue;
        }
        return src.substring(0, src.length() - leng) + "." + src.substring(src.length() - leng);
    }

    public static boolean isPositive(String a) {
        if (a == null) {
            return true;
        }
        try {
            double src = Double.parseDouble(a);
            return !(src < 0.0);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isEqual(String src, String dest) {
        if (src == null && dest == null) {
            return true;
        }
        if (src == null || dest == null) {
            return false;
        }
        return src.equals(dest);
    }

    public static boolean isEqualIgnoreCase(String src, String dest) {
        if (src == null && dest == null) {
            return true;
        }
        if (src == null || dest == null) {
            return false;
        }
        return src.equalsIgnoreCase(dest);
    }

    public static String ABS(String a) {
        if (a == null) {
            return "";
        }
        try {
            return String.valueOf(Math.abs(Double.parseDouble(a)));
        }
        catch (Exception e) {
            return a;
        }
    }

    public static String ABSi(String a) {
        if (a == null) {
            return "";
        }
        try {
            return String.valueOf(Math.abs(Integer.parseInt(a)));
        }
        catch (Exception e) {
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toFormatedNumber(String a, String pattern) {
        if (a == null) {
            return " ";
        }
        double src = 0.0;
        try {
            src = Double.parseDouble(a);
        }
        catch (Exception e) {
            return a;
        }
        String returnValue = null;
        DecimalFormat decimalFormat = number_formatter;
        synchronized (decimalFormat) {
            try {
                number_formatter.applyPattern(pattern);
                returnValue = number_formatter.format(src);
            }
            catch (Exception e) {
                return a;
            }
        }
        return returnValue == null ? " " : returnValue;
    }

    public static String getSimpleMoneyValue(String a) {
        if (a == null || a.trim().length() == 0) {
            return " ";
        }
        return StringUtil.toFormatedNumber(a, "#,##0");
    }

    public static String getSimpleMoneyValue(Object a) {
        if (a == null) {
            return " ";
        }
        return StringUtil.getSimpleMoneyValue(a.toString());
    }

    public static String getMoneyValue(Object a) {
        if (a == null) {
            return " ";
        }
        return StringUtil.getMoneyValue(a.toString());
    }

    public static String getMoneyValue(String a) {
        if (a == null || a.trim().length() == 0) {
            return "0.00";
        }
        return StringUtil.toFormatedNumber(a, "#,##0.00#");
    }

    public static String getStringOfStream(InputStream in, String char_set) throws Exception {
        int bytes;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((bytes = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytes);
        }
        in.close();
        out.flush();
        String returnValue = null;
        returnValue = char_set == null ? out.toString() : out.toString(char_set);
        out.reset();
        out.close();
        return returnValue;
    }

    public static String getStringOfReader(Reader in) throws Exception {
        int bytes;
        char[] buffer = new char[1024];
        CharArrayWriter out = new CharArrayWriter();
        while ((bytes = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytes);
        }
        in.close();
        out.flush();
        String returnValue = out.toString();
        out.reset();
        out.close();
        return returnValue;
    }

    public static String substring(String src, String start, String end) {
        if (src == null) {
            return "";
        }
        try {
            int idx1 = Integer.parseInt(start);
            int idx2 = Integer.parseInt(end);
            return src.substring(idx1, idx2);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String GeneralizeMailContents(String src) {
        if (src == null || src.trim().length() < 1) {
            return "";
        }
        StringBuffer tmpBuffer = new StringBuffer();
        BufferedReader b = new BufferedReader(new StringReader(src));
        String tmp = null;
        try {
            while (b.ready() && (tmp = b.readLine()) != null) {
                if ((tmp = tmp.trim()).startsWith(".")) {
                    tmpBuffer.append("..");
                }
                tmpBuffer.append(tmp);
                tmpBuffer.append("\r\n");
            }
            return tmpBuffer.toString();
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String GeneralizeContents(String src, String start, String end, String head) {
        if (src == null) {
            return "";
        }
        int mapping_idx = 1;
        StringBuffer ReturnValue = new StringBuffer();
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        while ((idx1 = src.indexOf(start, idx3)) >= 0 && (idx2 = src.indexOf(end, idx1 + start.length())) >= 0) {
            ReturnValue.append(src.substring(idx3, idx1));
            ReturnValue.append(start);
            ReturnValue.append(head);
            ReturnValue.append(String.valueOf(mapping_idx++));
            ReturnValue.append(end);
            idx3 = idx2 + end.length();
        }
        ReturnValue.append(src.substring(idx3));
        return ReturnValue.toString();
    }

    public static boolean isBetween(String s, String f, String t) {
        if (s == null || s.trim().length() < 1) {
            return false;
        }
        if (!(f != null && f.trim().length() >= 1 || t != null && t.trim().length() >= 1)) {
            return false;
        }
        double src = 0.0;
        try {
            src = Double.parseDouble(s);
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (f != null && f.trim().length() > 0 && src < Double.parseDouble(f)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            if (t != null && t.trim().length() > 0 && src >= Double.parseDouble(t)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getDayFormat(String source) {
        if (source == null) {
            return "";
        }
        if (source.length() == 4) {
            if (Integer.parseInt(source) > 1231) {
                return source + "\ub144";
            }
            return source.substring(0, 2) + "\uc6d4 " + source.substring(2) + "\uc77c";
        }
        if (source.length() == 6) {
            return source.substring(0, 4) + "\ub144 " + source.substring(4) + "\uc6d4";
        }
        if (source.length() == 8) {
            return source.substring(0, 4) + "\ub144 " + source.substring(4, 6) + "\uc6d4 " + source.substring(6) + "\uc77c ";
        }
        return source;
    }

    public static final String nl2blank(String src) {
        if (src == null) {
            return "";
        }
        return src.replace('\r', ' ').replace('\n', ' ');
    }

    public static String TagFilter(String src) {
        if (src.startsWith("</")) {
            return src.toLowerCase();
        }
        int idx1 = src.indexOf(32);
        if (idx1 < 0) {
            return src;
        }
        return src.substring(0, idx1).toLowerCase();
    }

    public static String getAttribute(String __SRC__, String __ATT_NAME__) {
        String __LOWER_SRC__ = __SRC__.toLowerCase().replace('\'', '\"');
        String __LOWER_ATT_NAME__ = __ATT_NAME__.toLowerCase();
        int __VALUE_QUALIFIER__ = 0;
        boolean next = true;
        int idx_param_start = __LOWER_SRC__.indexOf(__LOWER_ATT_NAME__);
        if (idx_param_start < 0) {
            return null;
        }
        int idx_param_end = __LOWER_SRC__.indexOf("=", idx_param_start);
        if (idx_param_end < 0) {
            return null;
        }
        int __VALUE_QUALIFIER_START_INDEX__ = idx_param_end;
        int __VALUE_QUALIFIER_END_INDEX__ = 0;
        next = true;
        block3: while (next) {
            __VALUE_QUALIFIER__ = __LOWER_SRC__.charAt(++__VALUE_QUALIFIER_START_INDEX__);
            switch (__VALUE_QUALIFIER__) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            next = false;
        }
        if (34 == __VALUE_QUALIFIER__) {
            __VALUE_QUALIFIER_END_INDEX__ = __LOWER_SRC__.indexOf("\"", __VALUE_QUALIFIER_START_INDEX__ + 1);
            if (__VALUE_QUALIFIER_END_INDEX__ < 0) {
                return null;
            }
            return __SRC__.substring(__VALUE_QUALIFIER_START_INDEX__ + 1, __VALUE_QUALIFIER_END_INDEX__).trim();
        }
        __VALUE_QUALIFIER_END_INDEX__ = __LOWER_SRC__.indexOf(" ", __VALUE_QUALIFIER_START_INDEX__);
        if (__VALUE_QUALIFIER_END_INDEX__ < 0 && (__VALUE_QUALIFIER_END_INDEX__ = __LOWER_SRC__.indexOf(">", __VALUE_QUALIFIER_START_INDEX__)) < 0) {
            return null;
        }
        if (__VALUE_QUALIFIER_END_INDEX__ == __VALUE_QUALIFIER_START_INDEX__) {
            return "";
        }
        return __SRC__.substring(__VALUE_QUALIFIER_START_INDEX__, __VALUE_QUALIFIER_END_INDEX__).trim();
    }

    public static String switchAttribute(String __SRC__, String __ATT_NAME__, String __CHANGE_ATT_VALUE__) {
        String __LOWER_SRC__ = __SRC__.toLowerCase().replace('\'', '\"');
        String __LOWER_ATT_NAME__ = __ATT_NAME__.toLowerCase();
        int __VALUE_QUALIFIER__ = 0;
        boolean next = true;
        int idx_param_start = __LOWER_SRC__.indexOf(__LOWER_ATT_NAME__);
        if (idx_param_start < 0) {
            return __SRC__;
        }
        int idx_param_end = __LOWER_SRC__.indexOf("=", idx_param_start);
        if (idx_param_end < 0) {
            return __SRC__;
        }
        int __VALUE_QUALIFIER_START_INDEX__ = idx_param_end;
        int __VALUE_QUALIFIER_END_INDEX__ = 0;
        next = true;
        block3: while (next) {
            __VALUE_QUALIFIER__ = __LOWER_SRC__.charAt(++__VALUE_QUALIFIER_START_INDEX__);
            switch (__VALUE_QUALIFIER__) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            next = false;
        }
        if (34 == __VALUE_QUALIFIER__) {
            __VALUE_QUALIFIER_END_INDEX__ = __LOWER_SRC__.indexOf("\"", __VALUE_QUALIFIER_START_INDEX__ + 1);
            if (__VALUE_QUALIFIER_END_INDEX__ < 0) {
                return __SRC__;
            }
            return new StringBuffer(__SRC__).replace(__VALUE_QUALIFIER_START_INDEX__ + 1, __VALUE_QUALIFIER_END_INDEX__, __CHANGE_ATT_VALUE__).toString();
        }
        __VALUE_QUALIFIER_END_INDEX__ = __LOWER_SRC__.indexOf(" ", __VALUE_QUALIFIER_START_INDEX__);
        if (__VALUE_QUALIFIER_END_INDEX__ < 0 && (__VALUE_QUALIFIER_END_INDEX__ = __LOWER_SRC__.indexOf(">", __VALUE_QUALIFIER_START_INDEX__)) < 0) {
            return __SRC__;
        }
        if (__VALUE_QUALIFIER_END_INDEX__ == __VALUE_QUALIFIER_START_INDEX__) {
            return "";
        }
        return new StringBuffer(__SRC__).replace(__VALUE_QUALIFIER_START_INDEX__, __VALUE_QUALIFIER_END_INDEX__, __CHANGE_ATT_VALUE__).toString();
    }

    public static String switchAttribute2(String src, String pname, String value) {
        String param;
        String source = src.toLowerCase().replace('\'', '\"');
        int idx1 = source.indexOf((param = pname.toLowerCase()) + "=");
        if (idx1 < 0) {
            return null;
        }
        char delim = source.charAt(idx1 + param.length() + 1);
        if ('\"' == delim) {
            int idx2 = source.indexOf("\"", idx1 + param.length() + 2);
            if (idx2 < 0) {
                return null;
            }
            return new StringBuffer(src).replace(idx1 + param.length() + 2, idx2, value).toString();
        }
        int idx_s = source.indexOf(">", idx1 + param.length() + 1);
        int idx_b = source.indexOf(" ", idx1 + param.length() + 1);
        if (idx_s < 0 && idx_b < 0) {
            return null;
        }
        if (idx_s < idx_b) {
            return new StringBuffer(src).replace(idx1 + param.length() + 1, idx_s, value).toString();
        }
        return new StringBuffer(src).replace(idx1 + param.length() + 1, idx_b, value).toString();
    }

    public static final int findIndex(byte[] src, byte[] target) {
        return StringUtil.findIndex(src, target, 0);
    }

    public static final int findIndex(byte[] src, byte[] target, int offset) {
        if (offset > src.length) {
            return -1;
        }
        int length = target.length;
        int range = src.length - length;
        for (int idx = offset; idx <= range; ++idx) {
            if (src[idx] != target[0]) continue;
            boolean match = true;
            for (int i = 1; i < length; ++i) {
                if (src[idx + i] == target[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return idx;
        }
        return -1;
    }

    public static final String attachLeftPadding(int source, int limit, String AppendDigit) {
        String returnValue = String.valueOf(source);
        while (returnValue.length() < limit) {
            returnValue = AppendDigit.concat(returnValue);
        }
        return returnValue;
    }

    public static final int getLength(String src) {
        if (src == null) {
            return 0;
        }
        return src.trim().length();
    }

    public static String removeFileSpecialString(String src) {
        if (src == null) {
            return null;
        }
        return src.replace('\\', '_').replace('/', '_').replace(':', '_').replace('\"', '_').replace('<', '_').replace('>', '_').replace('|', '_');
    }

    public static final boolean isPureDigit(String src) {
        if (src == null) {
            return false;
        }
        return StringUtil.isPureDigit(src, 0, src.length());
    }

    public static final boolean isPureDigit(String src, int Start2, int End2) {
        if (src == null) {
            return false;
        }
        End2 = src.length() < End2 ? src.length() : End2;
        for (int i = Start2; i < End2; ++i) {
            if (Character.isDigit(src.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String nl2br(String src) {
        StringBuffer TARGET = new StringBuffer(src);
        for (int i = 0; i < TARGET.length(); ++i) {
            char target = TARGET.charAt(i);
            if (target == '\n') {
                TARGET.insert(i, "<br>");
                i += 4;
                continue;
            }
            if (target != '\r') continue;
            TARGET.deleteCharAt(i);
            --i;
        }
        String returnValue = TARGET.toString();
        return returnValue;
    }

    public static String getLunarDay() {
        return StringUtil.getLunarDay(null);
    }

    public static String getLunarDay(Object t) {
        return SunToLunar.Lunar(Cal.getYear(), Cal.getMonth(), Cal.getDay());
    }

    public static String getAutoMemberID(Object mid) {
        if (mid == null) {
            return "";
        }
        String M_ID = mid.toString();
        int idx = M_ID.lastIndexOf("_");
        if (idx < 0) {
            return M_ID;
        }
        return M_ID.substring(0, idx);
    }

    public static final boolean isNull(String src) {
        return src == null || src.trim().length() < 1;
    }

    public static final int len(Object src) {
        if (src == null) {
            return 0;
        }
        return src.toString().length();
    }

    public static final String addStrTONum(String str1, String str2) {
        if (str1 == null) {
            str1 = "0";
        }
        if (str2 == null) {
            str2 = "0";
        }
        try {
            return String.valueOf(Integer.parseInt(str1) + Integer.parseInt(str2));
        }
        catch (Exception ignore) {
            return "";
        }
    }

    public static String replace(String target, String from, String to) {
        int idx2;
        if (target == null || from == null || to == null) {
            return null;
        }
        int idx1 = 0;
        while ((idx2 = target.indexOf(from, idx1)) != -1) {
            target = target.substring(0, idx2) + to + target.substring(idx2 + from.length());
            idx1 = idx2 + to.length();
        }
        return target;
    }

    public static String getToday(String pFormat) {
        return StringUtil.getDate(new Date(), pFormat);
    }

    public static String getDate(Date pDate, String pFormat) {
        if (pDate == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        new SimpleDateFormat(pFormat).format(pDate, ret, new FieldPosition(0));
        return ret.toString();
    }

    public static String getSubStr(String str2, int len, String tail) throws Exception {
        String str = "";
        int byteCnt = 0;
        try {
            str = str2;
        }
        catch (Exception e) {
            log.debug(e.toString());
            str = str2;
        }
        if (str.getBytes().length <= len) {
            return str2;
        }
        StringCharacterIterator sci = new StringCharacterIterator(str);
        StringBuffer sb = new StringBuffer();
        sb.append(sci.first());
        int i = 1;
        while (byteCnt < len) {
            char c = sci.next();
            sb.append(c);
            byteCnt = c > '\u007f' ? (byteCnt += 2) : ++byteCnt;
            ++i;
        }
        sb.append(tail);
        return sb.toString();
    }

    public static String toHLML(String str) {
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "'");
        return str;
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Properties getProp_sslife(String str, String head) {
        String dm = String.valueOf('\u007f');
        String[] str_extr = StringUtil.split(str, dm);
        Properties prop = new Properties();
        StringBuffer sBuffer = new StringBuffer();
        String val_str = "";
        for (int j = 0; j < str_extr.length; ++j) {
            val_str = StringUtil.isNull(str_extr[j]) ? "&nbsp;" : str_extr[j].trim();
            sBuffer.setLength(0);
            sBuffer.append(head).append("_").append(j);
            prop.setProperty(sBuffer.toString(), val_str);
        }
        return prop;
    }

    public static String getKeyFillerValue(String key_filler) {
        String dm = String.valueOf('\u007f');
        if (StringUtil.isNull(key_filler)) {
            return " |Y";
        }
        String[] str_a = StringUtil.split(key_filler, dm);
        if (str_a.length >= 5) {
            StringBuffer sBuffer = new StringBuffer();
            sBuffer.append(str_a[0].trim());
            sBuffer.append("|");
            sBuffer.append(str_a[4].trim());
            return sBuffer.toString();
        }
        return " |Y";
    }

    public static LinkedList getList_sslife(String str, String head) {
        if (str.equals("null")) {
            return new LinkedList();
        }
        String dm1 = String.valueOf('\u0014');
        String dm2 = String.valueOf('\u007f');
        String[] str_a = StringUtil.split(str, dm1);
        int x_size = 0;
        x_size = StringUtil.isNull(str_a[str_a.length - 1]) ? str_a.length - 1 : str_a.length;
        String[] str_extr = null;
        Properties prop = null;
        StringBuffer sBuffer = new StringBuffer();
        LinkedList<Properties> TMP_LIST_MAPPING_LIST = new LinkedList<Properties>();
        for (int i = 0; i < x_size; ++i) {
            str_extr = StringUtil.split(str_a[i], dm2);
            prop = new Properties();
            String val_str = "";
            for (int j = 0; j < str_extr.length; ++j) {
                val_str = StringUtil.isNull(str_extr[j]) ? "&nbsp;" : str_extr[j].trim();
                sBuffer.setLength(0);
                sBuffer.append(head).append("_").append(j);
                prop.setProperty(sBuffer.toString(), val_str);
            }
            TMP_LIST_MAPPING_LIST.addLast(prop);
        }
        return TMP_LIST_MAPPING_LIST;
    }

    public static void main(String[] args) {
    }

    public static Properties getProp_sslife_token(String str, String head) {
        String dm = String.valueOf('\u007f');
        return StringUtil.getProp_sslife_token(str, dm, head);
    }

    public static Properties getProp_sslife_token(String str, char c_dm, String head) {
        String dm = String.valueOf(c_dm);
        return StringUtil.getProp_sslife_token(str, dm, head);
    }

    public static Properties getProp_sslife_token(String str, String dm, String head) {
        Properties prop = new Properties();
        StringTokenizer token_col = new StringTokenizer(str, dm);
        if (token_col.countTokens() == 0) {
            return prop;
        }
        String col_str = "";
        StringBuffer sBuffer = new StringBuffer();
        String val_str = "";
        int col_cnt = 0;
        while (token_col.hasMoreElements()) {
            col_str = token_col.nextToken();
            val_str = StringUtil.isNull(col_str) ? "&nbsp;" : col_str.trim();
            sBuffer.setLength(0);
            sBuffer.append(head).append("_").append(col_cnt);
            prop.setProperty(sBuffer.toString(), val_str);
            ++col_cnt;
        }
        return prop;
    }

    public static LinkedList getList_sslife_token(String str, String head) {
        String dm1 = String.valueOf('\u0014');
        String dm2 = String.valueOf('\u007f');
        return StringUtil.getList_sslife_token(str, dm1, dm2, head);
    }

    public static LinkedList getList_sslife_token(String str, char c_dm1, char c_dm2, String head) {
        String dm1 = String.valueOf(c_dm1);
        String dm2 = String.valueOf(c_dm2);
        return StringUtil.getList_sslife_token(str, dm1, dm2, head);
    }

    public static LinkedList getList_sslife_token(String str, String dm1, String dm2, String head) {
        LinkedList<Properties> TMP_LIST_MAPPING_LIST = new LinkedList<Properties>();
        Properties prop = null;
        StringTokenizer token_line = new StringTokenizer(str, dm1);
        StringTokenizer token_col = null;
        if (token_line.countTokens() == 0) {
            prop = new Properties();
            TMP_LIST_MAPPING_LIST.addLast(prop);
            return TMP_LIST_MAPPING_LIST;
        }
        String line_str = "";
        String col_str = "";
        StringBuffer sBuffer = new StringBuffer();
        while (token_line.hasMoreElements()) {
            prop = new Properties();
            line_str = token_line.nextToken();
            token_col = new StringTokenizer(line_str, dm2);
            if (token_col.countTokens() == 0) {
                TMP_LIST_MAPPING_LIST.addLast(prop);
                continue;
            }
            String val_str = "";
            int col_cnt = 0;
            while (token_col.hasMoreElements()) {
                col_str = token_col.nextToken();
                val_str = StringUtil.isNull(col_str) ? "&nbsp;" : col_str.trim();
                sBuffer.setLength(0);
                sBuffer.append(head).append("_").append(col_cnt);
                prop.setProperty(sBuffer.toString(), val_str);
                ++col_cnt;
            }
            TMP_LIST_MAPPING_LIST.addLast(prop);
        }
        return TMP_LIST_MAPPING_LIST;
    }

    public static int divideCeil(int a1, int b1) {
        int returnStr = 0;
        try {
            float leaves = a1 % b1;
            int temp = 0;
            temp = leaves != 0.0f ? a1 / b1 + 1 : a1 / b1;
            returnStr = temp;
            return returnStr;
        }
        catch (Exception e) {
            return returnStr;
        }
    }

    public static String getToday_sslife(String fmt) {
        Date currentdate = new Date();
        SimpleDateFormat timestring = new SimpleDateFormat(fmt);
        return timestring.format(currentdate);
    }

    public static String nullCheck(String s) {
        String value = s.trim();
        if (value.length() == 0 || s.equals("null")) {
            value = "&nbsp;";
        }
        return value;
    }

    public static String delSpace(String data) {
        if (data == null) {
            return "";
        }
        StringBuffer ts = new StringBuffer(StringUtil.replace(data, "\u3000", " "));
        int size = data.length();
        for (int i = size - 1; i > 0; --i) {
            if (ts.charAt(i) != ' ') {
                return ts.toString();
            }
            ts.deleteCharAt(i);
        }
        return ts.toString();
    }

    public static String alterSign(String s) {
        String value = s.trim();
        value = value.length() == 13 ? "*********" + value.substring(9, 13) : "*";
        return value;
    }

    public static String monitoringDate(String date, String fromFormatString, String toFormatString) {
        SimpleDateFormat fromFormat = new SimpleDateFormat(fromFormatString);
        SimpleDateFormat toFormat = new SimpleDateFormat(toFormatString);
        Date fromDate = null;
        try {
            fromDate = fromFormat.parse(date);
        }
        catch (ParseException e) {
            fromDate = new Date();
        }
        return toFormat.format(fromDate);
    }

    public static String pieDataGenerator(String standard_col, String sno, String target_key_col, String target_value_col, TemplateHashModelListTM list) {
        StringBuffer outSb = null;
        String return_str = "";
        try {
            for (int i = 0; i < list.size(); ++i) {
                TemplateHashModelData prop = (TemplateHashModelData)list.get(i);
                String listSno = prop.get(standard_col).toString();
                if (!sno.equals(listSno)) continue;
                if (outSb == null) {
                    outSb = new StringBuffer();
                }
                String key = prop.get(target_key_col).toString();
                String value = prop.get(target_value_col).toString();
                String tempResult = key + "^" + value + "|";
                outSb.append(tempResult);
            }
            if (outSb != null) {
                return_str = outSb.replace(outSb.length() - 1, outSb.length(), "").toString();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return return_str;
    }

    public static String barDataGenerator(String standard_col, String sno, String target_key_col, String target_value_col, TemplateHashModelListTM list) {
        StringBuffer outSb = null;
        String return_str = "";
        try {
            for (int i = 0; i < list.size(); ++i) {
                TemplateHashModelData prop = (TemplateHashModelData)list.get(i);
                String listSno = prop.get(standard_col).toString();
                if (!sno.equals(listSno)) continue;
                if (outSb == null) {
                    outSb = new StringBuffer();
                }
                String key = prop.get(target_key_col).toString();
                String value = prop.get(target_value_col).toString();
                String tempResult = key + "^" + value + "|";
                outSb.append(tempResult);
            }
            if (outSb != null) {
                return_str = outSb.replace(outSb.length() - 1, outSb.length(), "").toString();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return return_str;
    }

    public static String lineDataGenerator(String flag, String standard_col, String sno, String target_col, TemplateHashModelListTM list) {
        StringBuffer outSb = null;
        String return_str = "";
        String listSno = "";
        try {
            for (int i = 0; i < list.size(); ++i) {
                TemplateHashModelData prop = (TemplateHashModelData)list.get(i);
                listSno = prop.get(standard_col).toString();
                String data = "";
                if (!sno.equals(listSno)) continue;
                if (outSb == null) {
                    outSb = new StringBuffer();
                }
                data = flag.equals("label") ? prop.get(target_col) + "|" : prop.get(target_col) + ",";
                outSb.append(data);
            }
            if (outSb != null) {
                return_str = outSb.replace(outSb.length() - 1, outSb.length(), "").toString();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return return_str;
    }

    public static String trimZero(String message) {
        return String.valueOf(Long.parseLong(message));
    }

    public static String encodeSeq(String jumin) {
        DecimalFormat dformat = new DecimalFormat("000");
        String en_jumin = "";
        boolean flag = false;
        if (jumin.length() != 13) {
            return "___" + jumin + "___";
        }
        for (int i = 0; i < jumin.length(); ++i) {
            String num = jumin.substring(i, i + 1);
            if (!(num.equals("0") || num.equals("1") || num.equals("2") || num.equals("3") || num.equals("4") || num.equals("5") || num.equals("6") || num.equals("7") || num.equals("8") || num.equals("9"))) {
                flag = true;
                break;
            }
            flag = false;
        }
        if (flag) {
            return "___" + jumin + "___";
        }
        int chk_digit = Integer.parseInt(jumin.substring(12, 13));
        en_jumin = jumin.length() == 13 ? (chk_digit == 0 ? dformat.format((long)Integer.parseInt(jumin.substring(8, 10)) * 9L) + dformat.format((long)Integer.parseInt(jumin.substring(4, 6)) * 9L) + dformat.format((long)Integer.parseInt(jumin.substring(10, 12)) * 9L) + dformat.format((long)Integer.parseInt(jumin.substring(2, 4)) * 9L) + "29" + dformat.format((long)Integer.parseInt(jumin.substring(6, 8)) * 9L) + dformat.format((long)Integer.parseInt(jumin.substring(0, 2)) * 9L) : dformat.format((long)Integer.parseInt(jumin.substring(8, 10)) * Long.valueOf(chk_digit)) + dformat.format((long)Integer.parseInt(jumin.substring(4, 6)) * Long.valueOf(chk_digit)) + dformat.format((long)Integer.parseInt(jumin.substring(10, 12)) * Long.valueOf(chk_digit)) + dformat.format((long)Integer.parseInt(jumin.substring(2, 4)) * Long.valueOf(chk_digit)) + chk_digit + "2" + dformat.format((long)Integer.parseInt(jumin.substring(6, 8)) * Long.valueOf(chk_digit)) + dformat.format((long)Integer.parseInt(jumin.substring(0, 2)) * Long.valueOf(chk_digit))) : "___" + jumin + "___";
        return en_jumin;
    }

    public static String changeCharacter(String origin, String ch, int startIndex, int endIndex) {
        String temp = "";
        for (int i = 0; i < endIndex - startIndex; ++i) {
            temp = temp + ch;
        }
        return origin.substring(0, startIndex - 1) + temp;
    }

    public static String getJuminFormat(String jumin) {
        return jumin.substring(0, 6) + " - " + jumin.substring(6, 13);
    }

    public static String getFormattedDate(String from, String oFormat, String rFormat) {
        SimpleDateFormat oriForm = new SimpleDateFormat(oFormat);
        SimpleDateFormat resForm = new SimpleDateFormat(rFormat);
        Date oDate = null;
        long rDate = 0L;
        try {
            oDate = oriForm.parse(from);
            rDate = oDate.getTime();
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        return resForm.format(rDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String changeDigit(String data, String digitCnt) {
        if (StringUtil.isNull(data)) {
            data = "0";
        }
        String retValue = "";
        String temp = "";
        String[] dataArr = StringUtil.split(data, ".");
        String remainNum = "";
        try {
            remainNum = dataArr[1];
            if (remainNum.length() <= Integer.parseInt(digitCnt)) {
                for (int i = 0; i < Integer.parseInt(digitCnt) - dataArr[1].length() + 1; ++i) {
                    remainNum = remainNum + "0";
                }
            }
            int length = Integer.parseInt(digitCnt);
            for (int i = 0; i < length; ++i) {
                temp = i == length - 1 ? temp + (remainNum.charAt(length) >= '0' && remainNum.charAt(length) < '5' ? remainNum.charAt(i) : (char)(remainNum.charAt(i) - 48 + 1 + 48)) : temp + remainNum.charAt(i);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            temp = "";
            for (int i = 0; i < Integer.parseInt(digitCnt); ++i) {
                temp = temp + "0";
            }
        }
        finally {
            retValue = dataArr[0] + "." + temp;
        }
        return retValue;
    }

    static {
        try {
            STRING_UTIL_CLASS = StringUtil.class;
        }
        catch (Exception exception) {
            // empty catch block
        }
        LINKED_LIST_OF_METHOD_CALL = new PlutoLinkedList();
        INNER_STRING_TOKENIZER = new eMsStringTokenizer();
        number_formatter = new DecimalFormat();
        sDeskey = "Wkd!rn00";
    }
}

