/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlutoLinkedList
implements List,
Iterator {
    private static final Logger log = LoggerFactory.getLogger(PlutoLinkedList.class);
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private Entry lastReturned = null;

    public PlutoLinkedList() {
        this.header.next = this.header.previous = this.header;
    }

    @Override
    public void clear() {
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator iterator() {
        this.lastReturned = this.header;
        return this;
    }

    @Override
    public boolean add(Object obj) {
        this.addBefore(obj, this.header);
        return true;
    }

    @Override
    public void addLast(Object o) {
        this.addBefore(o, this.header);
    }

    @Override
    public void addFirst(Object o) {
        this.addBefore(o, this.header.next);
    }

    private void addBefore(Object o, Entry e) {
        Entry newEntry;
        if (o == null) {
            return;
        }
        newEntry.previous.next = newEntry = new Entry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
    }

    @Override
    public Object removeFirst() {
        Object first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    @Override
    public Object removeLast() {
        Object last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    private void remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
    }

    @Override
    public boolean hasNext() {
        return this.lastReturned.next != this.header;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastReturned = this.lastReturned.next;
        return this.lastReturned.element;
    }

    @Override
    public void remove() {
        this.remove(this.lastReturned);
    }

    public synchronized String toString() {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(512);
            buffer.append("[");
            Object iter = this.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next().toString());
                buffer.append(",");
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("]");
            iter = buffer.toString();
            return iter;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    public static void main(String[] arg) throws Exception {
        PlutoLinkedList list = new PlutoLinkedList();
        int idx = 0;
        list.addLast(String.valueOf(idx++));
        list.addLast(String.valueOf(idx++));
        list.addLast(String.valueOf(idx++));
        list.addLast(String.valueOf(idx++));
        list.addLast(String.valueOf(idx++));
        list.addLast(String.valueOf(idx++));
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            log.debug(iter.next().toString());
        }
        log.debug(list.toString());
        list.clear();
        list.addLast("-2");
        list.addLast("-3");
        list.addFirst("-1");
        list.addLast("-4");
        list.addFirst("-0");
        iter = list.iterator();
        while (iter.hasNext()) {
            log.debug(iter.next().toString());
        }
    }

    @Override
    public boolean remove(Object obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public ListIterator listIterator() {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public boolean contains(Object obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public boolean containsAll(Collection collection) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public Object get(int param) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public int indexOf(Object obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public boolean isEmpty() {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public int lastIndexOf(Object obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public ListIterator listIterator(int param) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public Object remove(int param) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public Object set(int param, Object obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public List subList(int param, int param1) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public Object[] toArray() {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public Object[] toArray(Object[] obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public void add(int param, Object obj) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    public boolean addAll(int param, Collection collection) {
        throw new RuntimeException("NOT IMPLEMENTS");
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }
}

