/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.util.StringConvertUtil;

public class FilterUtils {
    private static final Logger log = LoggerFactory.getLogger(FilterUtils.class);
    protected final int COMMIT_INTEVER = 1000;
    private static String QUERY_FILTER_INSERT_SEND_LIST = null;
    private static String QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = null;

    public void procFilterResult(List<Map<String, String>> list, Properties schdInfo) throws Exception {
        this.insertFiltersSendList(list, schdInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertFiltersSendList(List<Map<String, String>> list, Properties schdInfo) throws Exception {
        int insertCnt = 0;
        eMsConnection conn = null;
        eMsPreparedStatement ps = null;
        eMsPreparedStatement psSelectNextSeq = null;
        StringBuffer buffer = new StringBuffer(1024);
        try {
            conn = ConnectionPool.getConnection();
            conn.setAutoCommit(false);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, QUERY_FILTER_INSERT_SEND_LIST, schdInfo, "${", "}", true, false);
            ps = conn.prepareStatement(buffer.toString(), "@{", "}");
            int commitRetCnt = 0;
            for (Map<String, String> map : list) {
                ++insertCnt;
                ps.addBatch(map);
                if (++commitRetCnt % 1000 != 0) continue;
                ps.executeBatch();
                conn.commit();
            }
            ps.executeBatch();
            conn.commit();
            if (ps != null) {
                conn.recycleStatement(ps);
            }
            if (conn == null) return insertCnt;
        }
        catch (Exception e) {
            try {
                log.error("error:", (Throwable)e);
                conn.rollback();
                insertCnt = 0;
                buffer.setLength(0);
                eMsResultSet rsNextSeq = null;
                StringConvertUtil.ConvertString(buffer, QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE, schdInfo, "${", "}", true, false);
                psSelectNextSeq = conn.prepareStatement(buffer.toString(), "@{", "}");
                for (Map<String, String> map : list) {
                    try {
                        String nextMemberSeq = "";
                        rsNextSeq = psSelectNextSeq.executeQuery(map);
                        if (rsNextSeq.next()) {
                            String string = nextMemberSeq = rsNextSeq.getString(1) == null ? "" : rsNextSeq.getString(1);
                        }
                        if ("".equals(nextMemberSeq)) continue;
                        map.put("TMS_M_ID_SEQ", nextMemberSeq);
                        insertCnt += ps.executeUpdate(map);
                        conn.commit();
                    }
                    catch (Exception ex) {
                        log.error("Exception", (Throwable)ex);
                        log.error("error :  {}", (Object)ex.getMessage());
                    }
                }
                if (ps != null) {
                    conn.recycleStatement(ps);
                }
                if (conn == null) return insertCnt;
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    conn.recycleStatement(ps);
                }
                if (conn == null) throw throwable;
                conn.commit();
                conn.setAutoCommit(true);
                conn.recycle();
                throw throwable;
            }
            conn.commit();
            conn.setAutoCommit(true);
            conn.recycle();
            return insertCnt;
        }
        conn.commit();
        conn.setAutoCommit(true);
        conn.recycle();
        return insertCnt;
    }

    static {
        try {
            QUERY_FILTER_INSERT_SEND_LIST = SqlManager.getQuery("PUSH_RESEND_TARGET", "QUERY_FILTER_INSERT_SEND_LIST");
            QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = SqlManager.getQuery("COMMON", "QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE");
        }
        catch (Exception e) {
            log.error("query load fail", (Throwable)e);
            System.exit(1);
        }
    }
}

