/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.util.SunToLunar;

public class Cal {
    private static final Logger log = LoggerFactory.getLogger(Cal.class);
    private static Date myDate = new Date();

    public static void printWeekValues(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            long date = System.currentTimeMillis() + (long)(86400000 * i);
            log.debug(Cal.getDate(date));
            log.debug(Cal.getWeekDay(date));
            log.debug("/");
            log.debug(Cal.getInnerWeekValue(date));
        }
    }

    protected static String getInnerWeekValue(long time) {
        myDate.setTime(time);
        return DateFormat.WeekDay.getDateTime(myDate).toUpperCase();
    }

    public static synchronized String getWeekDay() {
        return Cal.getWeekDay(System.currentTimeMillis());
    }

    public static synchronized String getWeekDay(long time) {
        myDate.setTime(time);
        return WeekDay.INS.getWeek(DateFormat.WeekDay.getDateTime(myDate).toUpperCase()).toString();
    }

    public static synchronized String getHeaderDate() {
        return Cal.getHeaderDate(System.currentTimeMillis());
    }

    public static synchronized String getHeaderDate(long time) {
        myDate.setTime(time);
        return DateFormat.MailHeaderTime.getDateTime(myDate);
    }

    public static synchronized String getSerialDate() {
        return Cal.getSerialDate(System.currentTimeMillis());
    }

    public static synchronized String getSerialDateMilli() {
        return Cal.getSerialDateMilli(System.currentTimeMillis());
    }

    public static synchronized String getSerialDate(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMMddHHmmss.getDateTime(myDate);
    }

    public static synchronized String getSerialDateMilli(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMMddHHmmssSS.getDateTime(myDate);
    }

    public static synchronized String getYear() {
        return Cal.getYear(System.currentTimeMillis());
    }

    public static synchronized String getYear(long time) {
        myDate.setTime(time);
        return DateFormat.yyyy.getDateTime(myDate);
    }

    public static synchronized String getMonth() {
        return Cal.getMonth(System.currentTimeMillis());
    }

    public static synchronized String getMonth(long time) {
        myDate.setTime(time);
        return DateFormat.MM.getDateTime(myDate);
    }

    public static synchronized String getDay() {
        return Cal.getDay(System.currentTimeMillis());
    }

    public static synchronized String getDay(long time) {
        myDate.setTime(time);
        return DateFormat.dd.getDateTime(myDate);
    }

    public static synchronized String getHour() {
        return Cal.getHour(System.currentTimeMillis());
    }

    public static synchronized String getHour(long time) {
        myDate.setTime(time);
        return DateFormat.HH.getDateTime(myDate);
    }

    public static synchronized String getMin() {
        return Cal.getMin(System.currentTimeMillis());
    }

    public static synchronized String getMin(long time) {
        myDate.setTime(time);
        return DateFormat.mm.getDateTime(myDate);
    }

    public static synchronized String getSec() {
        return Cal.getSec(System.currentTimeMillis());
    }

    public static synchronized String getSec(long time) {
        myDate.setTime(time);
        return DateFormat.ss.getDateTime(myDate);
    }

    public static synchronized String getHHmm() {
        return Cal.getHHmm(System.currentTimeMillis());
    }

    public static synchronized String getHHmm(long time) {
        myDate.setTime(time);
        return DateFormat.HHmm.getDateTime(myDate);
    }

    public static synchronized String getYYYYMM() {
        return Cal.getYYYYMM(System.currentTimeMillis());
    }

    public static synchronized String getYYYYMM(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMM.getDateTime(myDate);
    }

    public static synchronized String getDate() {
        return Cal.getDate(System.currentTimeMillis());
    }

    public static synchronized String getDate(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMMddHHmmss_Std.getDateTime(myDate);
    }

    public static synchronized String getConvertDate(String src) throws ParseException {
        SimpleDateFormat fullTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return fullTime.format(fullTime.parse(src));
    }

    public static synchronized String getHourDate() {
        return Cal.getHourDate(System.currentTimeMillis());
    }

    public static synchronized String getHourDate(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMMddHH.getDateTime(myDate);
    }

    public static synchronized String getMinDate() {
        return Cal.getMinDate(System.currentTimeMillis());
    }

    public static synchronized String getMinDate(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMMddHHmm.getDateTime(myDate);
    }

    public static synchronized String getBoundaryDate() {
        myDate.setTime(System.currentTimeMillis());
        return DateFormat.yyyyMMddHHmmss_Dot.getDateTime(myDate);
    }

    public static synchronized String getDayDate() {
        return Cal.getDayDate(System.currentTimeMillis());
    }

    public static synchronized String getDayDate(long time) {
        myDate.setTime(time);
        return DateFormat.yyyyMMdd.getDateTime(myDate);
    }

    public static synchronized String getAddDayDate(int add_day) {
        return Cal.getDayDate(System.currentTimeMillis() + (long)(add_day * 1000 * 60 * 60) * 24L);
    }

    public static synchronized String getLunarDate() {
        return Cal.getLunarDate(System.currentTimeMillis());
    }

    public static synchronized String getLunarDate(long time) {
        myDate.setTime(time);
        return SunToLunar.Lunar(DateFormat.yyyy.getDateTime(myDate), DateFormat.MM.getDateTime(myDate), DateFormat.dd.getDateTime(myDate));
    }

    public static synchronized String getLunarDate(String year, String month, String day) {
        return SunToLunar.Lunar(year, month, day);
    }

    public static synchronized String getAddLunarDate(int add_day) {
        return Cal.getLunarDate(System.currentTimeMillis() + (long)(add_day * 1000 * 60 * 60) * 24L);
    }

    static enum WeekDay {
        INS;

        private HashMap<String, String> weekHash = new HashMap();

        private WeekDay() {
            this.weekHash.put("SUN", "A1");
            this.weekHash.put("MON", "A2");
            this.weekHash.put("TUE", "A3");
            this.weekHash.put("WED", "A4");
            this.weekHash.put("THU", "A5");
            this.weekHash.put("FRI", "A6");
            this.weekHash.put("SAT", "A7");
        }

        public String getWeek(String s) {
            return this.weekHash.get(s);
        }
    }

    static enum DateFormat {
        yyyyMMddHHmmss("yyyyMMddHHmmss"),
        yyyyMMddHHmmss_Std("yyyy-MM-dd HH:mm:ss"),
        yyyyMMdd("yyyyMMdd"),
        yyyyMMddHH("yyyyMMddHH"),
        yyyyMMddHHmmss_Dot("yyyy.MM.dd.HH.mm.ss"),
        HHmm("HHmm"),
        MailHeaderTime("EEE, dd MMM yyyy HH:mm:ss +0900"),
        WeekDay("E"),
        yyyyMMddHHmmssSS("yyyyMMddHHmmssSS"),
        yyyy("yyyy"),
        MM("MM"),
        dd("dd"),
        mm("mm"),
        HH("HH"),
        ss("ss"),
        yyyyMM("yyyyMM"),
        yyyyMMddHHmm("yyyyMMddHHmm");

        private final Format format;
        private final boolean englishLocale;

        private DateFormat(String s) {
            this.englishLocale = s.substring(0, 1).equalsIgnoreCase("E");
            this.format = this.englishLocale ? FastDateFormat.getInstance((String)s, (Locale)Locale.ENGLISH) : FastDateFormat.getInstance((String)s, (Locale)Locale.getDefault());
        }

        public String getDateTime(Date date) {
            return this.format.format(date);
        }
    }
}

