/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import pluto.util.KeyValueEntry;

public class AmailHashtable
implements Iterator {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    private int modCount = 0;
    private int current_check_index = -1;
    private Entry IteratorNextEntry = null;

    public AmailHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public AmailHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public AmailHashtable() {
        this(11, 0.75f);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized Object remove(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    this.table[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = null;
        try {
            buf = new StringBuffer(1024);
            Iterator it = this.iterator();
            buf.append("{");
            for (int i = 0; i <= max; ++i) {
                Map.Entry e = (Map.Entry)it.next();
                Object key = e.getKey();
                Object value = e.getValue();
                buf.append(key == this ? "(this Map)" : key.toString());
                buf.append("=");
                buf.append(value == this ? "(this Map)" : value.toString());
                if (i >= max) continue;
                buf.append(", ");
            }
            buf.append("}");
            String string = buf.toString();
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            buf = null;
        }
    }

    public synchronized int hashCode() {
        int h = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return h;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                h += e.key.hashCode() ^ e.value.hashCode();
                e = e.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return h;
    }

    public Iterator iterator() {
        this.current_check_index = 0;
        this.IteratorNextEntry = null;
        return this;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.IteratorNextEntry == null) {
            this.IteratorNextEntry = this.table[this.current_check_index];
        } else if (this.IteratorNextEntry.next != null) {
            this.IteratorNextEntry = this.IteratorNextEntry.next;
        } else {
            ++this.current_check_index;
            this.IteratorNextEntry = this.table[this.current_check_index];
        }
        while (this.IteratorNextEntry == null) {
            ++this.current_check_index;
            if (this.current_check_index >= this.table.length) break;
            this.IteratorNextEntry = this.table[this.current_check_index];
        }
        return this.IteratorNextEntry != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.IteratorNextEntry;
    }

    @Override
    public void remove() {
        Entry e = this.IteratorNextEntry;
        Entry prev = null;
        while (e != null) {
            if (e.hash == this.IteratorNextEntry.getKey().hashCode() && e.key.equals(this.IteratorNextEntry.getKey())) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    this.table[this.current_check_index] = e.next;
                }
                --this.count;
                e.value = null;
                return;
            }
            prev = e;
            e = e.next;
        }
    }

    private static class Entry
    implements KeyValueEntry {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }
}

