/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.schedule.ScheduledMonitor;

public class ServerStatusInfo
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(ServerStatusInfo.class);
    private static byte[] SERVER_KEY = new byte[79];
    private static Date myDate = new Date();
    private static long REFRESH_CYCLE = 3600000L;
    private static long CURRENT_REFRESH_TIME = System.currentTimeMillis();
    private static Runtime RUNTIME = Runtime.getRuntime();
    private static boolean INIT_FLAG = false;
    private static int PUSHED_CNT;
    private static int UPDATE_CNT;

    public static synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        SimpleDateFormat DATE_FORMAT = null;
        byte[] serverkey = prop.getProperty("server.key").getBytes();
        if (serverkey.length != 6) {
            throw new RuntimeException("Server Key Invalid : " + new String(serverkey));
        }
        System.arraycopy(serverkey, 0, SERVER_KEY, 0, 6);
        try {
            REFRESH_CYCLE = Long.parseLong(prop.getProperty("refresh.cycle"));
        }
        catch (Exception e) {
            throw new RuntimeException("INVALID NUMBER FORMAT : " + prop.getProperty("refresh.cycle"));
        }
        try {
            DATE_FORMAT = new SimpleDateFormat(prop.getProperty("date.format"));
        }
        catch (Exception e) {
            DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            throw new RuntimeException("INVALID DATE FORMAT : " + prop.getProperty("date.format"));
        }
        myDate.setTime(System.currentTimeMillis());
        String start_time = DATE_FORMAT.format(myDate);
        byte[] dateformat = start_time.getBytes();
        System.arraycopy(dateformat, 0, SERVER_KEY, 6, dateformat.length);
        INIT_FLAG = true;
    }

    public static synchronized void plusPushedCnt() {
        ++PUSHED_CNT;
    }

    public static synchronized void plusUpdateCnt() {
        ++UPDATE_CNT;
    }

    public static synchronized byte[] getStatusInfo() {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!INIT_FLAG) {
            return null;
        }
        if (CURRENT_REFRESH_TIME > System.currentTimeMillis() - REFRESH_CYCLE) {
            return SERVER_KEY;
        }
        myDate.setTime(System.currentTimeMillis());
        String start_time = DATE_FORMAT.format(myDate);
        byte[] dateformat = start_time.getBytes();
        System.arraycopy(dateformat, 0, SERVER_KEY, 26, dateformat.length);
        ServerStatusInfo.SERVER_KEY[78] = 49;
        if (log.isDebugEnabled()) {
            log.debug("PUSHED_CNT:" + PUSHED_CNT);
        }
        ServerStatusInfo.printInt(PUSHED_CNT, 46);
        if (log.isDebugEnabled()) {
            log.debug("UPDATE_CNT:" + UPDATE_CNT);
        }
        ServerStatusInfo.printInt(UPDATE_CNT, 50);
        ServerStatusInfo.printLong(ServerStatusInfo.getDiskTotalSize(), 54);
        ServerStatusInfo.printLong(ServerStatusInfo.getDiskUsedSize(), 58);
        ServerStatusInfo.printLong(ServerStatusInfo.getDiskFreeSize(), 62);
        ServerStatusInfo.printLong(ServerStatusInfo.getMemoryTotal(), 66);
        ServerStatusInfo.printLong(ServerStatusInfo.getMemoryUsed(), 70);
        ServerStatusInfo.printInt(ServerStatusInfo.getCPURate(), 74);
        CURRENT_REFRESH_TIME = System.currentTimeMillis();
        PUSHED_CNT = 0;
        UPDATE_CNT = 0;
        if (log.isDebugEnabled()) {
            log.debug("UPDATE_CNT:" + new String(SERVER_KEY));
        }
        return SERVER_KEY;
    }

    private static long getDiskTotalSize() {
        return 0L;
    }

    private static long getDiskUsedSize() {
        return 0L;
    }

    private static long getDiskFreeSize() {
        return 0L;
    }

    private static long getMemoryTotal() {
        return RUNTIME.totalMemory();
    }

    private static long getMemoryUsed() {
        return RUNTIME.freeMemory();
    }

    private static int getCPURate() {
        return 0;
    }

    private static void printInt(int val, int off) {
        ServerStatusInfo.SERVER_KEY[off + 0] = (byte)(val >>> 0);
        ServerStatusInfo.SERVER_KEY[off + 1] = (byte)(val >>> 8);
        ServerStatusInfo.SERVER_KEY[off + 2] = (byte)(val >>> 16);
        ServerStatusInfo.SERVER_KEY[off + 3] = (byte)(val >>> 24);
    }

    private static void printLong(long _val, int off) {
        int val = (int)(_val / 1024L);
        ServerStatusInfo.SERVER_KEY[off + 0] = (byte)(val >>> 0);
        ServerStatusInfo.SERVER_KEY[off + 1] = (byte)(val >>> 8);
        ServerStatusInfo.SERVER_KEY[off + 2] = (byte)(val >>> 16);
        ServerStatusInfo.SERVER_KEY[off + 3] = (byte)(val >>> 24);
    }

    protected ServerStatusInfo() {
        super(REFRESH_CYCLE, "ServerStatusInfo");
    }

    @Override
    protected void check() throws Exception {
        byte[] aaa = ServerStatusInfo.getStatusInfo();
        if (log.isDebugEnabled()) {
            log.debug(aaa == null ? "null null not init...^^" : new String(aaa));
        }
    }

    static {
        ServerStatusInfo a = new ServerStatusInfo();
        a.start();
        PUSHED_CNT = 0;
        UPDATE_CNT = 0;
    }
}

