/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.TelnetOutputStream;
import pluto.lang.Name;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.util.Cal;

public class SendLogFindActor
extends Name
implements InfoActor {
    private static final Logger log = LoggerFactory.getLogger(SendLogFindActor.class);
    public static String act_dir = null;
    public static String log_dir = null;
    public static String os_str = "win";
    public static final String space_str = " ";
    public static String log_head = "send_";
    public static String log_tail = ".log";
    public static final String chmod_str = "chmod 777";
    public static String cmd_cat = "cat";
    public static String cmd_grep = "grep";
    public static String cmd_pipe = " | ";
    public static int add_file_cnt = 2;
    public static int max_commu_line_cnt = 1000;
    public static int MAX_EXE_CNT = 5;
    public static int NOW_ACT_CNT = 0;
    public int send_cnt = 0;
    public String thread_name = "";
    protected static ArrayList stop_list = new ArrayList();

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        os_str = prop.getProperty("os.str");
        if (os_str.equals("win")) {
            act_dir = SendLogFindActor.separatorReplace(prop.getProperty("grep.dir"), "/");
            log_dir = SendLogFindActor.separatorReplace(prop.getProperty("log.dir"), "/");
            cmd_cat = act_dir + File.separator + "cat ";
            cmd_grep = act_dir + File.separator + "grep ";
        } else {
            act_dir = prop.getProperty("grep.dir");
            log_dir = prop.getProperty("log.dir");
            cmd_cat = "cat ";
            cmd_grep = "grep ";
        }
        log_head = prop.getProperty("log.head");
        log_tail = prop.getProperty("log.tail");
        add_file_cnt = Integer.parseInt(prop.getProperty("add.file.cnt"));
        max_commu_line_cnt = Integer.parseInt(prop.getProperty("max.commu.line"));
        MAX_EXE_CNT = Integer.parseInt(prop.getProperty("max.exe.cnt"));
        cmd_pipe = " | ";
    }

    public void setThreadName(String name) {
        this.thread_name = name;
    }

    public boolean stopYN() {
        return stop_list.contains(this.thread_name);
    }

    public void removeThreadName() {
        stop_list.remove(this.thread_name);
    }

    public SendLogFindActor() {
        this.setName("SendLogFindActor" + Cal.getSerialDate());
    }

    @Override
    public void execute(InfoBeans arg) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(InfoBeans arg, TelnetOutputStream SMTP_BINARY_OUTSTREAM) throws Exception {
        log.info("[execute]...[start]");
        log.info("[THREAD NAME]...[" + this.thread_name + "]");
        Properties prop = arg.getArgs();
        this.send("[NOW_ACT_CNT]" + NOW_ACT_CNT, SMTP_BINARY_OUTSTREAM);
        if (NOW_ACT_CNT > MAX_EXE_CNT) {
            prop.setProperty("RESULT", "[act]over act user=>[max:" + MAX_EXE_CNT + "]");
            return;
        }
        if (this.stopYN()) {
            prop.setProperty("RESULT", "[act]stop order command - excute front");
            return;
        }
        String grep_key = prop.getProperty("USER_ID", "test") + System.currentTimeMillis();
        String srh_word = prop.getProperty("SRH_WORD");
        String srh_word2 = prop.getProperty("SRH_WORD2");
        String start = prop.getProperty("START");
        String end = prop.getProperty("END");
        StringBuffer bat_buffer = new StringBuffer();
        String bat_file = "";
        String msg = "";
        BufferedWriter out = null;
        StringBuffer search_files = new StringBuffer();
        ArrayList file_list = this.file_list(start, end);
        if (file_list == null) {
            prop.setProperty("RESULT", "[act]log_file not found:" + start + "~" + end);
            return;
        }
        int file_list_size = file_list.size();
        for (int i = 0; i < file_list_size; ++i) {
            log.debug("[NOW_ACT_CNT]" + NOW_ACT_CNT + "[I]" + i);
            if (i % add_file_cnt == 0) {
                bat_buffer.setLength(0);
                bat_buffer.append(cmd_cat);
                bat_buffer.append(log_dir + File.separator + (String)file_list.get(i) + space_str);
                search_files.setLength(0);
                search_files.append((String)file_list.get(i));
            } else {
                bat_buffer.append(log_dir + File.separator + (String)file_list.get(i) + space_str);
                search_files.append(space_str + (String)file_list.get(i));
            }
            if (i % add_file_cnt != add_file_cnt - 1 && i != file_list_size - 1) continue;
            bat_buffer.append(cmd_pipe);
            bat_buffer.append(cmd_grep);
            bat_buffer.append(" \"" + srh_word.trim() + "\"");
            if (!srh_word2.equals("")) {
                bat_buffer.append(cmd_pipe);
                bat_buffer.append(cmd_grep);
                bat_buffer.append(" \"" + srh_word2.trim() + "\"");
            }
            bat_file = os_str.equals("win") ? act_dir + File.separator + grep_key + "_" + System.currentTimeMillis() + ".bat" : act_dir + File.separator + grep_key + "_" + System.currentTimeMillis() + ".sh";
            if (log.isDebugEnabled()) {
                log.debug("[bat==>]" + bat_buffer.toString());
            }
            try {
                out = new BufferedWriter(new FileWriter(bat_file));
                out.write(bat_buffer.toString());
                out.newLine();
            }
            catch (Exception e) {
                log.error("Exception", (Throwable)e);
            }
            finally {
                out.close();
            }
            this.send(space_str, SMTP_BINARY_OUTSTREAM);
            this.send("***** [FILE]" + search_files.toString() + " *****", SMTP_BINARY_OUTSTREAM);
            msg = this.commuRuntime(bat_file, SMTP_BINARY_OUTSTREAM);
            log.debug("[SCRIPT]" + bat_buffer.toString());
            log.debug("[SEND_CNT]" + this.send_cnt);
            File act_bat = new File(bat_file);
            boolean fileDel = act_bat.delete();
            if (!fileDel) {
                log.error("File deletion failed");
            }
            if (log.isDebugEnabled()) {
                log.debug("[delete bat==>]" + bat_file);
            }
            if (this.send_cnt <= max_commu_line_cnt && !this.stopYN()) continue;
            if (this.stopYN()) {
                prop.setProperty("RESULT", "[act]stop order command - loof file list " + msg);
            } else {
                prop.setProperty("RESULT", "[act]over max line=>[max:" + max_commu_line_cnt + "] " + msg);
            }
            return;
        }
        if (this.stopYN()) {
            this.removeThreadName();
        }
        prop.setProperty("RESULT", "[act]complate");
        log.debug("[execute]...[end]");
    }

    protected void send(String source, TelnetOutputStream SMTP_BINARY_OUTSTREAM) throws IOException {
        if (source == null) {
            return;
        }
        if (source.length() == 0) {
            SMTP_BINARY_OUTSTREAM.writeln();
        } else {
            SMTP_BINARY_OUTSTREAM.write(source);
            SMTP_BINARY_OUTSTREAM.writeln();
            if (log.isDebugEnabled()) {
                log.info("[COMMU_RESULT]" + source);
            }
        }
    }

    protected String commuRuntime(String cmd, TelnetOutputStream SMTP_BINARY_OUTSTREAM) {
        if (this.send_cnt > max_commu_line_cnt || this.stopYN()) {
            if (this.stopYN()) {
                return "stop order front commuRuntime";
            }
            return "over send_cnt";
        }
        Process process = null;
        try {
            if (!os_str.equals("win")) {
                String chmod_exe = "chmod 777 " + cmd;
                process = Runtime.getRuntime().exec(chmod_exe);
                log.debug("[chmod_str ==>]" + chmod_exe);
                process.waitFor();
            }
            process = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("Cat ") >= 0 || line.indexOf("cat ") >= 0) continue;
                this.send(line, SMTP_BINARY_OUTSTREAM);
                ++this.send_cnt;
                if (this.send_cnt <= max_commu_line_cnt && !this.stopYN()) continue;
                if (this.stopYN()) {
                    return "stop order sending";
                }
                return "over send_cnt";
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return "complate";
    }

    protected ArrayList file_list(String start, String end) {
        int e_time;
        int s_time = Integer.parseInt(start);
        if (s_time > (e_time = Integer.parseInt(end))) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        int year = s_time / 1000000;
        int month = s_time % 1000000 / 10000 - 1;
        int date = s_time % 10000 / 100;
        int hour = s_time % 100;
        cal.set(year, month, date, hour, 0);
        ArrayList<String> fileList = new ArrayList<String>();
        int yyyymmddhh = s_time;
        File log_file = null;
        String log_name = "";
        while (e_time >= yyyymmddhh) {
            log_name = log_head + yyyymmddhh + log_tail;
            log_file = new File(log_dir + File.separator + log_name);
            if (log_file.exists()) {
                fileList.add(log_name);
                if (log.isDebugEnabled()) {
                    log.debug("[yyyymmddhh]" + yyyymmddhh);
                }
            }
            yyyymmddhh = SendLogFindActor.change_date(cal, 1);
        }
        return fileList;
    }

    public static int change_date(Calendar cal, int shour) {
        Calendar ch_day = cal;
        if (shour != 0) {
            ch_day.add(11, shour);
        }
        int year = ch_day.get(1);
        int month = ch_day.get(2) + 1;
        int day = ch_day.get(5);
        int hour = ch_day.get(11);
        return year * 1000000 + month * 10000 + day * 100 + hour;
    }

    public static String separatorReplace(String path, String tag) {
        String path_str = path;
        int point = 0;
        while (path_str.indexOf(tag) >= 0) {
            point = path_str.indexOf(tag);
            path_str = path_str.substring(0, point) + File.separator + path_str.substring(point + 1);
        }
        return path_str;
    }
}

