/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.TelnetOutputStream;
import pluto.ioutil.FileUtil;
import pluto.net.SocketReaderAgent;

public class SocketInputStreamAgent
extends SocketReaderAgent {
    private static final Logger log = LoggerFactory.getLogger(SocketInputStreamAgent.class);
    protected BufferedInputStream SMTP_BINARY_INSTREAM = null;

    public SocketInputStreamAgent() {
    }

    public SocketInputStreamAgent(boolean regist) {
        super(regist);
    }

    @Override
    protected void openConnection() throws IOException {
        this.SMTP_BINARY_INSTREAM = new BufferedInputStream(this.CONNECTED_SOCKET.getInputStream());
        this.SMTP_BINARY_OUTSTREAM = new TelnetOutputStream(this.CONNECTED_SOCKET.getOutputStream());
    }

    @Override
    public void killSession() {
        FileUtil.close(this.SMTP_BINARY_INSTREAM);
        FileUtil.close(this.SMTP_BINARY_OUTSTREAM);
        super.killSession();
    }

    @Override
    protected void send(String source) throws IOException {
        if (source == null) {
            return;
        }
        if (source.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("===> " + source);
            }
            this.SMTP_BINARY_OUTSTREAM.write(source);
            this.SMTP_BINARY_OUTSTREAM.flush();
        }
    }

    @Override
    protected void send(byte[] source) throws IOException {
        if (source == null) {
            return;
        }
        if (source.length > 0) {
            if (log.isDebugEnabled()) {
                log.debug("===> " + new String(source));
            }
            this.SMTP_BINARY_OUTSTREAM.write(source);
            this.SMTP_BINARY_OUTSTREAM.flush();
        }
    }

    protected int receive(byte[] buffer) throws IOException {
        return this.SMTP_BINARY_INSTREAM.read(buffer);
    }
}

