/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.Name;
import pluto.lang.eMsLocale;
import pluto.log.Log;
import pluto.mail.mx.LookupUtil;
import pluto.net.NetworkMonitorable;
import pluto.net.SocketAgentMonitor;

public abstract class SocketAgent
extends Name
implements Log,
NetworkMonitorable {
    private static final Logger log = LoggerFactory.getLogger(SocketAgent.class);
    private static final boolean HOST_DEBUG = false;
    private static final boolean JDK_VERSION_12_ENABLE = false;
    private static final boolean SESSION_DEBUG = false;
    protected static final int STRING_TYPE = 1;
    protected static final int BINARY_TYPE = 2;
    protected Socket CONNECTED_SOCKET = null;
    protected int TIME_OUT = 0;
    protected long COMM_START_TIME = 0L;
    protected String CONNECT_HOST;
    protected int targetPort;
    private boolean __IS_MONITORED__ = false;
    private InnerTmpMonitor INNER_TEMP_MONITOR = null;

    protected SocketAgent() {
        this(false);
    }

    protected SocketAgent(boolean regist) {
        this.__IS_MONITORED__ = regist;
        if (this.__IS_MONITORED__) {
            SocketAgentMonitor.registSocketAgent(this);
        }
    }

    protected void unregist() {
        if (this.__IS_MONITORED__) {
            SocketAgentMonitor.removeSocketAgent(this);
        }
    }

    @Override
    public boolean isIdle() {
        return this.isConnect() && System.currentTimeMillis() - this.COMM_START_TIME > (long)this.TIME_OUT;
    }

    private void foo() {
    }

    @Override
    public void killSession() {
        if (this.CONNECTED_SOCKET != null) {
            try {
                this.CONNECTED_SOCKET.shutdownInput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.CONNECTED_SOCKET.shutdownOutput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.CONNECTED_SOCKET.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.CONNECT_HOST = null;
        this.COMM_START_TIME = -1L;
        if (this.INNER_TEMP_MONITOR != null) {
            this.INNER_TEMP_MONITOR.interrupt();
            this.INNER_TEMP_MONITOR = null;
        }
        this.killSession();
        this.CONNECTED_SOCKET = null;
    }

    public boolean isConnect() {
        if (this.CONNECTED_SOCKET == null) {
            return false;
        }
        return this.CONNECTED_SOCKET.isConnected() && !this.CONNECTED_SOCKET.isClosed();
    }

    protected final void connect(String host, int port) throws IOException {
        this.COMM_START_TIME = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            this.log("Connect Host: " + host);
            this.log("Connect Port: " + String.valueOf(port));
        }
        this.CONNECT_HOST = null;
        String sTargetAddr = null;
        String sTargetIP = null;
        if (host.indexOf("=") > 0) {
            sTargetIP = host.substring(0, host.indexOf("="));
            sTargetAddr = host.substring(host.indexOf("=") + 1);
        } else {
            sTargetAddr = host;
        }
        this.CONNECTED_SOCKET = new Socket(sTargetIP == null ? sTargetAddr : sTargetIP, port);
        this.CONNECT_HOST = sTargetAddr.concat("[").concat(this.CONNECTED_SOCKET.getInetAddress().getHostAddress()).concat("]");
        this.targetPort = this.getLocalPort();
        this.openConnection();
    }

    protected final void connect(String host, int iIP, int port, int timeoutConnect) throws IOException {
        this.COMM_START_TIME = System.currentTimeMillis();
        this.CONNECT_HOST = null;
        InetAddress address = LookupUtil.getInetAddress(iIP);
        try {
            InetAddress localAddress = null;
            localAddress = InetAddress.getByName(eMsLocale.LOCAL_ADDR_IP[0]);
            InetSocketAddress localSa = new InetSocketAddress(localAddress, 0);
            InetSocketAddress remoteSa = new InetSocketAddress(address, port);
            if (log.isDebugEnabled()) {
                log.debug("[LOCAL SET ADDRESS]" + eMsLocale.LOCAL_ADDR_IP);
                log.debug("[RECEIVE ADDRESS][port]" + port + "[iIP]" + address.toString());
                log.debug("[SENDER_InetSocketAddress]" + localSa.getAddress().getHostAddress());
            }
            this.CONNECTED_SOCKET = new Socket();
            this.CONNECTED_SOCKET.bind(localSa);
            this.CONNECTED_SOCKET.connect(remoteSa, timeoutConnect);
            if (log.isDebugEnabled()) {
                log.debug(" [SENDER_Socket_Address]" + this.CONNECTED_SOCKET.getLocalAddress().getHostAddress());
            }
            this.CONNECT_HOST = host.concat("[").concat(address.getHostAddress()).concat("]");
            this.targetPort = this.getLocalPort();
        }
        catch (IOException ie) {
            log.error("[Conn Fail]=>" + address.toString());
            throw ie;
        }
        this.openConnection();
    }

    protected final void connect(Socket host) throws IOException {
        this.COMM_START_TIME = System.currentTimeMillis();
        this.CONNECT_HOST = host.getInetAddress().getHostAddress();
        if (log.isDebugEnabled()) {
            this.log("Connect Host: " + this.CONNECT_HOST);
        }
        this.CONNECTED_SOCKET = host;
        this.openConnection();
    }

    protected final void resetConnectionTime() {
        this.COMM_START_TIME = System.currentTimeMillis();
    }

    protected final long getElapsedTime() {
        return this.COMM_START_TIME > 0L ? System.currentTimeMillis() - this.COMM_START_TIME : 0L;
    }

    protected void send(Object source) throws IOException {
        if (source == null) {
            return;
        }
        if (source instanceof String) {
            this.send((String)source);
        } else if (source instanceof byte[]) {
            this.send((byte[])source);
        } else {
            this.send(source.toString());
        }
    }

    protected boolean setConnectionTimeout(int timeOfTimeout) {
        this.TIME_OUT = timeOfTimeout;
        try {
            this.CONNECTED_SOCKET.setSoTimeout(timeOfTimeout);
            if (!this.__IS_MONITORED__) {
                this.INNER_TEMP_MONITOR = new InnerTmpMonitor(this, timeOfTimeout);
                this.INNER_TEMP_MONITOR.start();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getConnectHost() {
        if (this.CONNECTED_SOCKET == null) {
            return "NC";
        }
        if (!this.isConnect()) {
            return "NC-" + this.CONNECT_HOST;
        }
        return this.CONNECT_HOST;
    }

    public int getTargetPort() {
        if (this.CONNECTED_SOCKET == null) {
            return -1;
        }
        return this.CONNECTED_SOCKET.getPort();
    }

    public int getLocalPort() {
        if (this.CONNECTED_SOCKET == null) {
            return -1;
        }
        return this.CONNECTED_SOCKET.getLocalPort();
    }

    public void log(String logStr) {
        log.debug(this.getName() + "=>" + logStr);
    }

    public void log(String logStr, Throwable e) {
        log.debug(this.getName() + "=>" + logStr);
        log.error(e.getMessage(), e);
    }

    protected abstract void openConnection() throws IOException;

    protected abstract void send(String var1) throws IOException;

    protected abstract void send(byte[] var1) throws IOException;

    static class InnerTmpMonitor
    extends Thread {
        SocketAgent agent = null;
        int TIME_OUT = 0;

        InnerTmpMonitor(SocketAgent a, int timeout) {
            this.agent = a;
            this.TIME_OUT = timeout;
        }

        @Override
        public void run() {
            block5: {
                if (log.isDebugEnabled()) {
                    log.debug("MONITOOR START");
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.TIME_OUT);
                    if (this.agent.isIdle()) {
                        this.agent.killSession();
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.error(e.getMessage());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("MONITOOR END");
            }
        }
    }
}

