/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.mail.mx.MXLookup;

public class UDPMXLookup
extends MXLookup {
    private static final Logger log = LoggerFactory.getLogger(UDPMXLookup.class);
    protected DatagramSocket CONNECTED_SOCKET = null;

    protected UDPMXLookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getDNSResult(InetAddress address, byte[] query, eMsByteArrayOutputStream buffer) throws Throwable {
        int responseLength = -1;
        buffer.ensureSize(512);
        byte[] rawBuffer = buffer.getRawByteArray();
        for (int i = 0; i < 3; ++i) {
            try {
                this.CONNECTED_SOCKET = new DatagramSocket();
                DatagramPacket packet = new DatagramPacket(query, query.length, address, 53);
                this.setConnectionTimeout(2000);
                this.CONNECTED_SOCKET.send(packet);
                DatagramPacket packet2 = new DatagramPacket(rawBuffer, rawBuffer.length);
                this.CONNECTED_SOCKET.receive(packet2);
                responseLength = packet2.getLength();
                break;
            }
            catch (IOException thw) {
                UDPMXLookup.log("IOException occur During DNS Query to:" + address.getHostAddress());
                continue;
            }
            finally {
                this.close();
            }
        }
        return responseLength;
    }

    @Override
    public void close() {
        this.CONNECT_HOST = null;
        this.IN_COMM = false;
        this.COMM_START_TIME = -1L;
        this.killSession();
        this.CONNECTED_SOCKET = null;
    }

    @Override
    public void killSession() {
        if (this.CONNECTED_SOCKET != null) {
            try {
                this.CONNECTED_SOCKET.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.IN_COMM = false;
        }
    }

    @Override
    protected void setConnectionTimeout(int timeOfTimeout) {
        block2: {
            this.TIME_OUT = timeOfTimeout;
            try {
                this.CONNECTED_SOCKET.setSoTimeout(timeOfTimeout);
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block2;
                log.error(e.getMessage());
            }
        }
    }
}

