/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.lang.eMsStringBuffer;
import pluto.log.DisabledMXLogger;
import pluto.mail.mx.DiskCacheController;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.LookupUtil;
import pluto.mail.mx.MXDomain;
import pluto.mail.mx.MXLookup;
import pluto.util.Cal;
import pluto.util.eMsStringTokenizer;

public class MXSearchResult {
    private static final Logger log = LoggerFactory.getLogger(MXSearchResult.class);
    public String TARGET_DOMAIN = null;
    public String TARGET_NS_DOMAIN = null;
    public long SEARCH_TIME = Long.MIN_VALUE;
    public Throwable SEARCH_ERROR = null;
    public transient MXDomain[] mxDomain = null;
    protected int INDEX_OF_FIRST_REFERENCE_SEQUENCE = 0;
    protected int domainIndex = 0;
    protected int size = 0;
    int countErrorRaise = 0;
    int ERROR_TYPE = Integer.MIN_VALUE;
    Throwable ERROR = null;
    String fullName = null;

    public MXSearchResult(String domain) {
        this.TARGET_DOMAIN = domain;
    }

    public final synchronized void touch() {
        MXLookup lookup = null;
        try {
            lookup = MXLookup.getInstance();
            lookup.refesh(this);
            if (log.isDebugEnabled()) {
                log.debug("[touch_in]" + this.toString());
            }
        }
        catch (Throwable thw) {
            this.setError(-2, thw);
        }
        finally {
            MXLookup.recycleInstance(lookup);
        }
    }

    public String getDiskCacheFileName() throws IOException {
        String domain = this.TARGET_DOMAIN;
        String cacheFileName = null;
        String reverseDomain = null;
        eMsStringTokenizer tokenDomainString = null;
        eMsStringBuffer buffer = null;
        try {
            int i = domain.indexOf(".");
            if (i < 0) {
                throw new RuntimeException(domain + " has no '.'");
            }
            buffer = eMsStringBuffer.getInstance();
            buffer.setLength(0);
            buffer.append(domain.substring(i + 1));
            reverseDomain = buffer.reverseString();
            buffer.setLength(0);
            buffer.append(DiskCacheController.sBaseDirectory);
            tokenDomainString = eMsStringTokenizer.getInstance();
            tokenDomainString.parse(reverseDomain, ".");
            while (tokenDomainString.hasMoreTokens()) {
                boolean fileDel;
                buffer.append("/");
                buffer.appendReverse(tokenDomainString.nextToken());
                File checkFile = new File(buffer.toString());
                if (checkFile.exists() && checkFile.isDirectory()) continue;
                if (checkFile.exists() && checkFile.isFile() && !(fileDel = checkFile.delete())) {
                    log.error("File deletion failed");
                }
                checkFile.mkdir();
            }
            buffer.append("/");
            buffer.append(domain);
            cacheFileName = buffer.toString();
        }
        catch (Throwable thw) {
            try {
                log.error("error", thw);
                throw new RuntimeException(thw);
            }
            catch (Throwable throwable) {
                eMsStringTokenizer.recycleInstance(tokenDomainString);
                tokenDomainString = null;
                eMsStringBuffer.recycleInstance(buffer);
                buffer = null;
                throw throwable;
            }
        }
        eMsStringTokenizer.recycleInstance(tokenDomainString);
        tokenDomainString = null;
        eMsStringBuffer.recycleInstance(buffer);
        buffer = null;
        return cacheFileName;
    }

    public void setError(int type, Throwable thw) {
        this.SEARCH_TIME = System.currentTimeMillis();
        this.ERROR = thw;
        this.ERROR_TYPE = type;
        ++this.countErrorRaise;
    }

    public int getError_type() {
        return this.ERROR_TYPE;
    }

    public int getCountErrorRaise() {
        return this.countErrorRaise;
    }

    public Throwable getError() {
        return this.ERROR;
    }

    public boolean isError() {
        return this.ERROR != null;
    }

    public boolean isValidTime() {
        if (log.isDebugEnabled()) {
            log.debug("[MXSearchResult_isValidTime]" + this.toString() + "[term_ttl]" + this.SEARCH_TIME + "[isError]" + this.isError());
        }
        if (this.isError()) {
            boolean re_flag;
            if (log.isDebugEnabled()) {
                log.debug("[isValidTime]... isError! [" + Cal.getDate() + "][LOOKUP_DAY_HH24=>" + LookupCacheManager.LOOKUP_DAY_HH24 + "][" + Cal.getDate(this.SEARCH_TIME + LookupCacheManager.SEARCH_ERROR_DOMAIN_TTL) + "]");
            }
            boolean bl = re_flag = this.SEARCH_TIME + LookupCacheManager.SEARCH_ERROR_DOMAIN_TTL > System.currentTimeMillis();
            if (!re_flag) {
                this.countErrorRaise = 0;
            }
            return re_flag;
        }
        long term_ttl = this.SEARCH_TIME + LookupCacheManager.SEARCH_SUCCESS_DOMAIN_TTL;
        if (term_ttl > System.currentTimeMillis()) {
            if (log.isDebugEnabled()) {
                log.debug("[isValidTime]... use ok! [" + Cal.getDate() + "][LOOKUP_DAY_HH24=>" + LookupCacheManager.LOOKUP_DAY_HH24 + "][" + Cal.getDate(term_ttl) + "]");
            }
            return true;
        }
        if (LookupCacheManager.LOOKUP_DAY_FLAG) {
            int now_hh = 0;
            int now_day = 0;
            int term_hh = 0;
            int term_day = 0;
            term_hh = Integer.parseInt(Cal.getHour(term_ttl));
            if (term_hh > LookupCacheManager.LOOKUP_DAY_HH24) {
                now_day = Integer.parseInt(Cal.getDay());
                term_day = Integer.parseInt(Cal.getDay(term_ttl));
                if (term_day == now_day) {
                    if (log.isDebugEnabled()) {
                        log.debug("[isValidTime_do_next_day]... use ok! [" + Cal.getDate() + "][LOOKUP_DAY_HH24=>" + LookupCacheManager.LOOKUP_DAY_HH24 + "][" + Cal.getDate(term_ttl) + "]");
                    }
                    return true;
                }
            }
            now_hh = Integer.parseInt(Cal.getHour());
            if (log.isDebugEnabled()) {
                log.debug("[isValidTime_do__today]...[" + Cal.getDate() + "][LOOKUP_DAY_HH24=>" + LookupCacheManager.LOOKUP_DAY_HH24 + "][" + Cal.getDate(term_ttl) + "]" + (now_hh < LookupCacheManager.LOOKUP_DAY_HH24));
            }
            return now_hh < LookupCacheManager.LOOKUP_DAY_HH24;
        }
        return false;
    }

    public boolean isValidTimeSucc(long search_time) {
        long term_ttl = search_time + LookupCacheManager.SEARCH_SUCCESS_DOMAIN_TTL;
        if (log.isDebugEnabled()) {
            log.debug("[MXSearchResult_isValidTimeSucc]" + this.toString() + "[term_ttl]" + term_ttl + "[isError]" + this.isError());
        }
        if (term_ttl > System.currentTimeMillis()) {
            return true;
        }
        if (LookupCacheManager.LOOKUP_DAY_FLAG) {
            int now_hh = 0;
            int now_day = 0;
            int term_hh = 0;
            int term_day = 0;
            term_hh = Integer.parseInt(Cal.getHour(term_ttl));
            if (term_hh > LookupCacheManager.LOOKUP_DAY_HH24) {
                now_day = Integer.parseInt(Cal.getDay());
                term_day = Integer.parseInt(Cal.getDay(term_ttl));
                if (term_day == now_day) {
                    if (log.isDebugEnabled()) {
                        log.debug("[isValidTimeSucc_do_next_day]... use ok! [" + Cal.getDate() + "][LOOKUP_DAY_HH24=>" + LookupCacheManager.LOOKUP_DAY_HH24 + "][" + Cal.getDate(term_ttl) + "]");
                    }
                    return true;
                }
            }
            now_hh = Integer.parseInt(Cal.getHour());
            if (log.isDebugEnabled()) {
                log.debug("[isValidTimeSucc_do__today]...[" + Cal.getDate() + "][LOOKUP_DAY_HH24=>" + LookupCacheManager.LOOKUP_DAY_HH24 + "][" + Cal.getDate(term_ttl) + "]" + (now_hh < LookupCacheManager.LOOKUP_DAY_HH24));
            }
            return now_hh < LookupCacheManager.LOOKUP_DAY_HH24;
        }
        return false;
    }

    public void init(int initialCapacity) {
        if (this.mxDomain != null) {
            this.clear();
        }
        this.mxDomain = new MXDomain[initialCapacity];
        for (int i = 0; i < initialCapacity; ++i) {
            this.mxDomain[i] = new MXDomain();
        }
        this.size = initialCapacity;
        this.fullName = null;
        this.ERROR = null;
        this.ERROR_TYPE = Integer.MIN_VALUE;
        this.countErrorRaise = 0;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.mxDomain[i].reset();
        }
        this.fullName = null;
        this.SEARCH_TIME = Long.MIN_VALUE;
    }

    public synchronized void set(int idx, String domain, int ip) {
        this.mxDomain[idx].setHost(domain);
        this.mxDomain[idx].setIp(ip);
    }

    public long getErrorTime(int idx) {
        return this.mxDomain[idx].getErrorTime();
    }

    public synchronized void setMXError(int idx, long errorTime) {
        this.mxDomain[idx].setErrorCnt(this.mxDomain[idx].getErrorCnt() + 1);
        this.mxDomain[idx].setErrorTime(errorTime);
    }

    public synchronized void resetMXError(int idx) {
        this.mxDomain[idx].setErrorTime(-1L);
        this.mxDomain[idx].setErrorCnt(0);
    }

    public synchronized int getMXErrorCnt(int idx) {
        return this.mxDomain[idx].getErrorCnt();
    }

    public int getTargetIndex(int AGENT_INDEX, int SERVER_INDEX) {
        if (this.size < SERVER_INDEX) {
            return -1;
        }
        int TARGET_INDEX = 0;
        if (SERVER_INDEX > this.INDEX_OF_FIRST_REFERENCE_SEQUENCE) {
            if (log.isDebugEnabled()) {
                LookupCacheManager.log("DNSList - TARGET direct IDX:" + String.valueOf(SERVER_INDEX - 1));
            }
            TARGET_INDEX = SERVER_INDEX - 1;
        } else {
            if (log.isDebugEnabled()) {
                LookupCacheManager.log("DNSList - TARGET rotate IDX:" + (AGENT_INDEX + SERVER_INDEX) % this.INDEX_OF_FIRST_REFERENCE_SEQUENCE);
            }
            TARGET_INDEX = (AGENT_INDEX + SERVER_INDEX) % this.INDEX_OF_FIRST_REFERENCE_SEQUENCE;
        }
        TARGET_INDEX = TARGET_INDEX < this.size ? TARGET_INDEX : this.size - 1;
        TARGET_INDEX = TARGET_INDEX < 0 ? 0 : TARGET_INDEX;
        return TARGET_INDEX;
    }

    public synchronized int getTargetIndex() {
        int TARGET_INDEX = -1;
        for (int i = 0; i < this.INDEX_OF_FIRST_REFERENCE_SEQUENCE; ++i) {
            this.domainIndex %= this.INDEX_OF_FIRST_REFERENCE_SEQUENCE;
            ++this.domainIndex;
            if (this.getMXErrorCnt(TARGET_INDEX) <= 100) break;
            if (this.getErrorTime(TARGET_INDEX) + eMsLocale.DISABLED_TIME_OF_MX > System.currentTimeMillis()) {
                if (this.INDEX_OF_FIRST_REFERENCE_SEQUENCE > 0) {
                    DisabledMXLogger.put(this.mxDomain[TARGET_INDEX].getHost() + " is disabled. Use Next mxDomain. ErrorCount : " + this.mxDomain[TARGET_INDEX].getErrorCnt() + ", ErrorTime : " + this.mxDomain[TARGET_INDEX].getErrorTime());
                    TARGET_INDEX = -1;
                    continue;
                }
                if (this.INDEX_OF_FIRST_REFERENCE_SEQUENCE != 1) continue;
                DisabledMXLogger.put(this.mxDomain[TARGET_INDEX].getHost() + " is disabled. ErrorCount : " + this.mxDomain[TARGET_INDEX].getErrorCnt() + ", ErrorTime : " + this.mxDomain[TARGET_INDEX].getErrorTime());
                TARGET_INDEX = -1;
                break;
            }
            this.resetMXError(TARGET_INDEX);
            break;
        }
        return TARGET_INDEX;
    }

    public int getDomainSize() {
        return this.mxDomain.length;
    }

    public synchronized String getDomain(int idx) {
        return this.mxDomain[idx].getHost();
    }

    public synchronized int getIP(int idx) {
        return this.mxDomain[idx].getIp();
    }

    public synchronized String toString() {
        if (this.fullName != null) {
            return this.fullName;
        }
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer();
            buffer.append(this.TARGET_DOMAIN);
            buffer.append(":");
            if (this.isError()) {
                buffer.append(this.ERROR.toString());
            } else {
                for (int i = 0; i < this.size; ++i) {
                    buffer.append("(");
                    buffer.append(this.mxDomain[i].getHost());
                    buffer.append("/");
                    buffer.append(LookupUtil.getIntIPToString(this.mxDomain[i].getIp()));
                    buffer.append(")");
                }
            }
            this.fullName = buffer.toString();
        }
        finally {
            buffer = null;
        }
        return this.fullName;
    }
}

