/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.ioutil.FileUtil;
import pluto.lang.Bits;
import pluto.lang.eMsLocale;
import pluto.mail.mx.DNS;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.LookupUtil;
import pluto.mail.mx.MXSearchResult;
import pluto.mail.mx.exception.InvalidCacheFileFormatException;
import pluto.util.Cal;

public class DiskCacheController {
    private static final Logger log = LoggerFactory.getLogger(DiskCacheController.class);
    public static final short STATE_READ_FROM_CACHE_INVALID = 0;
    public static final short STATE_READ_FROM_CACHE = 1;
    public static final short STATE_CREATE_CACHE = 2;
    static String sBaseDirectory = null;
    static File fileBaseDirectory = null;
    static String[] tmpDomainStringArray = null;

    static final void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        sBaseDirectory = prop.getProperty("disk.cache.base");
        if (sBaseDirectory == null) {
            throw new RuntimeException("[disk.cache.base] parameter is null");
        }
        fileBaseDirectory = new File(sBaseDirectory);
        if (!fileBaseDirectory.exists()) {
            throw new FileNotFoundException("Directory Dose Not Exist:" + sBaseDirectory);
        }
        if (fileBaseDirectory.isFile()) {
            throw new FileNotFoundException("Target Is Not Directory Is File:" + sBaseDirectory);
        }
        tmpDomainStringArray = new String[10];
    }

    static final void log(String log) {
        LookupCacheManager.log(log);
    }

    static final void log(Throwable log) {
        LookupCacheManager.log(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static short checkCacheResult(MXSearchResult result) throws Exception {
        FileInputStream stream;
        byte[] buffer;
        block13: {
            short s;
            int resultType;
            long lSearchTime;
            String sTargetFileName;
            block12: {
                sTargetFileName = result.getDiskCacheFileName();
                File sTargetFile = new File(sTargetFileName);
                if (!sTargetFile.exists()) {
                    if (log.isDebugEnabled()) {
                        DiskCacheController.log(result.TARGET_DOMAIN + ":create cache file target : " + sTargetFileName);
                    }
                    return 2;
                }
                lSearchTime = -1L;
                resultType = -1;
                buffer = null;
                int readSize = -1;
                stream = null;
                buffer = new byte[4];
                stream = new FileInputStream(sTargetFile);
                readSize = stream.read(buffer);
                if (readSize != 4) {
                    throw new InvalidCacheFileFormatException("search time high", 4, readSize);
                }
                lSearchTime = LookupUtil.getLong(buffer, true);
                readSize = stream.read(buffer);
                if (readSize != 4) {
                    throw new InvalidCacheFileFormatException("search time low", 4, readSize);
                }
                lSearchTime += LookupUtil.getLong(buffer, false);
                readSize = stream.read(buffer);
                if (readSize != 4) {
                    throw new InvalidCacheFileFormatException("read search result", 4, readSize);
                }
                resultType = Bits.getInt(buffer, 0);
                if (resultType != 0 || !result.isValidTimeSucc(lSearchTime)) break block12;
                result.SEARCH_TIME = lSearchTime;
                DiskCacheController.readFromCacheToResult(buffer, result, stream);
                short s2 = 1;
                buffer = null;
                FileUtil.close(stream);
                return s2;
            }
            try {
                if (resultType == 0 || resultType == Integer.MIN_VALUE || lSearchTime + LookupCacheManager.SEARCH_ERROR_DOMAIN_TTL <= System.currentTimeMillis()) break block13;
                result.SEARCH_TIME = lSearchTime;
                result.ERROR_TYPE = resultType;
                DiskCacheController.readFromCacheToResult(buffer, result, stream);
                s = 1;
                buffer = null;
            }
            catch (InvalidCacheFileFormatException e) {
                short s3;
                try {
                    if (e instanceof InvalidCacheFileFormatException) {
                        DiskCacheController.log("invalid format file : " + sTargetFileName + "->" + e.toString());
                    } else {
                        DiskCacheController.log("checkCacheResult Exception : " + sTargetFileName + "->" + e.toString());
                        log.error(e.getMessage());
                    }
                    s3 = 0;
                    buffer = null;
                }
                catch (Throwable throwable) {
                    buffer = null;
                    FileUtil.close(stream);
                    throw throwable;
                }
                FileUtil.close(stream);
                return s3;
            }
            FileUtil.close(stream);
            return s;
        }
        buffer = null;
        FileUtil.close(stream);
        return 0;
    }

    static void readFromErrorCacheToResult(byte[] buffer, MXSearchResult result, InputStream stream) throws Exception {
        byte[] messageBuffer;
        int readSize = -1;
        readSize = stream.read(buffer);
        if (readSize != 4) {
            throw new InvalidCacheFileFormatException("get min preference count", 4, readSize);
        }
        int messageSize = Bits.getInt(buffer, 0);
        if (messageSize != (readSize = stream.read(messageBuffer = new byte[messageSize]))) {
            if (log.isDebugEnabled()) {
                throw new RuntimeException("ERROR MESSAGE READ ERROR SIZE:" + String.valueOf(messageSize) + "bytes but read:" + String.valueOf(readSize) + "bytes");
            }
            DiskCacheController.log(result.TARGET_DOMAIN + ":ERROR MESSAGE READ ERROR SIZE:" + String.valueOf(messageSize) + "bytes but read:" + String.valueOf(readSize) + "bytes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readFromCacheToResult(byte[] buffer, MXSearchResult result, InputStream stream) throws Exception {
        int iMinPreferenceDomainCount;
        int readSize = -1;
        readSize = stream.read(buffer);
        if (readSize != 4) {
            throw new InvalidCacheFileFormatException("get min preference count", 4, readSize);
        }
        result.INDEX_OF_FIRST_REFERENCE_SEQUENCE = iMinPreferenceDomainCount = Bits.getInt(buffer, 0);
        readSize = stream.read(buffer);
        if (readSize != 4) {
            throw new InvalidCacheFileFormatException("get etc preference count", 4, readSize);
        }
        int iTotalMXList = iMinPreferenceDomainCount + Bits.getInt(buffer, 0);
        result.init(iTotalMXList);
        eMsByteArrayOutputStream out = null;
        try {
            out = eMsByteArrayOutputStream.getInstance();
            byte[] bufferDomainread = out.getRawByteArray();
            for (int i = 0; i < iTotalMXList; ++i) {
                readSize = stream.read(buffer);
                if (readSize != 4) {
                    throw new InvalidCacheFileFormatException("get domain size", 4, readSize);
                }
                int iDomainSize = Bits.getInt(buffer, 0);
                if (iDomainSize > 1024) {
                    throw new InvalidCacheFileFormatException("1024 byte Domain is Exist=>" + iDomainSize);
                }
                readSize = stream.read(bufferDomainread, 0, iDomainSize);
                if (readSize != iDomainSize) {
                    throw new InvalidCacheFileFormatException("different read size and expect size", iDomainSize, readSize);
                }
                String domain = new String(bufferDomainread, 0, readSize);
                readSize = stream.read(buffer);
                if (readSize != 4) {
                    throw new InvalidCacheFileFormatException("get domain ip", 4, readSize);
                }
                int iIP = Bits.getInt(buffer, 0);
                result.set(i, domain, iIP);
            }
        }
        finally {
            eMsByteArrayOutputStream.recycleInstance(out);
            out = null;
        }
    }

    static void storeResultToCache(MXSearchResult result) throws Exception {
        FileOutputStream stream = null;
        String sCacheFileName = null;
        byte[] buffer = null;
        try {
            sCacheFileName = result.getDiskCacheFileName();
            if (log.isDebugEnabled()) {
                DiskCacheController.log(result + ":save to cache:" + sCacheFileName);
            }
            buffer = new byte[4];
            File sTargetFile = new File(sCacheFileName);
            stream = new FileOutputStream(sTargetFile, false);
            DiskCacheController.writeFromResultToCache(buffer, result, stream);
            buffer = null;
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                buffer = null;
                FileUtil.close(stream);
                stream = null;
                throw throwable;
            }
        }
        FileUtil.close(stream);
        stream = null;
    }

    static void writeFromResultToCache(byte[] buffer, MXSearchResult result, OutputStream stream) throws Exception {
        int readSize = -1;
        LookupUtil.putLong(result.SEARCH_TIME, buffer, true);
        stream.write(buffer, 0, 4);
        LookupUtil.putLong(result.SEARCH_TIME, buffer, false);
        stream.write(buffer, 0, 4);
        Bits.putInt(buffer, 0, result.ERROR_TYPE);
        stream.write(buffer, 0, 4);
        if (result.isError()) {
            String errResult = result.getError().getMessage();
            byte[] errByteResult = errResult.getBytes(eMsLocale.CHAR_SET);
            Bits.putInt(buffer, 0, errByteResult.length);
            stream.write(buffer, 0, 4);
            stream.write(errByteResult);
            return;
        }
        Bits.putInt(buffer, 0, result.INDEX_OF_FIRST_REFERENCE_SEQUENCE);
        stream.write(buffer, 0, 4);
        Bits.putInt(buffer, 0, result.size - result.INDEX_OF_FIRST_REFERENCE_SEQUENCE);
        stream.write(buffer, 0, 4);
        for (int i = 0; i < result.size; ++i) {
            String domain = result.getDomain(i);
            byte[] byteArrayDomain = domain.getBytes(eMsLocale.CHAR_SET);
            Bits.putInt(buffer, 0, byteArrayDomain.length);
            stream.write(buffer, 0, 4);
            stream.write(byteArrayDomain, 0, byteArrayDomain.length);
            Bits.putInt(buffer, 0, result.getIP(i));
            stream.write(buffer, 0, 4);
        }
    }

    static void writeFromResultToNormal(byte[] buffer, MXSearchResult result, OutputStream stream) throws Exception {
        int readSize = -1;
        PrintStream out = new PrintStream(stream, true, "KSC5601");
        out.println("=================== START ===========================");
        out.println("search time:" + Cal.getDate(result.SEARCH_TIME));
        int searchResult = result.ERROR_TYPE;
        out.println("search result:" + DNS.codeName(searchResult));
        if (result.isError()) {
            String errResult = result.getError().getMessage();
            out.println("error message:" + DNS.codeName(searchResult));
            return;
        }
        out.println("min reference size:" + String.valueOf(result.INDEX_OF_FIRST_REFERENCE_SEQUENCE));
        out.println("etc reference size:" + String.valueOf(result.size - result.INDEX_OF_FIRST_REFERENCE_SEQUENCE));
        out.println("=== domain list===");
        for (int i = 0; i < result.size; ++i) {
            String domain = result.getDomain(i);
            int ip = result.getIP(i);
            byte[] byteIP = LookupUtil.getIntToInetByteArray(ip);
            out.print(String.valueOf(i));
            out.print(":");
            out.print(domain);
            out.print("/");
            out.println((byteIP[0] & 0xFF) + "." + (byteIP[1] & 0xFF) + "." + (byteIP[2] & 0xFF) + "." + (byteIP[3] & 0xFF));
        }
        out.println("=================== END ===========================");
    }
}

