/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.mail.filter.FilteringResult;
import pluto.mail.filter.ReturnFilter;

public class MimeDecoder {
    private static final Logger log = LoggerFactory.getLogger(MimeDecoder.class);
    public static final int UNKNOWN_TYPE = -1;
    public static final String CONTENT_ENCODING_BASE64_INDEX = "base64";
    public static final int CONTENT_ENCODING_BASE64 = 1;
    public static final String CONTENT_ENCODING_8BIT_INDEX = "8bit";
    public static final int CONTENT_ENCODING_8BIT = 2;
    public static final String CONTENT_ENCODING_7BIT_INDEX = "7bit";
    public static final int CONTENT_ENCODING_7BIT = 3;
    public static final String CONTENT_ENCODING_QUOTED_PRINTABLE_INDEX = "quoted-printable";
    public static final int CONTENT_ENCODING_QUOTED_PRINTABLE = 4;
    public static final String MESSAGE_DELIVERY_STATUS_START_INDEX = "message/delivery-status";
    public static final int CONTENT_TYPE_MESSAGE_DELIVERY_STATUS = 1;
    public static final String MESSAGE_RFC822_START_INDEX = "message/rfc822";
    public static final int CONTENT_TYPE_MESSAGE_RFC822 = 2;
    public static final String TEXT_PLAIN_START_INDEX = "text/plain";
    public static final int CONTENT_TYPE_TEXT_PLAIN = 3;
    public static final String TEXT_HTML_START_INDEX = "text/html";
    public static final int CONTENT_TYPE_TEXT_HTML = 4;
    public static final String MULTIPART_START_INDEX = "multipart/";
    public static final int CONTENT_TYPE_MULTIPART = 5;
    public static final String CONTENT_TYPE_INDEX = "content-type:";
    public static final String HEADER_TYPE_DELIM = ";";
    public static final String CHAR_SET_INDEX = "charset=\"";
    public static final String CHAR_SET_DELIM = "\"";
    public static final String BOUNDARY_INDEX = "boundary=\"";
    public static final String BOUNDARY_DELIM = "\"";
    public static final String ENCODING_INDEX = "content-transfer-encoding:";
    public static final String ENCODING_DELIM = "\n";
    protected static final char[] CONTENT_TYPE_ELM = " ;\r\n\t\"".toCharArray();

    public static synchronized void init(Object tmp) throws Exception {
    }

    public FilteringResult parseStringType(ReturnFilter filter, String MAIL_BODY) throws Exception {
        int idx_header_limit;
        if (log.isDebugEnabled()) {
            log.debug("PARSE Main start ");
        }
        if ((idx_header_limit = MAIL_BODY.indexOf("\r\n\r\n")) < 0) {
            if (log.isDebugEnabled()) {
                log.debug("Header Limit Null ");
            }
            return null;
        }
        String HeaderElm = MAIL_BODY.substring(0, idx_header_limit).toLowerCase();
        int content_type = this.extractContentType(HeaderElm);
        block0 : switch (content_type) {
            case 5: {
                if (log.isDebugEnabled()) {
                    log.debug("Case MultiPart");
                }
                String boundaryString = "--" + this.extractBoundary(HeaderElm, MAIL_BODY.substring(0, idx_header_limit));
                if (log.isDebugEnabled()) {
                    log.debug("Boundary", (Object)boundaryString);
                }
                int idx_boundary_end = idx_header_limit;
                int idx_boundary_start = MAIL_BODY.indexOf(boundaryString, idx_boundary_end);
                while ((idx_boundary_end = MAIL_BODY.indexOf(boundaryString, idx_boundary_start + boundaryString.length())) >= 0) {
                    FilteringResult returnValue = this.parseStringType(filter, MAIL_BODY.substring(idx_boundary_start + boundaryString.length(), idx_boundary_end));
                    if (returnValue != null) {
                        return returnValue;
                    }
                    idx_boundary_start = idx_boundary_end;
                    if (idx_boundary_start >= 0) continue;
                    break block0;
                }
                break;
            }
            case 2: {
                if (!log.isDebugEnabled()) break;
                log.debug("Case MESSAGE 822:");
                break;
            }
            case 3: 
            case 4: {
                if (log.isDebugEnabled()) {
                    log.debug("Case Text:");
                }
                String charset = this.extractCharSet(HeaderElm);
                int enc_type = this.extractContentEncoding(HeaderElm);
                if (enc_type == -1) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown ENC_TYPE Skip");
                    }
                    return null;
                }
                return this.parseEncodeType(filter, MAIL_BODY.substring(idx_header_limit), charset, enc_type);
            }
        }
        return null;
    }

    public FilteringResult parseEncodeType(ReturnFilter filter, String MAIL_BODY, String charset, int ENC_TYPE) throws Exception {
        return null;
    }

    protected int extractContentType(String HEADER_BODY) {
        int idx1 = HEADER_BODY.indexOf(CONTENT_TYPE_INDEX);
        if (idx1 < 0) {
            if (log.isDebugEnabled()) {
                log.debug("CONTENT_TYPE_INDEX not found", (Object)HEADER_BODY);
            }
            return -1;
        }
        int idx2 = HEADER_BODY.indexOf(HEADER_TYPE_DELIM, idx1 += CONTENT_TYPE_INDEX.length());
        int idx3 = HEADER_BODY.indexOf(10, idx1);
        String type = null;
        type = idx2 < 0 && idx3 < 0 ? HEADER_BODY.substring(idx1).trim() : HEADER_BODY.substring(idx1, idx2 < 0 || idx3 > 0 && idx2 > idx3 ? idx3 : idx2).trim();
        if (type.startsWith(MULTIPART_START_INDEX)) {
            return 5;
        }
        if (type.equals(MESSAGE_DELIVERY_STATUS_START_INDEX)) {
            return 1;
        }
        if (type.equals(MESSAGE_RFC822_START_INDEX)) {
            return 2;
        }
        if (type.equals(TEXT_PLAIN_START_INDEX)) {
            return 3;
        }
        if (type.equals(TEXT_HTML_START_INDEX)) {
            return 4;
        }
        log.debug("UNREGIST CONTENT TYPE: ", (Object)type);
        return -1;
    }

    protected String extractCharSet(String HEADER_BODY) {
        int idx1 = HEADER_BODY.indexOf(CHAR_SET_INDEX);
        if (idx1 < 0) {
            return null;
        }
        int idx2 = HEADER_BODY.indexOf("\"", idx1 += CHAR_SET_INDEX.length());
        if (idx2 < 0) {
            return null;
        }
        return HEADER_BODY.substring(idx1, idx2).trim();
    }

    protected String extractBoundary(String HEADER_BODY, String org) {
        int idx1 = HEADER_BODY.indexOf(BOUNDARY_INDEX);
        if (idx1 < 0) {
            return null;
        }
        int idx2 = HEADER_BODY.indexOf("\"", idx1 += BOUNDARY_INDEX.length());
        if (idx2 < 0) {
            return null;
        }
        return org.substring(idx1, idx2).trim();
    }

    protected int extractContentEncoding(String HEADER_BODY) {
        String type;
        int idx1 = HEADER_BODY.indexOf(ENCODING_INDEX);
        if (idx1 < 0) {
            if (log.isDebugEnabled()) {
                log.debug("ENCODING_INDEX not found so default 8BIT...", (Object)HEADER_BODY);
            }
            return 2;
        }
        int idx2 = HEADER_BODY.indexOf(ENCODING_DELIM, idx1 += ENCODING_INDEX.length());
        if (idx2 < 0) {
            idx2 = HEADER_BODY.length();
        }
        if ((type = HEADER_BODY.substring(idx1, idx2).trim()).equals(CONTENT_ENCODING_BASE64_INDEX)) {
            return 1;
        }
        if (type.equals(CONTENT_ENCODING_8BIT_INDEX)) {
            return 2;
        }
        if (type.equals(CONTENT_ENCODING_7BIT_INDEX)) {
            return 3;
        }
        if (type.equals(CONTENT_ENCODING_QUOTED_PRINTABLE_INDEX)) {
            return 4;
        }
        log.error("UNREGIST ENCODING TYPE: ", (Object)type);
        return -1;
    }
}

