/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.mail.DNSGroupResolver;
import pluto.mail.DNSList;
import pluto.mail.RelayDNSList;
import pluto.net.NetAddress;
import pluto.schedule.ScheduledMonitor;
import pluto.util.AmailHashtable;
import pluto.util.FIFOBuffer;
import pluto.util.KeyValueEntry;
import pluto.util.eMsStringTokenizer;

public class LookupContainer
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(LookupContainer.class);
    private static AmailHashtable HASH_OF_DNS_LIST = null;
    public static int DNS_RESOLVER_LIST_LENGTH = 0;
    public static long MX_REFRESH_CYCLE = 129600000L;
    public static long A_REFRESH_CYCLE = 43200000L;
    protected static InetAddress[] DNS_RESOLVER_LIST = null;
    private static LogChannel LOG_CHANNEL = null;
    private static FIFOBuffer RESOLVER_CONTAINER = null;
    private static LookupContainer INNER_CONTAINER_INSTANCE = null;
    private static boolean RELAY_SERVER_PRESENT = false;
    private static String RELAY_SERVER_IP = null;
    private static DNSList RELAY_DNS_LIST = null;
    private static final Object LOCK_OF_LIST_CREATE;

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        String sChannelID = tmp.getProperty("logger");
        if (sChannelID != null) {
            LOG_CHANNEL = LogChannelContainer.get(sChannelID);
        }
        boolean bl = RELAY_SERVER_PRESENT = (RELAY_SERVER_IP = tmp.getProperty("relay.server")) != null;
        if (RELAY_SERVER_PRESENT) {
            RELAY_DNS_LIST = new RelayDNSList(RELAY_SERVER_IP);
        }
        String tmpSize = tmp.getProperty("max.connection.contain", "50");
        try {
            RESOLVER_CONTAINER = new FIFOBuffer(Integer.parseInt(tmpSize));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            RESOLVER_CONTAINER = new FIFOBuffer(50);
        }
        String tmpRefreshCycle = tmp.getProperty("refresh.cycle");
        if (tmpRefreshCycle == null) {
            throw new RuntimeException("refresh.cycle parameter is not set");
        }
        try {
            A_REFRESH_CYCLE = Long.parseLong(tmpRefreshCycle);
            MX_REFRESH_CYCLE = A_REFRESH_CYCLE * 3L;
        }
        catch (Exception e) {
            log.error("LookupContainer", (Object)"exec error", (Object)e);
        }
        String tmplist = tmp.getProperty("server.list");
        if (tmplist == null) {
            throw new RuntimeException("server.list parameter is not set");
        }
        eMsStringTokenizer TOKEN = new eMsStringTokenizer(tmplist, ";");
        LinkedList<String> list = new LinkedList<String>();
        while (TOKEN.hasMoreTokens()) {
            list.add(TOKEN.nextToken());
        }
        DNS_RESOLVER_LIST_LENGTH = list.size();
        DNS_RESOLVER_LIST = new InetAddress[DNS_RESOLVER_LIST_LENGTH];
        for (int i = 0; i < DNS_RESOLVER_LIST_LENGTH; ++i) {
            LookupContainer.DNS_RESOLVER_LIST[i] = NetAddress.getInetAddress(list.get(i).toString());
        }
        try {
            int i;
            int tmpInitSize = Integer.parseInt(tmp.getProperty("init.connection.contain", "10"));
            DNSGroupResolver[] arraySimpleResolver = new DNSGroupResolver[tmpInitSize];
            for (i = 0; i < tmpInitSize; ++i) {
                arraySimpleResolver[i] = LookupContainer.getInstance();
            }
            for (i = 0; i < tmpInitSize; ++i) {
                LookupContainer.recycleInstance(arraySimpleResolver[i]);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
        String tmpMonitorCycle = tmp.getProperty("dns.monitor.cycle");
        if (tmpMonitorCycle == null) {
            throw new RuntimeException("dns.monitor.cycle parameter is not set");
        }
        try {
            INNER_CONTAINER_INSTANCE = new LookupContainer(Long.parseLong(tmpMonitorCycle));
            INNER_CONTAINER_INSTANCE.start();
        }
        catch (Exception e) {
            log.error("LookupContainer", (Object)"exec error", (Object)e);
        }
    }

    protected static synchronized DNSGroupResolver getInstance() {
        Object returnValue = RESOLVER_CONTAINER.pop();
        if (returnValue != null) {
            return (DNSGroupResolver)returnValue;
        }
        try {
            DNSGroupResolver res = new DNSGroupResolver(DNS_RESOLVER_LIST, 53);
            return res;
        }
        catch (Throwable e) {
            log.error("LookupContainer", (Object)"resolver create error", (Object)e);
            LookupContainer.log("DNSGroupResolver creation error");
            LookupContainer.log(e);
            return null;
        }
    }

    protected static void recycleInstance(DNSGroupResolver tmp) {
        if (tmp == null) {
            return;
        }
        RESOLVER_CONTAINER.push(tmp);
    }

    public static synchronized void log(String logStr) {
        if (LOG_CHANNEL == null) {
            log.info("LookupContainer", (Object)("log:" + logStr));
        } else {
            try {
                LOG_CHANNEL.write(logStr);
            }
            catch (Exception e) {
                log.error("LookupContainer", (Object)"log write error", (Object)e);
            }
        }
    }

    public static synchronized void log(Throwable thr) {
        if (LOG_CHANNEL == null) {
            log.info("log channel is null", thr);
        } else {
            try {
                LOG_CHANNEL.write(thr);
            }
            catch (Exception e) {
                log.error("log write error", (Throwable)e);
            }
        }
    }

    public static Throwable isInvalidDomain(String domain) {
        if (RELAY_SERVER_PRESENT) {
            return null;
        }
        DNSList tmpList = (DNSList)HASH_OF_DNS_LIST.get(domain);
        if (tmpList != null && tmpList.isError()) {
            return tmpList.getErrorMsg();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DNSList getDNSList(String domain) {
        if (RELAY_SERVER_PRESENT) {
            return RELAY_DNS_LIST;
        }
        DNSList tmpList = (DNSList)HASH_OF_DNS_LIST.get(domain);
        if (tmpList != null) {
            return tmpList;
        }
        if (log.isDebugEnabled()) {
            log.debug("LookupContainer", (Object)"MissDomain-getDNSList", (Object)domain);
        }
        Object object = LOCK_OF_LIST_CREATE;
        synchronized (object) {
            tmpList = new DNSList(domain);
            HASH_OF_DNS_LIST.put(domain, tmpList);
            return tmpList;
        }
    }

    public static synchronized void registeDNSList(String domain, DNSList list) {
        if (RELAY_SERVER_PRESENT) {
            return;
        }
        HASH_OF_DNS_LIST.put(domain, list);
    }

    LookupContainer(long inter) {
        super(inter, "DNS Inner Monitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void check() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("INNER DNS LIST CHECK START");
        }
        StringBuffer tmpBuffer = new StringBuffer(128);
        try {
            Iterator iter = HASH_OF_DNS_LIST.iterator();
            while (iter.hasNext()) {
                KeyValueEntry a = (KeyValueEntry)iter.next();
                String key = a.getKey().toString();
                DNSList value = (DNSList)a.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("CHECK", (Object)key);
                }
                value.refreshMXRecored(tmpBuffer);
            }
        }
        finally {
            tmpBuffer = null;
        }
    }

    static {
        HASH_OF_DNS_LIST = new AmailHashtable(1000);
        LOCK_OF_LIST_CREATE = new Object();
    }
}

