/*
 * Decompiled with CFR 0.152.
 */
package pluto.live.monitor;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.live.monitor.MonitorInfoCollectorChecker;
import pluto.util.StringUtil;

public class MonitorInfoCollector {
    private static final Logger log = LoggerFactory.getLogger(MonitorInfoCollector.class);
    private static MonitorInfoCollector monitorInfoCollector = new MonitorInfoCollector();
    public static boolean canCollect = false;
    public static int CntClean = 0;
    private static int CntPush = 0;
    private static int CntPushSuccess = 0;
    private static int CntPushFail = 0;
    private static int CntUpdate = 0;
    private static int CntUpdateSuccess = 0;
    private static int CntUpdateFail = 0;
    private static int CntUpdateOpen = 0;
    private static int CntUpdateClick = 0;
    private static int CntUpdateResearch = 0;
    private static int CntDBConError = 0;
    private static Vector DomainList = new Vector();
    private static int[] CntDomainPush;
    private static int[] CntDomainFail;
    private static int DomainListNum;
    private static int DomainListMax;
    private static final int DEF_DOMAINLIST_MAX = 10;
    private static final String DEF_DELIM = ",";
    private static final int DEF_DOMAIN_PUSH = 1;
    private static final int DEF_DOMAIN_FAIL = 0;

    public static synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        try {
            DomainListMax = Integer.parseInt(prop.getProperty("domain.list.max"));
        }
        catch (Exception e) {
            DomainListMax = 10;
        }
        CntDomainPush = new int[DomainListMax];
        CntDomainFail = new int[DomainListMax];
        canCollect = true;
        MonitorInfoCollector.setDomainList(prop.getProperty("domain.list", ""));
    }

    private MonitorInfoCollector() {
        try {
            MonitorInfoCollectorChecker.init(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MonitorInfoCollector getInstance() {
        return monitorInfoCollector;
    }

    public static synchronized void setDomainList(Vector domainList) {
        DomainList = domainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static synchronized void setDomainList(String domainList) {
        if (domainList == null) {
            return;
        }
        StringTokenizer oSt = new StringTokenizer(domainList, DEF_DELIM);
        String sDomain = "";
        if (DomainListNum > 0) {
            DomainListNum = 0;
            DomainList.clear();
        }
        while (oSt.hasMoreTokens()) {
            if (DomainListNum >= DomainListMax) return;
            sDomain = oSt.nextToken();
            if (StringUtil.isNull(sDomain)) continue;
            DomainList.add(DomainListNum, sDomain.toLowerCase());
            int[] nArray = CntDomainPush;
            // MONITORENTER : CntDomainPush
            MonitorInfoCollector.CntDomainPush[MonitorInfoCollector.DomainListNum] = 0;
            // MONITOREXIT : nArray
            nArray = CntDomainFail;
            // MONITORENTER : CntDomainFail
            MonitorInfoCollector.CntDomainFail[MonitorInfoCollector.DomainListNum] = 0;
            // MONITOREXIT : nArray
            ++DomainListNum;
        }
    }

    public static synchronized Vector getDomainList() {
        return DomainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addCntDomain(String domain, int type) {
        int nIdx = DomainList.indexOf(domain.toLowerCase());
        if (nIdx == -1) {
            return;
        }
        switch (type) {
            case 1: {
                int[] nArray = CntDomainPush;
                synchronized (CntDomainPush) {
                    int n = nIdx;
                    CntDomainPush[n] = CntDomainPush[n] + 1;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            case 0: {
                int[] nArray = CntDomainFail;
                synchronized (CntDomainFail) {
                    int n = nIdx;
                    CntDomainFail[n] = CntDomainFail[n] + 1;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    public static void addCntDomainPush(String domain) {
        if (!canCollect) {
            return;
        }
        if (domain == null || DomainListNum < 1) {
            return;
        }
        MonitorInfoCollector.addCntDomain(domain, 1);
    }

    public static void addCntDomainFail(String domain) {
        if (!canCollect) {
            return;
        }
        if (domain == null || DomainListNum < 1) {
            return;
        }
        MonitorInfoCollector.addCntDomain(domain, 0);
    }

    public static void printDomainCnt() {
        for (int i = 0; i < DomainListNum; ++i) {
            System.out.print(DomainList.get(i) + " , " + String.valueOf(CntDomainPush[i]) + " , " + String.valueOf(CntDomainFail[i]));
        }
        log.debug("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static synchronized void cleanCnt() {
        CntPush = 0;
        CntPushSuccess = 0;
        CntPushFail = 0;
        CntUpdate = 0;
        CntUpdateSuccess = 0;
        CntUpdateFail = 0;
        CntUpdateOpen = 0;
        CntUpdateClick = 0;
        CntUpdateResearch = 0;
        CntDBConError = 0;
        if (DomainListNum > 0) {
            int[] nArray = CntDomainPush;
            // MONITORENTER : CntDomainPush
            int[] nArray2 = CntDomainFail;
            // MONITORENTER : CntDomainFail
            for (int i = 0; i < DomainListNum; ++i) {
                MonitorInfoCollector.CntDomainPush[i] = 0;
                MonitorInfoCollector.CntDomainFail[i] = 0;
            }
            // MONITOREXIT : nArray2
            // MONITOREXIT : nArray
        }
        ++CntClean;
    }

    public static synchronized int getCntClean() {
        return CntClean;
    }

    public static synchronized void setCntClean(int cntClean) {
        CntClean = cntClean;
    }

    public static synchronized int getCntDBConError() {
        return CntDBConError;
    }

    public static synchronized void addCntDBConError() {
        ++CntDBConError;
    }

    public static synchronized int[] getCntDomainFail() {
        return CntDomainFail;
    }

    public static synchronized int[] getCntDomainPush() {
        return CntDomainPush;
    }

    public static synchronized int getCntPush() {
        return CntPush;
    }

    public static synchronized void addCntPush() {
        ++CntPush;
    }

    public static synchronized int getCntPushFail() {
        return CntPushFail;
    }

    public static synchronized void addCntPushFail() {
        ++CntPushFail;
    }

    public static synchronized int getCntPushSuccess() {
        return CntPushSuccess;
    }

    public static synchronized void addCntPushSuccess() {
        ++CntPushSuccess;
    }

    public static synchronized int getCntUpdate() {
        return CntUpdate;
    }

    public static synchronized void addCntUpdate() {
        ++CntUpdate;
    }

    public static synchronized int getCntUpdateClick() {
        return CntUpdateClick;
    }

    public static synchronized void addCntUpdateClick() {
        ++CntUpdateClick;
    }

    public static synchronized int getCntUpdateFail() {
        return CntUpdateFail;
    }

    public static synchronized void addCntUpdateFail() {
        ++CntUpdateFail;
    }

    public static synchronized int getCntUpdateOpen() {
        return CntUpdateOpen;
    }

    public static synchronized void addCntUpdateOpen() {
        ++CntUpdateOpen;
    }

    public static synchronized int getCntUpdateResearch() {
        return CntUpdateResearch;
    }

    public static synchronized void addCntUpdateResearch() {
        ++CntUpdateResearch;
    }

    public static synchronized int getCntUpdateSuccess() {
        return CntUpdateSuccess;
    }

    public static synchronized void addUpdateSuccess() {
        ++CntUpdateSuccess;
    }

    public static void main(String[] args) {
        Properties oProp = new Properties();
        oProp.setProperty("domain.list.max", "10");
        try {
            MonitorInfoCollector.init(oProp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MonitorInfoCollector.setDomainList("hanmail.net,L2club.com,daum.net,naver.com,nate.com,hanmir.com,amail.co.kr");
        Vector vTmp = MonitorInfoCollector.getDomainList();
        log.debug(vTmp.toString());
    }

    static {
        DomainListNum = 0;
        DomainListMax = 0;
    }
}

