/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.IOException;
import pluto.io.StreamFileReader;
import pluto.lang.eMsLocale;

public class eMsDelimitateStreamFileReader
extends StreamFileReader {
    byte[] __DELIM_BYTE__ = null;
    int __DELIM_SIZE__ = 0;

    public eMsDelimitateStreamFileReader(String filename, String delim) throws Exception {
        this(filename, delim.getBytes(eMsLocale.CHAR_SET));
    }

    public eMsDelimitateStreamFileReader(String filename, byte[] delim) throws Exception {
        super(filename);
        this.__DELIM_BYTE__ = delim;
        this.__DELIM_SIZE__ = this.__DELIM_BYTE__.length;
        if (this.__DELIM_BYTE__ == null || this.__DELIM_SIZE__ == 0) {
            throw new IOException("Invalid Delim");
        }
    }

    @Override
    protected int findNextLineDelimIndex(int OFFSET) {
        while (OFFSET + this.__DELIM_SIZE__ < this.__BUFFER_SIZE__) {
            if (this.match(OFFSET)) {
                return OFFSET;
            }
            ++OFFSET;
        }
        return -1;
    }

    private boolean match(int OFFSET) {
        for (int idx = 0; idx < this.__DELIM_SIZE__; ++idx) {
            if (this.__READ_BUFFER__[OFFSET + idx] == this.__DELIM_BYTE__[idx]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void skipLineFirst() {
    }

    @Override
    protected int skipLineDelim(int OFFSET) {
        this.__SKIP_REMAIN_FLAG__ = false;
        if (OFFSET + this.__DELIM_SIZE__ > this.__BUFFER_SIZE__) {
            this.__SKIP_REMAIN_FLAG__ = true;
            this.__SKIP_REMAIN_COUNT__ = this.__BUFFER_SIZE__ - OFFSET - this.__DELIM_SIZE__;
            return -1;
        }
        return OFFSET + this.__DELIM_SIZE__;
    }
}

