/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UUEncodeOutputStream
extends BufferedOutputStream {
    private byte[] buffer;
    private int bufsize;
    private boolean wrotePrefix = false;
    protected String name;
    protected int mode;

    public UUEncodeOutputStream(OutputStream out) {
        this(out, "encoder.buf", 644);
    }

    public UUEncodeOutputStream(OutputStream out, String s, int i) {
        super(out);
        this.name = s;
        this.mode = i;
        this.buffer = new byte[45];
    }

    public void setNameMode(String s, int i) {
        this.name = s;
        this.mode = i;
    }

    @Override
    public synchronized void write(byte[] source, int i, int j) throws IOException {
        for (int k = 0; k < j; ++k) {
            this.write(source[i + k]);
        }
    }

    @Override
    public void write(byte[] source) throws IOException {
        this.write(source, 0, source.length);
    }

    @Override
    public synchronized void write(int i) throws IOException {
        this.buffer[this.bufsize++] = (byte)i;
        if (this.bufsize == 45) {
            this.writePrefix();
            this.encode();
            this.bufsize = 0;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.bufsize > 0) {
            this.writePrefix();
            this.encode();
        }
        this.writeSuffix();
        super.flush();
    }

    private void writePrefix() throws IOException {
        if (!this.wrotePrefix) {
            String a = "begin " + this.mode + " " + this.name + "\r\n";
            super.write(a.getBytes(), 0, a.getBytes().length);
            this.wrotePrefix = true;
        }
    }

    private void writeSuffix() throws IOException {
        String a = " \nend\r\n";
        super.write(a.getBytes(), 0, a.getBytes().length);
    }

    private void encode() throws IOException {
        int i1 = 0;
        super.write((this.bufsize & 0x3F) + 32);
        while (i1 < this.bufsize) {
            byte byte2;
            byte byte1;
            byte byte0 = this.buffer[i1++];
            if (i1 < this.bufsize) {
                byte1 = this.buffer[i1++];
                byte2 = i1 < this.bufsize ? this.buffer[i1++] : (byte)1;
            } else {
                byte1 = 1;
                byte2 = 1;
            }
            int i = byte0 >>> 2 & 0x3F;
            int j = byte0 << 4 & 0x30 | byte1 >>> 4 & 0xF;
            int k = byte1 << 2 & 0x3C | byte2 >>> 6 & 3;
            int l = byte2 & 0x3F;
            super.write(i + 32);
            super.write(j + 32);
            super.write(k + 32);
            super.write(l + 32);
        }
        super.write(10);
    }
}

