/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.FileElement;

public class HttpFileElement
extends FileElement {
    private static final Logger log = LoggerFactory.getLogger(HttpFileElement.class);
    HttpURLConnection m_client = null;

    protected HttpFileElement() throws Exception {
    }

    @Override
    public InputStream getStream() throws Exception {
        URL myURL = new URL(HttpFileElement.converValidUrl(this.FileUrl.trim()));
        int __RESPONSE_CODE__ = 0;
        try {
            this.m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = this.m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = this.m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(this.FileUrl));
            }
            case 500: {
                throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(this.FileUrl));
            }
            case 406: {
                throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(this.FileUrl));
            }
            case 404: {
                throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(this.FileUrl));
            }
            case 503: {
                throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(this.FileUrl));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(this.m_client.getResponseMessage().concat("=>").concat(this.FileUrl));
            }
        }
        return this.m_client.getInputStream();
    }

    @Override
    public void close() {
        if (this.m_client != null) {
            try {
                this.m_client.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String converValidUrl(String url) {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(256);
            buffer.append(url.replaceAll("\\ ", "%20"));
            if (log.isDebugEnabled()) {
                log.debug(buffer.toString());
            }
            String string = buffer.toString();
            return string;
        }
        catch (Throwable t) {
            log.error("error", t);
            String string = url;
            return string;
        }
        finally {
            buffer = null;
        }
    }
}

