/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.BASE64EncodeOutputStream;
import pluto.io.LocalFileElement;
import pluto.io.QPEncodeOutputStream;
import pluto.io.UUEncodeOutputStream;
import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsFileWriter;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;
import pluto.util.Cal;

public abstract class FileElement {
    private static final Logger log = LoggerFactory.getLogger(FileElement.class);
    protected String Name = null;
    protected String Attention = null;
    protected String FileUrl = null;
    protected int FileSize = 0;
    protected static Class __DEFAULT_CLASS__ = null;
    protected static Hashtable map = new Hashtable();

    public static synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        map = new Hashtable();
        Enumeration<?> eNum = prop.propertyNames();
        while (eNum.hasMoreElements()) {
            String name = (String)eNum.nextElement();
            if (!name.startsWith("index.")) continue;
            map.put(name.substring(name.indexOf(".") + 1), Class.forName(prop.getProperty(name)));
        }
    }

    protected FileElement() throws Exception {
    }

    public void parse(String url) throws Exception {
        this.FileUrl = url = url.replace('\\', '/');
        int idx = this.FileUrl.lastIndexOf("/");
        if (idx < 0) {
            throw new Exception("Invalid File Name " + this.FileUrl);
        }
        int idx_tmp = this.FileUrl.lastIndexOf("=");
        this.Name = this.FileUrl.substring(idx_tmp > idx ? idx_tmp + 1 : idx + 1);
        if (this.Name.trim().length() < 1) {
            throw new Exception("Invalid File Name " + this.FileUrl);
        }
        idx = this.Name.indexOf(".");
        this.Attention = idx < 0 ? null : this.Name.substring(idx + 1);
    }

    public String getName() {
        return this.Name;
    }

    public String getAttention() {
        return this.Attention;
    }

    public int getFileSize() {
        return this.FileSize;
    }

    public String getFileUrl() {
        return this.FileUrl;
    }

    public String getFileBody() throws Exception {
        return this.getFileBody(4, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    public String getFileBody(int enc_type) throws Exception {
        return this.getFileBody(enc_type, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    public String getFileBody(int enc_type, String charset) throws Exception {
        InputStream in = this.getStream();
        if (in == null) {
            throw new IOException("Stream is NULL or Not Available");
        }
        eMsByteArrayOutputStream __BUFFER__ = null;
        byte[] buffer = null;
        String returnValue = null;
        try {
            int bytes;
            __BUFFER__ = eMsByteArrayOutputStream.getInstance();
            __BUFFER__.flush();
            __BUFFER__.reset();
            buffer = ByteArrayContainer.getInstance();
            OutputStream __OUT__ = null;
            switch (enc_type) {
                case 1: {
                    __OUT__ = new BASE64EncodeOutputStream(__BUFFER__);
                    break;
                }
                case 2: {
                    __OUT__ = new QPEncodeOutputStream(__BUFFER__);
                    break;
                }
                case 3: {
                    __OUT__ = new UUEncodeOutputStream(__BUFFER__);
                    break;
                }
                default: {
                    __OUT__ = __BUFFER__;
                }
            }
            while ((bytes = in.read(buffer)) >= 0) {
                __OUT__.write(buffer, 0, bytes);
            }
            in.close();
            __OUT__.flush();
            __BUFFER__.flush();
            returnValue = __BUFFER__.toString(charset == null ? eMsLocale.FILE_SYSTEM_IN_CHAR_SET : charset);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ByteArrayContainer.recycleInstance(buffer);
                eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
                throw throwable;
            }
        }
        ByteArrayContainer.recycleInstance(buffer);
        eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
        return returnValue;
    }

    public String getFileBody(int enc_type, String charsetFrom, String charsetTo) throws Exception {
        InputStream in = this.getStream();
        if (in == null) {
            throw new IOException("Stream is NULL or Not Available");
        }
        eMsByteArrayOutputStream __BUFFER__ = null;
        byte[] buffer = null;
        String returnValue = null;
        try {
            int bytes;
            __BUFFER__ = eMsByteArrayOutputStream.getInstance();
            byte[] rsltBuffer = null;
            __BUFFER__.flush();
            __BUFFER__.reset();
            buffer = ByteArrayContainer.getInstance();
            OutputStream __OUT__ = null;
            switch (enc_type) {
                case 1: {
                    __OUT__ = new BASE64EncodeOutputStream(__BUFFER__);
                    break;
                }
                case 2: {
                    __OUT__ = new QPEncodeOutputStream(__BUFFER__);
                    break;
                }
                case 3: {
                    __OUT__ = new UUEncodeOutputStream(__BUFFER__);
                    break;
                }
                default: {
                    __OUT__ = __BUFFER__;
                }
            }
            while ((bytes = in.read(buffer)) >= 0) {
                __OUT__.write(buffer, 0, bytes);
            }
            in.close();
            __OUT__.flush();
            __BUFFER__.flush();
            returnValue = __BUFFER__.toString(charsetFrom == null ? eMsLocale.FILE_SYSTEM_IN_CHAR_SET : charsetFrom);
            rsltBuffer = returnValue.getBytes(charsetTo);
            returnValue = new String(rsltBuffer, charsetTo);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ByteArrayContainer.recycleInstance(buffer);
                eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
                throw throwable;
            }
        }
        ByteArrayContainer.recycleInstance(buffer);
        eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
        return returnValue;
    }

    public void putStream(OutputStream out) throws Exception {
        InputStream in = this.getStream();
        if (in == null) {
            throw new IOException("Stream is NULL or Not Available");
        }
        byte[] buffer = ByteArrayContainer.getInstance();
        try {
            int bytes;
            while ((bytes = in.read(buffer)) >= 0) {
                out.write(buffer, 0, bytes);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ByteArrayContainer.recycleInstance(buffer);
        }
    }

    public void close() {
    }

    public abstract InputStream getStream() throws Exception;

    public static FileElement getFileElement(String url) throws Exception {
        url = url.replace('\\', '/');
        int idx = url.indexOf(":");
        String proto = null;
        Class targetClass = null;
        if (idx < 0) {
            if (!new File(url).exists()) {
                throw new RuntimeException("UNKNOWN Protocols or Don't Exist File=>" + url);
            }
            targetClass = __DEFAULT_CLASS__;
        } else {
            proto = url.substring(0, idx);
            if (map.containsKey(proto)) {
                targetClass = (Class)map.get(proto);
            } else {
                if (!new File(url).exists()) {
                    throw new RuntimeException("UNKNOWN Protocols or Don't Exist File=>" + url);
                }
                targetClass = __DEFAULT_CLASS__;
            }
        }
        if (targetClass == null) {
            throw new RuntimeException("Not Regist Protocol => " + proto + " | " + url);
        }
        FileElement returnValue = (FileElement)targetClass.newInstance();
        returnValue.parse(url);
        return returnValue;
    }

    public static FileElement getFileElement(File url) throws Exception {
        return new LocalFileElement(url);
    }

    public static String getFileBody(String url) throws Exception {
        try (FileElement returnValue = FileElement.getFileElement(url);){
            String string = returnValue.getFileBody();
            return string;
        }
    }

    public static String getFileBody(String url, String charSetFrom, String charSetTo) throws Exception {
        try (FileElement returnValue = FileElement.getFileElement(url);){
            String string = returnValue.getFileBody(4, charSetFrom, charSetTo);
            return string;
        }
    }

    public static void putFileBodyToStream(String url, OutputStream out) throws Exception {
        try (FileElement returnValue = FileElement.getFileElement(url);){
            returnValue.putStream(out);
        }
    }

    public static void putFileBody(File url, OutputStream out) throws Exception {
        try (FileElement returnValue = FileElement.getFileElement(url);){
            returnValue.putStream(out);
        }
    }

    public static void toFile(String target, Object obj) throws Exception {
        eMsFileWriter writer = null;
        try {
            writer = new eMsFileWriter(target);
            writer.write(obj.toString());
            writer.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void toStream(OutputStream out, Object obj, String enc) throws Exception {
        try {
            if (enc != null) {
                try {
                    out.write(obj.toString().getBytes(enc));
                }
                catch (UnsupportedEncodingException e) {
                    out.write(obj.toString().getBytes());
                }
            } else {
                out.write(obj.toString().getBytes());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final String getFileName(String URL2) {
        String __URL__ = URL2.replace('\\', '/');
        int idx = __URL__.lastIndexOf("/");
        if (idx > 0) {
            return __URL__.substring(idx + 1);
        }
        return __URL__;
    }

    public static String StoreTmpInfoFile(String BASE, String content, String filename) throws Exception {
        String __STORE_FILE_NAME = FileElement.CheckSubDirectory(BASE, Cal.getDayDate()) + "/" + filename;
        FileElement.toFile(__STORE_FILE_NAME, content);
        return __STORE_FILE_NAME;
    }

    public static String CheckSubDirectory(String BASE, String WORKDAY) throws IOException {
        return FileElement.CheckSubDirectory(BASE, WORKDAY, null);
    }

    public static String CheckSubDirectory(String BASE, String WORKDAY, String[] SUB_LIST) throws IOException {
        String tmpStore = BASE.concat("/").concat(WORKDAY.substring(0, 4));
        File tmpFile = new File(tmpStore);
        if (!tmpFile.exists()) {
            tmpFile.mkdir();
        }
        if (!(tmpFile = new File(tmpStore = tmpStore.concat("/").concat(WORKDAY.substring(4, 6)))).exists()) {
            tmpFile.mkdir();
        }
        if (!(tmpFile = new File(tmpStore = WORKDAY.length() > 8 ? tmpStore.concat("/").concat(WORKDAY.substring(6, 8)) : tmpStore.concat("/").concat(WORKDAY.substring(6)))).exists()) {
            tmpFile.mkdir();
        }
        if (SUB_LIST != null) {
            for (int i = 0; i < SUB_LIST.length; ++i) {
                tmpFile = new File(tmpStore = tmpStore.concat("/").concat(SUB_LIST[i]));
                if (tmpFile.exists()) continue;
                tmpFile.mkdir();
            }
        }
        return tmpStore;
    }

    public static String CheckSubDirectory(String BASE, String WORKDAY, Object SUB_LIST) throws IOException {
        String tmpStore = BASE.concat("/").concat(WORKDAY.substring(0, 4));
        File tmpFile = new File(tmpStore);
        if (!tmpFile.exists()) {
            tmpFile.mkdir();
        }
        if (!(tmpFile = new File(tmpStore = tmpStore.concat("/").concat(WORKDAY.substring(4, 6)))).exists()) {
            tmpFile.mkdir();
        }
        if (!(tmpFile = new File(tmpStore = WORKDAY.length() > 8 ? tmpStore.concat("/").concat(WORKDAY.substring(6, 8)) : tmpStore.concat("/").concat(WORKDAY.substring(6)))).exists()) {
            tmpFile.mkdir();
        }
        if (SUB_LIST != null) {
            if (SUB_LIST instanceof String[]) {
                String[] subList = (String[])SUB_LIST;
                for (int i = 0; i < subList.length; ++i) {
                    tmpFile = new File(tmpStore = tmpStore.concat("/").concat(subList[i]));
                    if (tmpFile.exists()) continue;
                    tmpFile.mkdir();
                }
            } else {
                tmpFile = new File(tmpStore = tmpStore.concat("/").concat(SUB_LIST.toString()));
                if (!tmpFile.exists()) {
                    tmpFile.mkdir();
                }
            }
        }
        return tmpStore;
    }

    public static boolean CheckSubDirectory(String BASE) throws IOException {
        String __TARGET__ = BASE.replace('\\', '/');
        int idx1 = __TARGET__.indexOf("/");
        if (idx1 < 0) {
            return true;
        }
        int idx2 = idx1 + 1;
        while ((idx1 = __TARGET__.indexOf("/", idx2)) >= 0) {
            File tmpFile = new File(BASE.substring(0, idx1));
            if (!tmpFile.exists() && !tmpFile.mkdir()) {
                return false;
            }
            idx2 = idx1 + 1;
        }
        return true;
    }

    static {
        try {
            __DEFAULT_CLASS__ = Class.forName("pluto.io.LocalFileElement");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

