/*
 * Decompiled with CFR 0.152.
 */
package pluto.init;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pluto.lang.eMsLocale;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.EmsLock;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;

public class Activator {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    public static Hashtable static_mapping = new Hashtable();
    private static final String local_ip = "127.0.0.1";
    public static String duplicate_msg = "Duplicate Config File! Check your WatchDog Config File!";
    public static String file_error_msg = "File Not Found Exception! Check your WatchDog Config File!";
    private static Hashtable config_file_list = new Hashtable();

    public static String convert(Hashtable default_mapping, String src) {
        return StringConvertUtil.ConvertString(src, default_mapping, "${", "}", false, true);
    }

    public static String getAlivePort(Document ConfDocument) throws Exception {
        Element INITNode = (Element)ConfDocument.getElementsByTagName("INIT").item(0);
        String init_type = null;
        NodeList TargetNodeList = null;
        Element TargetNode = null;
        NodeList VarNodeList = null;
        Element SubNode = null;
        String alive_port = "";
        int TargetNodeCount = 0;
        int VarNodeCount = 0;
        if (INITNode != null) {
            TargetNodeList = INITNode.getElementsByTagName("TARGET");
            TargetNodeCount = TargetNodeList.getLength();
            for (int i = 0; i < TargetNodeCount; ++i) {
                TargetNode = (Element)TargetNodeList.item(i);
                init_type = TargetNode.getAttribute("type");
                if (init_type != null && init_type.equalsIgnoreCase("xml")) continue;
                VarNodeList = TargetNode.getElementsByTagName("var");
                VarNodeCount = VarNodeList.getLength();
                for (int j = 0; j < VarNodeCount; ++j) {
                    SubNode = (Element)VarNodeList.item(j);
                    if (!"listener.port".equals(SubNode.getAttribute("name"))) continue;
                    alive_port = SubNode.getAttribute("value");
                }
            }
        }
        return alive_port;
    }

    public static void check_port(Document ConfDocument) throws Exception {
        String alive_port = Activator.getAlivePort(ConfDocument);
        String line = "";
        boolean ALIVE_CHECK = false;
        try {
            try (Socket soc = new Socket(local_ip, Integer.parseInt(alive_port));
                 InputStream in = soc.getInputStream();
                 BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                line = br.readLine();
                ALIVE_CHECK = true;
            }
            catch (Exception ex) {
                log.error("Exception", (Throwable)ex);
            }
        }
        catch (Exception e) {
            ALIVE_CHECK = false;
        }
        if (ALIVE_CHECK && "OK".equals(line.trim())) {
            log.error("[ Already run ] Check your sending process. [port number] : " + alive_port);
            System.exit(-1);
        }
    }

    public static void init(Object arg) throws Exception {
        int i;
        if (arg == null) {
            throw new RuntimeException("Null Parameter");
        }
        String args = "";
        args = arg instanceof Map ? (String)((Map)arg).get("conf.file") : arg.toString();
        Hashtable<String, String> default_mapping = new Hashtable<String, String>();
        if (static_mapping != null) {
            default_mapping.putAll(static_mapping);
        }
        log.debug("Activator Start!");
        log.debug("[DEFAULT ENCODING NAME] " + Charset.defaultCharset());
        log.debug("[ check ] Configuration File .... => ".concat(args));
        File tmpCheckFile = new File(args);
        if (!tmpCheckFile.exists()) {
            log.debug("[ERROR] [" + arg + "] does not exist");
            System.exit(1);
        }
        log.debug("[ check ] Configuration File .... [OK]");
        log.debug("[ check ] Parsing File .... ");
        Document ConfDocument = DOMParser.getDocumentFromUrl(args);
        log.debug("[ check ] Parsing File .... [OK]");
        Activator.check_port(ConfDocument);
        log.debug("[ check ] Duplicate Check [OK]");
        Element TargetNode = null;
        Element SubNode = null;
        NodeList TargetNodeList = null;
        NodeList VarNodeList = null;
        int TargetNodeCount = 0;
        int VarNodeCount = 0;
        String ClassName = null;
        String mapping = null;
        String key = null;
        String value = null;
        Properties prop = new Properties();
        Class<?> TargetClass = null;
        Method TargetMethod = null;
        Class[] method_args = new Class[]{Object.class};
        Object[] target_arg = new Object[1];
        TargetNode = (Element)ConfDocument.getElementsByTagName("SERVER").item(0);
        String ServerName = TargetNode.getAttribute("name");
        log.debug("[ START ] " + ServerName + " INITIALIZATION .... ");
        log.debug("[SECTION] DEFAULT MAPPING SECTION .... ");
        TargetNodeList = ConfDocument.getElementsByTagName("MAP");
        if (TargetNodeList != null) {
            TargetNodeCount = TargetNodeList.getLength();
            log.debug("[INFO] DEFAULT MAPPING SECTION has " + TargetNodeCount + " MAPPINGS");
            for (i = 0; i < TargetNodeCount; ++i) {
                TargetNode = (Element)TargetNodeList.item(i);
                log.debug("[INIT] " + TargetNode.getAttribute("name") + " TARGET");
                mapping = TargetNode.getAttribute("name");
                value = TargetNode.getAttribute("value");
                default_mapping.put(mapping, Activator.convert(default_mapping, value));
                log.debug("[INFO] defult map " + mapping + " is setting for " + value);
            }
        } else {
            log.debug("HAVE NO DEFAULT MAPPING SECTION ELEMENT");
        }
        log.debug("[SECTION] DEFAULT MAPPING SECTION .... [COMPLETE]");
        log.debug("[SECTION] PARAM SECTION .... ");
        TargetNode = (Element)ConfDocument.getElementsByTagName("PARAM").item(0);
        if (TargetNode != null) {
            SubNode = (Element)TargetNode.getElementsByTagName("class").item(0);
            ClassName = Activator.convert(default_mapping, SubNode.getAttribute("name"));
            TargetClass = Class.forName(ClassName);
            TargetMethod = TargetClass.getDeclaredMethod("init", method_args);
            TargetNodeList = TargetNode.getElementsByTagName("ext");
            TargetNodeCount = TargetNodeList.getLength();
            log.debug("[INFO] ext  has " + TargetNodeCount + " VALUES");
            for (i = 0; i < TargetNodeCount; ++i) {
                key = null;
                value = null;
                TargetNode = (Element)TargetNodeList.item(i);
                key = TargetNode.getAttribute("name");
                value = XMLUtil.getCDATA_SECTION_OR_TEXT_NODE(TargetNode).trim();
                prop.setProperty(StringUtil.trimNull(key), Activator.convert(default_mapping, StringUtil.trimNull(value)));
            }
            target_arg[0] = prop;
            TargetMethod.invoke(null, target_arg);
        } else {
            log.debug("HAVE NO PARAM SECTION ELEMENT");
        }
        log.debug("[SECTION] PARAM SECTION .... [COMPLETE]");
        boolean lockCheck = false;
        boolean lockThreadSize = false;
        if (prop.getProperty("spool.store.directory") != null) {
            int idx = args.lastIndexOf(File.separator);
            if (idx == -1) {
                idx = args.lastIndexOf("/");
            }
            EmsLock lockChk = new EmsLock(prop.getProperty("ems.company.id", "Amail"), args.substring(0, idx));
            try {
                lockCheck = lockChk.check();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!lockCheck) {
                log.info("Engine is Locked. Register a Key File!!");
                System.exit(0);
            }
        }
        log.debug("[SECTION] LOCALE SECTION .... ");
        TargetNode = (Element)ConfDocument.getElementsByTagName("LOCALE").item(0);
        if (TargetNode != null) {
            VarNodeList = TargetNode.getElementsByTagName("var");
            VarNodeCount = VarNodeList.getLength();
            prop.clear();
            for (int j = 0; j < VarNodeCount; ++j) {
                SubNode = (Element)VarNodeList.item(j);
                prop.setProperty(SubNode.getAttribute("name"), Activator.convert(default_mapping, SubNode.getAttribute("value")));
                log.info(SubNode.getAttribute("name") + "=" + Activator.convert(default_mapping, SubNode.getAttribute("value")));
            }
            eMsLocale.init(prop);
        } else {
            log.debug("HAVE NO LOCALE SECTION ELEMENT");
        }
        log.debug("[SECTION] LOCALE SECTION .... [COMPLETE]");
        log.debug("[SECTION] LOG CHANNEL SECTION .... ");
        TargetNode = (Element)ConfDocument.getElementsByTagName("LOGCHANNEL").item(0);
        if (TargetNode != null) {
            TargetNodeList = TargetNode.getElementsByTagName("CHANNEL");
            TargetNodeCount = TargetNodeList.getLength();
            log.debug("[INFO] LOG CHANNEL HAS " + String.valueOf(TargetNodeCount) + " CHANNELS");
            for (int i2 = 0; i2 < TargetNodeCount; ++i2) {
                TargetNode = (Element)TargetNodeList.item(i2);
                NodeList sublist = TargetNode.getElementsByTagName("DIRECTORY");
                String dir_value = ((Element)sublist.item(0)).getAttribute("value");
                ((Element)sublist.item(0)).setAttribute("value", Activator.convert(default_mapping, dir_value));
                LogChannelContainer.regist(TargetNode.getAttribute("ID"), LogChannel.getInstance(TargetNode));
                log.debug("[INFO] <" + TargetNode.getAttribute("ID") + "> CHANNEL IS REGIST");
            }
            TargetNode = (Element)ConfDocument.getElementsByTagName("WATCHCHANNEL").item(0);
            if (TargetNode != null) {
                TargetNodeList = TargetNode.getElementsByTagName("WATCH");
                TargetNodeCount = TargetNodeList.getLength();
                String proc_value = "";
                String proc_key = "";
                for (int i3 = 0; i3 < TargetNodeCount; ++i3) {
                    TargetNode = (Element)TargetNodeList.item(i3);
                    proc_key = TargetNode.getAttribute("NAME").trim() + "_" + TargetNode.getAttribute("ID").trim();
                    NodeList sublist = TargetNode.getElementsByTagName("FILEPATH");
                    proc_value = ((Element)sublist.item(0)).getAttribute("value").trim();
                    if (config_file_list.containsKey(proc_key) || config_file_list.containsValue(proc_value)) {
                        throw new Exception(proc_value + "\r\n" + duplicate_msg);
                    }
                    config_file_list.put(proc_key, proc_value);
                    log.debug("[WATCHCHANNEL] <" + TargetNode.getAttribute("ID") + "> WATCHCHANNEL IS REGIST");
                }
                File file = null;
                Enumeration enu = config_file_list.elements();
                String tmp_path = "";
                while (enu.hasMoreElements()) {
                    tmp_path = (String)enu.nextElement();
                    file = new File(tmp_path);
                    if (file.exists()) continue;
                    throw new Exception(tmp_path + "\r\n" + file_error_msg);
                }
            }
        } else {
            log.debug("HAVE NO LOG CHANNEL SECTION ELEMENT");
        }
        log.debug("[SECTION] LOG CHANNEL SECTION .... [COMPLETE]");
        log.debug("[SECTION] INIT SECTION .... ");
        Element INITNode = (Element)ConfDocument.getElementsByTagName("INIT").item(0);
        String init_type = null;
        if (INITNode != null) {
            TargetNodeList = INITNode.getElementsByTagName("TARGET");
            TargetNodeCount = TargetNodeList.getLength();
            log.debug("[INFO] TARGET SECTION has " + TargetNodeCount + " TARGETs");
            for (int i4 = 0; i4 < TargetNodeCount; ++i4) {
                TargetNode = (Element)TargetNodeList.item(i4);
                log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> TARGET");
                if (log.isDebugEnabled()) {
                    log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> TARGET");
                }
                init_type = TargetNode.getAttribute("type");
                SubNode = (Element)TargetNode.getElementsByTagName("class").item(0);
                ClassName = SubNode.getAttribute("name");
                TargetClass = Class.forName(ClassName);
                log.info("TargetClass Name : " + TargetClass.getName());
                TargetMethod = TargetClass.getDeclaredMethod("init", method_args);
                log.info("TargetClass Method : " + TargetMethod.getName());
                if (init_type != null && init_type.equalsIgnoreCase("xml")) {
                    log.info(" => elements setting ");
                    target_arg[0] = TargetNode;
                    TargetMethod.invoke(null, target_arg);
                } else {
                    int j;
                    log.info(" => property setting ");
                    VarNodeList = TargetNode.getElementsByTagName("var");
                    VarNodeCount = VarNodeList.getLength();
                    Properties targetProp = new Properties();
                    for (j = 0; j < VarNodeCount; ++j) {
                        SubNode = (Element)VarNodeList.item(j);
                        targetProp.setProperty(SubNode.getAttribute("name"), Activator.convert(default_mapping, SubNode.getAttribute("value")));
                        log.info(SubNode.getAttribute("name") + "=" + Activator.convert(default_mapping, SubNode.getAttribute("value")));
                    }
                    VarNodeList = TargetNode.getElementsByTagName("blob");
                    VarNodeCount = VarNodeList.getLength();
                    for (j = 0; j < VarNodeCount; ++j) {
                        SubNode = (Element)VarNodeList.item(j);
                        targetProp.setProperty(SubNode.getAttribute("name"), Activator.convert(default_mapping, XMLUtil.getCDATA_SECTION(SubNode)));
                        log.debug(SubNode.getAttribute("name") + "=" + Activator.convert(default_mapping, XMLUtil.getCDATA_SECTION(SubNode)));
                    }
                    target_arg[0] = targetProp;
                    TargetMethod.invoke(null, target_arg);
                }
                log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> TARGET...[OK]");
            }
        } else {
            log.debug("HAVE NO INIT SECTION ELEMENT");
        }
        log.debug("[SECTION] INIT SECTION .... [COMPLETE]");
        log.debug("[SECTION] TASK REGIST SECTION .... ");
        TargetNodeList = INITNode.getElementsByTagName("TASK");
        if (TargetNodeList != null) {
            TargetNodeCount = TargetNodeList.getLength();
            log.debug("[INFO] TASK SECTION has " + TargetNodeCount + " TASK");
            if (log.isDebugEnabled()) {
                log.debug("[INFO] TASK SECTION has " + TargetNodeCount + " TASK");
            }
            String exec_interval = null;
            for (int i5 = 0; i5 < TargetNodeCount; ++i5) {
                Object work;
                TargetNode = (Element)TargetNodeList.item(i5);
                log.debug("[INIT] " + TargetNode.getAttribute("name") + " TARGET");
                if (log.isDebugEnabled()) {
                    log.debug("[INIT] " + TargetNode.getAttribute("name") + " TARGET");
                }
                init_type = TargetNode.getAttribute("type");
                exec_interval = TargetNode.getAttribute("cycle");
                SubNode = (Element)TargetNode.getElementsByTagName("class").item(0);
                ClassName = SubNode.getAttribute("name");
                if (init_type.equalsIgnoreCase("thread")) {
                    work = (Thread)Class.forName(ClassName).newInstance();
                    ((Thread)work).start();
                } else if (init_type.equalsIgnoreCase("interval")) {
                    work = (Task)Class.forName(ClassName).newInstance();
                    ((Task)work).setExecutionType((short)2, exec_interval);
                    TaskManager.executeTask((Task)work);
                } else {
                    work = (Task)Class.forName(ClassName).newInstance();
                    TaskManager.executeTask((Task)work);
                }
                log.debug("[INIT] <" + TargetNode.getAttribute("name") + "> REGIST...[OK]");
            }
        }
        log.debug("[SECTION] TASK REGIST SECTION .... [COMPLETE]");
        if (log.isDebugEnabled()) {
            log.debug("[SECTION] TASK REGIST SECTION .... [COMPLETE]");
        }
    }

    public static void main(String[] args) throws Exception {
        Activator.init(args[0]);
    }

    public static Hashtable _getStatic_mapping() {
        return static_mapping;
    }

    public static void setStatic_mapping(Hashtable hashtable) {
        static_mapping = hashtable;
    }

    public static Hashtable getConfigFileList() {
        return config_file_list;
    }
}

