/*
 * Decompiled with CFR 0.152.
 */
package pluto.db;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPoolImpl;
import pluto.db.eMsConnection;

public class ConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    private static ConnectionPoolImpl innerConnectionPool = null;
    public static final String DEFAULT_CLASS_NAME = "pluto.common.db.DirectConnectionPool";

    protected ConnectionPool() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public static synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        eMsConnection.init(tmp);
        String class_name = prop.getProperty("pool.class", DEFAULT_CLASS_NAME);
        innerConnectionPool = (ConnectionPoolImpl)Class.forName(class_name).newInstance();
        innerConnectionPool.inner_init(prop);
    }

    public static synchronized eMsConnection getConnection() throws Exception {
        return innerConnectionPool.get();
    }

    public static synchronized eMsConnection getConnection(ConnectInfo info) throws Exception {
        if (innerConnectionPool == null) {
            innerConnectionPool = (ConnectionPoolImpl)Class.forName(DEFAULT_CLASS_NAME).newInstance();
        }
        return innerConnectionPool.get(info);
    }
}

