/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.task;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.reporter.Reporter;
import pluto.schedule.Task;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;

public class DenyFilterTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(DenyFilterTask.class);
    private static String QUERY_SELECT_DENY_LIST_INFO = null;
    private static Hashtable HT_DENY_LIST = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement __SELECT_STATEMENT__ = null;

    public static void init(Object tmp) throws Exception {
    }

    public DenyFilterTask() {
        this.setName("DenyFilterTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("DenyFilterTask");
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("DenyFilterTask_at_".concat(Cal.getSerialDate()));
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        this.__SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(" Request Connection Error");
        log.error(this.getName(), thw);
        if (!(thw instanceof SQLException)) {
            Reporter.report("common", this.getName(), "DenyFilterTask.init.err", thw);
        }
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycleStatement(this.__SELECT_STATEMENT__);
            this.EMS_CONNECTION.recycle();
        }
    }

    @Override
    public void execute() throws Exception {
        eMsResultSet DENY_LIST = null;
        HT_DENY_LIST.clear();
        try {
            DENY_LIST = this.__SELECT_STATEMENT__.executeQuery(QUERY_SELECT_DENY_LIST_INFO);
            while (DENY_LIST.next()) {
                Properties LIST = new Properties();
                DENY_LIST.putToMap(LIST, false);
                HT_DENY_LIST.put(CryptoUtil.deEmailAddr(LIST.getProperty("DENY_EMAIL")), CryptoUtil.deEmailAddr(LIST.getProperty("DENY_EMAIL")));
            }
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
        finally {
            if (this.EMS_CONNECTION != null) {
                this.EMS_CONNECTION.recycleStatement(this.__SELECT_STATEMENT__);
                this.EMS_CONNECTION.recycle();
            }
        }
    }

    public static synchronized boolean checkDenyEmail(String email) {
        boolean b_chk = true;
        Object o_Tmp = HT_DENY_LIST.get(email);
        if (o_Tmp == null) {
            b_chk = false;
        }
        return b_chk;
    }

    static {
        try {
            QUERY_SELECT_DENY_LIST_INFO = SqlManager.getQuery("DENY_LIST_INFO", "QUERY_SELECT_DENY_LIST_INFO");
            HT_DENY_LIST = new Hashtable();
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
            System.exit(1);
        }
    }
}

