/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.db;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPoolImpl;
import pluto.db.eMsConnection;
import pluto.log.LogChannel;
import pluto.log.LogChannelContainer;
import pluto.util.recycle.ObjectPool;
import pluto.util.recycle.Recycleable;

public class RecycleConnectionPool
extends ObjectPool
implements ConnectionPoolImpl {
    private static final Logger log = LoggerFactory.getLogger(RecycleConnectionPool.class);

    @Override
    public void inner_init(Properties prop) throws Exception {
        String LOGCHANNEL_ID = prop.getProperty("logger.id");
        if (LOGCHANNEL_ID == null) {
            log.error("LOGCHANNEL IS NOT SET.......");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("LOGGER=>" + LOGCHANNEL_ID);
            }
            this.LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
        }
        this.reSize(Integer.parseInt(prop.getProperty("pool.size")));
    }

    @Override
    public eMsConnection get() throws Exception {
        eMsConnection returnValue = (eMsConnection)((Object)this.getRecycleable());
        returnValue.ensureOpen();
        returnValue.setName("caller[" + Thread.currentThread().getName() + "]");
        return returnValue;
    }

    @Override
    public eMsConnection get(ConnectInfo info) throws Exception {
        eMsConnection returnValue = eMsConnection.getBasicInstance();
        returnValue.execute(info);
        returnValue.setName("Connection[" + info.getDB_NAME() + ":" + Thread.currentThread().getName() + "]");
        return returnValue;
    }

    @Override
    protected Recycleable create(int seq, int level) throws Exception {
        this.log("REQUEST CONNECTION CREATE NEW...");
        eMsConnection returnValue = eMsConnection.getInstance();
        Recycleable target = (Recycleable)((Object)returnValue);
        target.setRecycleBin(this);
        returnValue.execute();
        returnValue.setName("Connection#".concat(String.valueOf(level)));
        this.log("create Instance=>".concat(returnValue.getClass().getName()));
        return target;
    }

    @Override
    public void recycle(Recycleable src) {
        if (src instanceof eMsConnection) {
            eMsConnection returnValue = (eMsConnection)((Object)src);
            try {
                returnValue.ensureOpen();
                super.recycle(src);
            }
            catch (Exception e) {
                this.log("connection open check error=>" + e.toString());
                this.log("check error=>" + src.getName());
                returnValue.recycle();
                super.destroy(src);
                return;
            }
        } else {
            this.log("invalid object recycle=>" + src.getClass().getName());
        }
    }

    @Override
    public void setLogger(LogChannel logger) {
    }

    @Override
    public void log(String log) {
    }
}

