/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.db;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.util.StringConvertUtil;

public class NotPooledConnection
extends eMsConnection {
    private static final Logger log = LoggerFactory.getLogger(NotPooledConnection.class);

    public static void init(Object tmp) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void ensureOpen() throws SQLException {
        if (log.isDebugEnabled()) {
            this.log("check ensureOpen");
        }
        Statement stmt = null;
        try {
            if (log.isDebugEnabled()) {
                this.log("NotPooledConnection ensureOpen #1 CHECK CONNECTION");
            }
            if (this.conn != null && !this.conn.isClosed()) {
                if (log.isDebugEnabled()) {
                    this.log("NotPooledConnection ensureOpen #2 NOT CLOSE");
                }
                stmt = this.conn.createStatement();
                if (log.isDebugEnabled()) {
                    this.log("NotPooledConnection ensureOpen #2-1 CREATE STATEMENT OK");
                }
                if (this.CONNECT_INFO.getDB_INIT_QUERY() != null) {
                    if (log.isDebugEnabled()) {
                        this.log("NotPooledConnection ensureOpen #2-3 EXEC SQL:" + this.CONNECT_INFO.getDB_INIT_QUERY());
                    }
                    stmt.execute(this.CONNECT_INFO.getDB_INIT_QUERY());
                    if (log.isDebugEnabled()) {
                        this.log("NotPooledConnection ensureOpen #2-4 EXEC SQL:" + this.CONNECT_INFO.getDB_INIT_QUERY() + " =>OK");
                    }
                }
                return;
            }
            if (log.isDebugEnabled()) {
                this.log("Already Closed...");
            }
            if (log.isDebugEnabled()) {
                this.log("NotPooledConnection ensureOpen #3 CLOSE continue");
            }
        }
        catch (Exception e) {
            this.log(StringConvertUtil.exToString(e));
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage());
            }
        }
        if (log.isDebugEnabled()) {
            this.log("NotPooledConnection ensureOpen #4 CREATE NEW CONNECTION");
        }
        this.releaseConnection();
        this.cleanRecycleStatements();
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            this.log("NotPooledConnection ensureOpen #4-1 ENSURE CON CLOSE OK");
        }
        this.conn = this.CONNECT_INFO.getDB_UID() == null ? DriverManager.getConnection(this.CONNECT_INFO.getDB_URL()) : DriverManager.getConnection(this.CONNECT_INFO.getDB_URL(), this.CONNECT_INFO.getDB_UID(), this.CONNECT_INFO.getDB_PASS());
        if (log.isDebugEnabled()) {
            this.log("NotPooledConnection ensureOpen #4-2 CREAT CONN OK");
        }
        try {
            stmt = this.conn.createStatement();
            if (this.CONNECT_INFO.getDB_INIT_QUERY() != null) {
                if (log.isDebugEnabled()) {
                    this.log("EXEC INIT QUERY:" + this.CONNECT_INFO.getDB_INIT_QUERY());
                }
                stmt.execute(this.CONNECT_INFO.getDB_INIT_QUERY());
            }
            if (log.isDebugEnabled()) {
                this.log("NotPooledConnection ensureOpen #4-3 CHECK STATEMENT OK");
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Object)"CONNECTION CHECK QUERY EXEC ERROR", (Object)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean expire() {
        return false;
    }
}

