/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import pluto.DNS.Cache;
import pluto.DNS.DClass;
import pluto.DNS.Master;
import pluto.DNS.Name;
import pluto.DNS.NameSet;
import pluto.DNS.Options;
import pluto.DNS.RRset;
import pluto.DNS.Record;
import pluto.DNS.RelativeNameException;
import pluto.DNS.SOARecord;
import pluto.DNS.SetResponse;
import pluto.DNS.TypedObject;
import pluto.DNS.ZoneTransferException;
import pluto.DNS.ZoneTransferIn;

public class Zone
extends NameSet {
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private Name origin;
    private int dclass = 1;
    private RRset NS;
    private SOARecord SOA;
    private boolean hasWild;

    private void validate() throws IOException {
        RRset rrset = (RRset)this.findExactSet(this.origin, 6);
        if (rrset == null || rrset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        Iterator it = rrset.rrs();
        this.SOA = (SOARecord)it.next();
        this.NS = (RRset)this.findExactSet(this.origin, 2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    private final void maybeAddRecord(Record record, Cache cache, Object source) throws IOException {
        int type = record.getType();
        Name name = record.getName();
        if (this.origin == null) {
            if (type == 6) {
                this.origin = name;
                this.setOrigin(this.origin);
            } else {
                throw new IOException("non-SOA record seen at " + name + " with no origin set");
            }
        }
        if (type == 6 && !name.equals(this.origin)) {
            throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        } else if (cache != null) {
            cache.addRecord(record, 2, source);
        }
    }

    public Zone(String file, Cache cache, Name initialOrigin) throws IOException {
        super(false);
        Record record;
        Master m = new Master(file, initialOrigin);
        this.origin = initialOrigin;
        if (this.origin != null) {
            this.setOrigin(this.origin);
        }
        while ((record = m.nextRecord()) != null) {
            this.maybeAddRecord(record, cache, file);
        }
        this.validate();
    }

    public Zone(Record[] records, Cache cache, Name initialOrigin) throws IOException {
        super(false);
        this.origin = initialOrigin;
        if (this.origin != null) {
            this.setOrigin(this.origin);
        }
        for (int i = 0; i < records.length; ++i) {
            this.maybeAddRecord(records[i], cache, records);
        }
        this.validate();
    }

    public Zone(String file, Cache cache) throws IOException {
        this(file, cache, null);
    }

    public void fromXFR(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        if (!zone.isAbsolute()) {
            throw new RelativeNameException(zone);
        }
        DClass.check(dclass);
        this.origin = zone;
        this.setOrigin(this.origin);
        this.dclass = dclass;
        ZoneTransferIn xfrin = ZoneTransferIn.newAXFR(zone, remote, null);
        List records = xfrin.run();
        for (Record rec : records) {
            if (!rec.getName().subdomain(this.origin)) {
                if (!Options.check("verbose")) continue;
                System.err.println(rec.getName() + "is not in zone " + this.origin);
                continue;
            }
            this.addRecord(rec);
        }
        this.validate();
    }

    public Zone(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        super(false);
        this.fromXFR(zone, dclass, remote);
    }

    public Zone(Name zone, int dclass, String remote, Cache cache) throws IOException {
        super(false);
        DClass.check(dclass);
        try {
            this.fromXFR(zone, dclass, remote);
        }
        catch (ZoneTransferException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return this.NS;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    public int getDClass() {
        return this.dclass;
    }

    public SetResponse findRecords(Name name, int type) {
        RRset rrset;
        Object[] objects;
        SetResponse zr = null;
        Object o = this.lookup(name, type);
        if (o == null) {
            if (name.isWild() || !this.hasWild) {
                return SetResponse.ofType(1);
            }
            int labels = name.labels() - this.origin.labels();
            Name tname = name;
            do {
                SetResponse sr;
                if (!(sr = this.findRecords(tname.wild(1), type)).isNXDOMAIN()) {
                    return sr;
                }
                tname = new Name(tname, 1);
            } while (labels-- >= 1);
            return SetResponse.ofType(1);
        }
        if (o == NXRRSET) {
            return SetResponse.ofType(2);
        }
        if (o instanceof RRset) {
            objects = null;
            rrset = (RRset)o;
        } else {
            objects = (Object[])o;
            rrset = (RRset)objects[0];
        }
        if (name.equals(rrset.getName())) {
            if (type != 5 && type != 255 && rrset.getType() == 5) {
                zr = new SetResponse(4, rrset);
            } else if (rrset.getType() == 2 && !name.equals(this.origin)) {
                zr = new SetResponse(3, rrset);
            } else {
                zr = new SetResponse(6);
                zr.addRRset(rrset);
                if (objects != null) {
                    for (int i = 1; i < objects.length; ++i) {
                        zr.addRRset((RRset)objects[i]);
                    }
                }
            }
        } else if (rrset.getType() == 5) {
            zr = SetResponse.ofType(1);
        } else if (rrset.getType() == 39) {
            zr = new SetResponse(5, rrset);
        } else if (rrset.getType() == 2) {
            zr = new SetResponse(3, rrset);
        }
        return zr;
    }

    public RRset findExactMatch(Name name, int type) {
        return (RRset)this.findExactSet(name, type);
    }

    public void addRecord(Record r) {
        int type;
        Name name = r.getName();
        RRset rrset = (RRset)this.findExactSet(name, type = r.getRRsetType());
        if (rrset == null) {
            rrset = new RRset();
            this.addSet(name, type, rrset);
        }
        rrset.addRR(r);
    }

    @Override
    protected void addSet(Name name, int type, TypedObject set) {
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        super.addSet(name, type, set);
    }

    public void removeRecord(Record r) {
        int type;
        Name name = r.getName();
        RRset rrset = (RRset)this.findExactSet(name, type = r.getRRsetType());
        if (rrset != null) {
            rrset.deleteRR(r);
            if (rrset.size() == 0) {
                this.removeSet(name, type, rrset);
            }
        }
    }

    public Iterator iterator() {
        return new ZoneIterator(false);
    }

    public Iterator AXFR() {
        return new ZoneIterator(true);
    }

    public String toMasterFile() {
        Iterator znames = this.names();
        StringBuffer sb = new StringBuffer();
        while (znames.hasNext()) {
            Name name = (Name)znames.next();
            Object[] sets = this.findExactSets(name);
            for (int i = 0; i < sets.length; ++i) {
                RRset rrset = (RRset)sets[i];
                Iterator it = rrset.rrs();
                while (it.hasNext()) {
                    sb.append(it.next() + "\n");
                }
                it = rrset.sigs();
                while (it.hasNext()) {
                    sb.append(it.next() + "\n");
                }
            }
        }
        return sb.toString();
    }

    class ZoneIterator
    implements Iterator {
        private Iterator znames;
        private Object[] current;
        int count;
        boolean wantLastSOA;

        ZoneIterator(boolean axfr) {
            this.znames = Zone.this.names();
            this.wantLastSOA = axfr;
            Object[] sets = Zone.this.findExactSets(Zone.this.origin);
            this.current = new Object[sets.length];
            int j = 2;
            for (int i = 0; i < sets.length; ++i) {
                int type = ((RRset)sets[i]).getType();
                if (type == 6) {
                    this.current[0] = sets[i];
                    continue;
                }
                if (type == 2) {
                    this.current[1] = sets[i];
                    continue;
                }
                this.current[j++] = sets[i];
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null || this.wantLastSOA;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null && this.wantLastSOA) {
                this.wantLastSOA = false;
                return (RRset)Zone.this.findExactSet(Zone.this.origin, 6);
            }
            Object set = null;
            if (this.current != null) {
                set = this.current[this.count++];
                if (this.count == this.current.length) {
                    this.current = null;
                    while (this.znames.hasNext()) {
                        Object[] sets;
                        Name name = (Name)this.znames.next();
                        if (name.equals(Zone.this.origin) || (sets = Zone.this.findExactSets(name)).length == 0) continue;
                        this.current = sets;
                        this.count = 0;
                        break;
                    }
                }
            }
            return set;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

