/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.Tokenizer;

public class X25Record
extends Record {
    private byte[] address;

    X25Record() {
    }

    @Override
    Record getObject() {
        return new X25Record();
    }

    private static final byte[] checkAndConvertAddress(String address) {
        int length = address.length();
        byte[] out = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = address.charAt(i);
            if (!Character.isDigit(c)) {
                return null;
            }
            out[i] = (byte)c;
        }
        return out;
    }

    public X25Record(Name name, int dclass, long ttl, String address) {
        super(name, 19, dclass, ttl);
        this.address = X25Record.checkAndConvertAddress(address);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid PSDN address " + address);
        }
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.address = in.readCountedString();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String address = st.getString();
        this.address = X25Record.checkAndConvertAddress(address);
        if (this.address == null) {
            throw st.exception("invalid PSDN address " + address);
        }
    }

    public String getAddress() {
        return X25Record.byteArrayToString(this.address, false);
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.address);
    }

    @Override
    String rrToString() {
        return X25Record.byteArrayToString(this.address, true);
    }
}

