/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import pluto.DNS.Name;
import pluto.DNS.TextParseException;
import pluto.net.NetAddress;

public final class ReverseMap {
    private static Name inaddr = Name.fromConstantString("in-addr.arpa.");

    private ReverseMap() {
    }

    public static Name fromAddress(int[] addr) {
        if (addr.length != 4) {
            throw new IllegalArgumentException("array must contain 4 elements");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 3; i >= 0; --i) {
            if (addr[i] < 0 || addr[i] > 255) {
                throw new IllegalArgumentException("array must contain values between 0 and 255");
            }
            sb.append(addr[i]);
            if (i <= 0) continue;
            sb.append(".");
        }
        try {
            return Name.fromString(sb.toString(), inaddr);
        }
        catch (TextParseException e) {
            throw new IllegalStateException("name cannot be invalid");
        }
    }

    public static Name fromAddress(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        int[] array = new int[4];
        for (int i = 0; i < 4; ++i) {
            array[i] = bytes[i] & 0xFF;
        }
        return ReverseMap.fromAddress(array);
    }

    public static Name fromAddress(String addr) throws UnknownHostException {
        int[] array = NetAddress.getIntArray(addr);
        if (array == null) {
            throw new UnknownHostException("Invalid IP address");
        }
        return ReverseMap.fromAddress(array);
    }
}

