/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import pluto.DNS.Name;
import pluto.DNS.TypedObject;

class NameSet {
    private Map data;
    private Name origin;
    private boolean isCache;
    protected static Object NXRRSET = new Object();

    protected NameSet(boolean isCache, Map map) {
        this.data = map;
        this.origin = Name.root;
        this.isCache = isCache;
    }

    protected NameSet(boolean isCache) {
        this(isCache, new HashMap());
    }

    protected void setOrigin(Name origin) {
        this.origin = origin;
    }

    protected synchronized void clear() {
        this.data.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object lookupType(Object typelist, int type) {
        Object innerList = typelist;
        if (type == 255) {
            throw new IllegalArgumentException("type ANY passed to NameSet.lookupType()");
        }
        Object object = innerList;
        synchronized (object) {
            if (innerList instanceof LinkedList) {
                LinkedList list = (LinkedList)innerList;
                for (int i = 0; i < list.size(); ++i) {
                    TypedObject obj = (TypedObject)list.get(i);
                    if (obj.getType() != type) continue;
                    return obj;
                }
                return null;
            }
            TypedObject obj = (TypedObject)innerList;
            if (obj.getType() == type) {
                return obj;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object[] lookupAll(Object typelist) {
        Object innerList;
        Object object = innerList = typelist;
        synchronized (object) {
            if (innerList instanceof LinkedList) {
                return ((LinkedList)innerList).toArray();
            }
            return new Object[]{innerList};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookup(Name name, int type) {
        int olabels;
        Object bestns = null;
        if (!name.subdomain(this.origin)) {
            return null;
        }
        int labels = name.labels();
        for (int tlabels = olabels = this.origin.labels(); tlabels <= labels; ++tlabels) {
            Object o;
            Object typelist;
            boolean isexact;
            boolean isorigin = tlabels == olabels;
            boolean bl = isexact = tlabels == labels;
            Name tname = isorigin ? this.origin : (isexact ? name : new Name(name, labels - tlabels));
            NameSet nameSet = this;
            synchronized (nameSet) {
                typelist = this.data.get(tname);
            }
            if (typelist == null) continue;
            if (isexact && type == 255) {
                return this.lookupAll(typelist);
            }
            if ((!isorigin || this.isCache) && (o = this.lookupType(typelist, 2)) != null) {
                if (this.isCache) {
                    bestns = o;
                } else {
                    return o;
                }
            }
            if (isexact) {
                o = this.lookupType(typelist, type);
                if (o == null) {
                    o = this.lookupType(typelist, 5);
                }
                if (o != null) {
                    return o;
                }
            } else {
                o = this.lookupType(typelist, 39);
                if (o != null) {
                    return o;
                }
            }
            if (isexact && this.isCache && (o = this.lookupType(typelist, 0)) != null) {
                return o;
            }
            if (!isexact) continue;
            return NXRRSET;
        }
        return bestns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object findExactSet(Name name, int type) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
        }
        if (typelist == null) {
            return null;
        }
        return this.lookupType(typelist, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] findExactSets(Name name) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
        }
        if (typelist == null) {
            return new Object[0];
        }
        return this.lookupAll(typelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSet(Name name, int type, TypedObject set) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
            if (typelist == null) {
                this.data.put(name, set);
                return;
            }
            if (!(typelist instanceof LinkedList)) {
                TypedObject obj = (TypedObject)typelist;
                if (obj.getType() == type) {
                    this.data.put(name, set);
                } else {
                    LinkedList<Object> list = new LinkedList<Object>();
                    list.add(typelist);
                    list.add(set);
                    this.data.put(name, list);
                }
                return;
            }
        }
        nameSet = typelist;
        synchronized (nameSet) {
            LinkedList list = (LinkedList)typelist;
            for (int i = 0; i < list.size(); ++i) {
                TypedObject obj = (TypedObject)list.get(i);
                if (obj.getType() != type) continue;
                list.set(i, set);
                return;
            }
            list.add(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSet(Name name, int type, TypedObject set) {
        Object typelist;
        NameSet nameSet = this;
        synchronized (nameSet) {
            typelist = this.data.get(name);
            if (typelist == null) {
                return;
            }
            if (!(typelist instanceof LinkedList)) {
                if (typelist == set) {
                    this.data.remove(name);
                }
                return;
            }
        }
        nameSet = typelist;
        synchronized (nameSet) {
            LinkedList list = (LinkedList)typelist;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != set) continue;
                list.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeName(Name name) {
        NameSet nameSet = this;
        synchronized (nameSet) {
            this.data.remove(name);
        }
    }

    Iterator names() {
        return this.data.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        NameSet nameSet = this;
        synchronized (nameSet) {
            for (Object typelist : this.data.values()) {
                Object[] elements = this.lookupAll(typelist);
                for (int i = 0; i < elements.length; ++i) {
                    sb.append(elements[i]);
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }
}

