/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import pluto.DNS.DClass;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.RelativeNameException;
import pluto.DNS.TTL;
import pluto.DNS.TextParseException;
import pluto.DNS.Tokenizer;
import pluto.DNS.Type;

public class Master {
    private Name origin;
    private File file;
    private Record last = null;
    private long defaultTTL;
    private Master included = null;
    private Tokenizer st;

    Master(File file, Name initialOrigin, long initialTTL) throws IOException {
        if (this.origin != null && !this.origin.isAbsolute()) {
            throw new RelativeNameException(this.origin);
        }
        this.file = file;
        this.st = new Tokenizer(file);
        this.origin = initialOrigin;
        this.defaultTTL = initialTTL;
    }

    public Master(String filename, Name origin, long ttl) throws IOException {
        this(new File(filename), origin, ttl);
    }

    public Master(String filename, Name origin) throws IOException {
        this(new File(filename), origin, -1L);
    }

    public Master(String filename) throws IOException {
        this(new File(filename), null, -1L);
    }

    public Master(InputStream in, Name origin, long ttl) {
        if (origin != null && !origin.isAbsolute()) {
            throw new RelativeNameException(origin);
        }
        this.st = new Tokenizer(in);
        this.origin = origin;
        this.defaultTTL = ttl;
    }

    public Master(InputStream in, Name origin) {
        this(in, origin, -1L);
    }

    public Master(InputStream in) {
        this(in, null, -1L);
    }

    private Name parseName(String s, Name origin) throws TextParseException {
        try {
            return Name.fromString(s, origin);
        }
        catch (TextParseException e) {
            throw this.st.exception(e.getMessage());
        }
    }

    public Record _nextRecord() throws IOException {
        int type;
        long ttl;
        String s;
        Name name;
        block21: {
            Tokenizer.Token token;
            block22: {
                if (this.included != null) {
                    Record rec = this.included.nextRecord();
                    if (rec != null) {
                        return rec;
                    }
                    this.included = null;
                }
                while (true) {
                    token = this.st.get(true, false);
                    if (token.type == 2) {
                        this.st.get();
                        if (token.type == 1) continue;
                        if (token.type == 0) {
                            return null;
                        }
                        this.st.unget();
                        if (this.last == null) {
                            throw this.st.exception("no owner");
                        }
                        name = this.last.getName();
                        break block21;
                    }
                    if (token.type == 1) continue;
                    if (token.type == 0) {
                        return null;
                    }
                    if (token.value.charAt(0) != '$') break block22;
                    s = token.value;
                    if (s.equalsIgnoreCase("$ORIGIN")) {
                        this.origin = this.st.getName(Name.root);
                        this.st.getEOL();
                        continue;
                    }
                    if (!s.equalsIgnoreCase("$TTL")) break;
                    this.defaultTTL = this.st.getTTL();
                    this.st.getEOL();
                }
                if (s.equalsIgnoreCase("$INCLUDE")) {
                    String filename = this.st.getString();
                    this.file.getParent();
                    File newfile = new File(filename);
                    Name incorigin = this.origin;
                    token = this.st.get();
                    if (token.isString()) {
                        incorigin = this.parseName(token.value, Name.root);
                        this.st.getEOL();
                    }
                    this.included = new Master(newfile, incorigin, this.defaultTTL);
                    return this.nextRecord();
                }
                throw this.st.exception("Invalid directive: " + s);
            }
            s = token.value;
            name = this.parseName(s, this.origin);
            if (this.last != null && name.equals(this.last.getName())) {
                name = this.last.getName();
            }
        }
        boolean seen_class = false;
        s = this.st.getString();
        int dclass = DClass.value(s);
        if (dclass >= 0) {
            s = this.st.getString();
            seen_class = true;
        }
        try {
            ttl = TTL.parseTTL(s);
            s = this.st.getString();
        }
        catch (NumberFormatException e) {
            if (this.last == null && this.defaultTTL < 0L) {
                throw this.st.exception("missing TTL");
            }
            if (this.defaultTTL >= 0L) {
                ttl = this.defaultTTL;
            }
            if (this.last != null) {
                ttl = this.last.getTTL();
            }
            throw this.st.exception("no owner");
        }
        if (!seen_class) {
            dclass = DClass.value(s);
            if (dclass >= 0) {
                s = this.st.getString();
            } else {
                dclass = 1;
            }
        }
        if ((type = Type.value(s)) < 0) {
            throw this.st.exception("Invalid type '" + s + "'");
        }
        this.last = Record.fromString(name, type, dclass, ttl, this.st, this.origin);
        return this.last;
    }

    public Record nextRecord() throws IOException {
        Record rec = null;
        try {
            rec = this._nextRecord();
        }
        finally {
            if (rec == null) {
                this.st.close();
            }
        }
        return rec;
    }

    protected void finalize() throws Throwable {
        this.st.close();
    }
}

