/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pluto.DNS.CNAMERecord;
import pluto.DNS.Cache;
import pluto.DNS.DClass;
import pluto.DNS.DNAMERecord;
import pluto.DNS.Message;
import pluto.DNS.Mnemonic;
import pluto.DNS.Name;
import pluto.DNS.NameTooLongException;
import pluto.DNS.Options;
import pluto.DNS.RRset;
import pluto.DNS.Rcode;
import pluto.DNS.Record;
import pluto.DNS.Resolver;
import pluto.DNS.SetResponse;
import pluto.DNS.TextParseException;
import pluto.DNS.Type;
import pluto.util.PlutoLinkedList;

public final class Lookup {
    private static Name[] defaultSearchPath;
    private static Map defaultCaches;
    private Resolver resolver;
    private Cache cache;
    private int credibility;
    private Name name;
    private int type;
    private int dclass;
    private boolean verbose;
    private int iterations;
    private boolean done;
    private boolean doneCurrent;
    private List aliases;
    private Record[] answers;
    private int result;
    private String error;
    private boolean nxdomain;
    private boolean badresponse;
    private String badresponse_error;
    private boolean networkerror;
    private boolean timedout;
    private boolean nametoolong;
    private boolean referral;
    private PlutoLinkedList EMS_MX_RESULT_LIST = null;
    public static final int SUCCESSFUL = 0;
    public static final int UNRECOVERABLE = 1;
    public static final int TRY_AGAIN = 2;
    public static final int HOST_NOT_FOUND = 3;
    public static final int TYPE_NOT_FOUND = 4;
    public static final int SEARCH_FAIL = 99;

    public static synchronized Cache getDefaultCache(int dclass) {
        DClass.check(dclass);
        Cache c = (Cache)defaultCaches.get(Mnemonic.toInteger(dclass));
        if (c == null) {
            c = new Cache(dclass);
            defaultCaches.put(Mnemonic.toInteger(dclass), c);
        }
        return c;
    }

    public static synchronized void setDefaultCache(Cache cache, int dclass) {
        DClass.check(dclass);
        defaultCaches.put(Mnemonic.toInteger(dclass), cache);
    }

    public static synchronized Name[] getDefaultSearchPath() {
        return defaultSearchPath;
    }

    public static synchronized void setDefaultSearchPath(Name[] domains) {
        defaultSearchPath = domains;
    }

    public static synchronized void setDefaultSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        for (int i = 0; i < domains.length; ++i) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
        }
        defaultSearchPath = newdomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup(Name name, int type, int dclass) {
        Type.check(type);
        DClass.check(dclass);
        if (!Type.isRR(type) && type != 255) {
            throw new IllegalArgumentException("Cannot query for meta-types other than ANY");
        }
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        Class<Lookup> clazz = Lookup.class;
        synchronized (Lookup.class) {
            this.cache = Lookup.getDefaultCache(dclass);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.credibility = 3;
            this.verbose = Options.check("verbose");
            this.result = -1;
            this.aliases = new ArrayList();
            return;
        }
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setSearchPath(Name[] domains) {
    }

    public void setSearchPath(String[] domains) throws TextParseException {
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            cache = new Cache(this.dclass, 0);
        }
        this.cache = cache;
    }

    public void setCredibility(int credibility) {
        this.credibility = credibility;
    }

    private void follow(Name name, Name oldname) {
        this.badresponse = false;
        this.networkerror = false;
        this.timedout = false;
        this.nxdomain = false;
        this.referral = false;
        ++this.iterations;
        if (this.iterations >= 6 || name.equals(oldname)) {
            this.result = 1;
            this.error = "CNAME loop";
            this.done = true;
            return;
        }
        this.aliases.add(name);
        this.lookup(name);
    }

    private void processResponse(Name name, SetResponse response) {
        if (response.isSuccessful()) {
            RRset[] rrsets = response.answers();
            if (this.EMS_MX_RESULT_LIST == null) {
                this.EMS_MX_RESULT_LIST = new PlutoLinkedList();
            } else {
                this.EMS_MX_RESULT_LIST.clear();
            }
            for (int i = 0; i < rrsets.length; ++i) {
                Iterator it = rrsets[i].rrs();
                while (it.hasNext()) {
                    this.EMS_MX_RESULT_LIST.add(it.next());
                }
            }
            this.result = 0;
            this.done = true;
        } else if (response.isNXDOMAIN()) {
            this.nxdomain = true;
            this.doneCurrent = true;
            if (this.iterations > 0) {
                this.result = 3;
                this.done = true;
            }
        } else if (response.isNXRRSET()) {
            this.result = 4;
            this.answers = null;
            this.done = true;
        } else if (response.isCNAME()) {
            CNAMERecord cname = response.getCNAME();
            this.follow(cname.getTarget(), name);
        } else if (response.isDNAME()) {
            DNAMERecord dname = response.getDNAME();
            try {
                this.follow(name.fromDNAME(dname), name);
            }
            catch (NameTooLongException e) {
                this.result = 1;
                this.error = "Invalid DNAME target";
                this.done = true;
            }
        } else if (response.isDelegation()) {
            this.referral = true;
        }
    }

    public PlutoLinkedList getResultMxList() {
        return this.EMS_MX_RESULT_LIST;
    }

    private void lookup(Name current) {
        SetResponse sr = this.cache.lookupRecords(current, this.type, this.credibility);
        this.processResponse(current, sr);
        if (this.done || this.doneCurrent) {
            return;
        }
        Record question = Record.newRecord(current, this.type, this.dclass);
        Message query = Message.newQuery(question);
        Message response = null;
        try {
            response = this.resolver.send(query);
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                this.timedout = true;
            } else {
                this.networkerror = true;
            }
            return;
        }
        int rcode = response.getHeader().getRcode();
        if (rcode != 0 && rcode != 3) {
            this.badresponse = true;
            this.badresponse_error = Rcode.string(rcode);
            return;
        }
        if (!query.getQuestion().equals(response.getQuestion())) {
            this.badresponse = true;
            this.badresponse_error = "response does not match query";
            return;
        }
        sr = this.cache.addMessage(response);
        if (sr == null) {
            sr = this.cache.lookupRecords(current, this.type, this.credibility);
        }
        if (this.verbose) {
            System.err.println("queried " + current + " " + Type.string(this.type));
            System.err.println(sr);
        }
        this.processResponse(current, sr);
    }

    private void resolve(Name current, Name suffix) {
        this.doneCurrent = false;
        Name tname = null;
        if (suffix == null) {
            tname = current;
        } else {
            try {
                tname = Name.concatenate(current, suffix);
            }
            catch (NameTooLongException e) {
                this.nametoolong = true;
                return;
            }
        }
        this.lookup(tname);
    }

    public Record[] run() {
        this.done = false;
        if (this.name.isAbsolute()) {
            this.resolve(this.name, null);
        } else {
            this.resolve(this.name, Name.root);
        }
        if (!this.done) {
            if (this.badresponse) {
                this.result = 2;
                this.error = this.badresponse_error;
                this.done = true;
            } else if (this.timedout) {
                this.result = 2;
                this.error = "timed out";
                this.done = true;
            } else if (this.networkerror) {
                this.result = 2;
                this.error = "network error";
                this.done = true;
            } else if (this.nxdomain) {
                this.result = 3;
                this.done = true;
            } else if (this.referral) {
                this.result = 1;
                this.error = "referral";
                this.done = true;
            } else if (this.nametoolong) {
                this.result = 1;
                this.error = "name too long";
                this.done = true;
            }
        }
        return this.answers;
    }

    private void checkDone() {
        if (this.done && this.result != -1) {
            return;
        }
        StringBuffer sb = new StringBuffer("Lookup of " + this.name + " ");
        if (this.dclass != 1) {
            sb.append(DClass.string(this.dclass) + " ");
        }
        sb.append(Type.string(this.type) + " isn't done");
        throw new IllegalStateException(sb.toString());
    }

    public Record[] getAnswers() {
        this.checkDone();
        return this.answers;
    }

    public Name[] getAliases() {
        this.checkDone();
        return this.aliases.toArray(new Name[this.aliases.size()]);
    }

    public int getResult() {
        this.checkDone();
        return this.result;
    }

    public String getErrorString() {
        this.checkDone();
        if (this.error != null) {
            return this.error;
        }
        switch (this.result) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "unrecoverable error";
            }
            case 2: {
                return "try again";
            }
            case 3: {
                return "host not found";
            }
            case 4: {
                return "type not found";
            }
        }
        throw new IllegalStateException("unknown result");
    }

    public void setErrorString(String msg) {
        this.error = msg;
    }

    static {
        defaultCaches = new HashMap();
    }
}

