/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import pluto.DNS.TextParseException;
import pluto.net.NetAddress;

public class Inet6Address {
    private byte[] data;

    public Inet6Address(byte[] data) throws IOException {
        if (data.length != 16) {
            throw new IOException("An Inet6Address is 128 bits");
        }
        this.data = data;
    }

    public Inet6Address(int bits, byte[] data) throws IOException {
        if (data.length > 16) {
            throw new IOException("An Inet6Address is only 128 bits");
        }
        int bytes = (bits + 7) / 8;
        this.data = new byte[16];
        System.arraycopy(data, 0, this.data, 16 - bytes, bytes);
    }

    public Inet6Address(String s) throws TextParseException {
        int k;
        int i;
        boolean parsev4 = false;
        ArrayList<String> l = new ArrayList<String>();
        int range = -1;
        this.data = new byte[16];
        StringTokenizer st = new StringTokenizer(s, ":", true);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        l.add("");
        l.add("");
        String[] tokens = l.toArray(new String[l.size()]);
        int j = 0;
        for (i = 0; i < tokens.length - 2; ++i) {
            if (tokens[i].equals(":")) {
                if (tokens[i + 1].equals(":")) {
                    if (tokens[i + 2].equals(":") || range >= 0) {
                        throw new TextParseException("Invalid IPv6 address");
                    }
                    range = j;
                    if (tokens[i + 2].equals("")) break;
                    ++i;
                }
                ++i;
            }
            if (tokens[i].indexOf(46) >= 0) {
                parsev4 = true;
                if (tokens[i + 1].equals("")) break;
                throw new TextParseException("Invalid IPv6 address");
            }
            try {
                int x = Integer.parseInt(tokens[i], 16);
                if (x > 65535) {
                    throw new TextParseException("Invalid IPv6 address");
                }
                if (j > 14) {
                    throw new TextParseException("Invalid IPv6 address");
                }
                this.data[j++] = (byte)(x >>> 8);
                this.data[j++] = (byte)(x & 0xFF);
                continue;
            }
            catch (NumberFormatException e) {
                throw new TextParseException("Invalid IPv6 address");
            }
        }
        if (parsev4) {
            byte[] v4addr = NetAddress.getByteArray(tokens[i]);
            if (v4addr == null) {
                throw new TextParseException("Invalid IPv6 address");
            }
            for (k = 0; k < 4; ++k) {
                this.data[j++] = v4addr[k];
            }
        }
        if (range >= 0) {
            int left = 16 - j;
            for (k = 15; k >= 0; --k) {
                if (k >= range + left) {
                    this.data[k] = this.data[k - left];
                    continue;
                }
                if (k < range) continue;
                this.data[k] = 0;
            }
        } else if (j < 16) {
            throw new TextParseException("Invalid IPv6 address");
        }
    }

    public byte[] toBytes() {
        return this.data;
    }

    public String toString() {
        int i;
        int[] labels = new int[8];
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < 8; ++i2) {
            labels[i2] = ((this.data[2 * i2] & 0xFF) << 8) + (this.data[2 * i2 + 1] & 0xFF);
        }
        int start = -1;
        int length = -1;
        int tstart = -1;
        int tlength = -1;
        boolean inzero = false;
        for (i = 0; i < 8; ++i) {
            if (!inzero) {
                if (labels[i] != 0) continue;
                tstart = i;
                tlength = 0;
                inzero = true;
                continue;
            }
            if (labels[i] == 0) {
                ++tlength;
                continue;
            }
            inzero = false;
            if (tlength > length) {
                start = tstart;
                length = tlength;
            }
            tlength = -1;
        }
        if (tlength > length) {
            start = tstart;
            length = tlength;
        }
        if (labels[0] == 0 && labels[1] == 0 && labels[2] == 0 && labels[3] == 0 && labels[4] == 0 && labels[6] != 0 && (labels[5] == 0 || labels[5] == 65535)) {
            sb.append("::");
            if (labels[5] == 65535) {
                sb.append("FFFF:");
            }
            sb.append(labels[6] >> 8);
            sb.append(".");
            sb.append(labels[6] & 0xFF);
            sb.append(".");
            sb.append(labels[7] >> 8);
            sb.append(".");
            sb.append(labels[7] & 0xFF);
        } else if (start == -1) {
            for (i = 0; i < 8; ++i) {
                sb.append(Integer.toHexString(labels[i]).toUpperCase());
                if (i == 7) continue;
                sb.append(":");
            }
        } else {
            for (i = 0; i < start; ++i) {
                sb.append(Integer.toHexString(labels[i]).toUpperCase());
                sb.append(":");
            }
            if (start == 0) {
                sb.append(":");
            }
            sb.append(":");
            for (i = start + length + 1; i < 8; ++i) {
                sb.append(Integer.toHexString(labels[i]).toUpperCase());
                if (i == 7) continue;
                sb.append(":");
            }
        }
        return sb.toString();
    }
}

