/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.util.Random;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Flags;
import pluto.DNS.Opcode;
import pluto.DNS.Rcode;
import pluto.DNS.Section;

public class Header {
    private int id;
    private boolean[] flags;
    private int rcode;
    private int opcode;
    private int[] counts = new int[4];
    private static Random random = new Random();
    public static final int LENGTH = 12;

    public Header(int id) {
        this.flags = new boolean[16];
        this.id = id;
    }

    public Header() {
        this(random.nextInt(65535));
    }

    Header(DNSInput in) throws IOException {
        this(in.readU16());
        this.readFlags(in);
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = in.readU16();
        }
    }

    public Header(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    void toWire(DNSOutput out) {
        out.writeU16(this.getID());
        this.writeFlags(out);
        for (int i = 0; i < this.counts.length; ++i) {
            out.writeU16(this.counts[i]);
        }
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        return out.toByteArray();
    }

    public void setFlag(int bit) {
        this.flags[bit] = true;
    }

    public void unsetFlag(int bit) {
        this.flags[bit] = false;
    }

    public boolean getFlag(int bit) {
        return this.flags[bit];
    }

    boolean[] getFlags() {
        return this.flags;
    }

    public int getID() {
        return this.id & 0xFFFF;
    }

    public void setID(int id) {
        if (this.opcode > 255) {
            throw new IllegalArgumentException("DNS message ID " + id + "is out of range");
        }
        this.id = id;
    }

    static int randomID() {
        return random.nextInt(65535);
    }

    public void setRcode(int value) {
        if (this.opcode > 15) {
            throw new IllegalArgumentException("DNS Rcode " + value + "is out of range");
        }
        this.rcode = value;
    }

    public int getRcode() {
        return this.rcode;
    }

    public void setOpcode(int value) {
        if (this.opcode > 15) {
            throw new IllegalArgumentException("DNS Opcode " + value + "is out of range");
        }
        this.opcode = value;
    }

    public int getOpcode() {
        return this.opcode;
    }

    void setCount(int field, int value) {
        if (value > 255) {
            throw new IllegalArgumentException("DNS section count " + value + "is out of range");
        }
        this.counts[field] = value;
    }

    void incCount(int field) {
        int n = field;
        this.counts[n] = this.counts[n] + 1;
    }

    void decCount(int field) {
        int n = field;
        this.counts[n] = this.counts[n] - 1;
    }

    public int getCount(int field) {
        return this.counts[field];
    }

    private void writeFlags(DNSOutput out) {
        int flagsval = 0;
        for (int i = 0; i < 16; ++i) {
            if (!this.flags[i]) continue;
            flagsval |= 1 << 15 - i;
        }
        flagsval |= this.opcode << 11;
        out.writeU16(flagsval |= this.rcode);
    }

    private void readFlags(DNSInput in) throws IOException {
        int flagsval = in.readU16();
        for (int i = 0; i < 16; ++i) {
            this.flags[i] = (flagsval & 1 << 15 - i) != 0;
        }
        this.opcode = (byte)(flagsval >> 11 & 0xF);
        this.rcode = (byte)(flagsval & 0xF);
    }

    public String printFlags() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.flags.length; ++i) {
            if (!Flags.isFlag(i) || !this.getFlag(i)) continue;
            sb.append(Flags.string(i));
            sb.append(" ");
        }
        return sb.toString();
    }

    String toStringWithRcode(int newrcode) {
        StringBuffer sb = new StringBuffer();
        sb.append(";; ->>HEADER<<- ");
        sb.append("opcode: " + Opcode.string(this.getOpcode()));
        sb.append(", status: " + Rcode.string(newrcode));
        sb.append(", id: " + this.getID());
        sb.append("\n");
        sb.append(";; flags: " + this.printFlags());
        sb.append("; ");
        for (int i = 0; i < 4; ++i) {
            sb.append(Section.string(i) + ": " + this.getCount(i) + " ");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public Object clone() {
        Header h = new Header(this.id);
        System.arraycopy(this.counts, 0, h.counts, 0, this.counts.length);
        System.arraycopy(this.flags, 0, h.flags, 0, this.flags.length);
        h.rcode = this.rcode;
        h.rcode = this.rcode;
        h.opcode = this.opcode;
        return h;
    }
}

