/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.DNS.Name;
import pluto.DNS.Options;
import pluto.DNS.TextParseException;

public class FindServer {
    private static final Logger log = LoggerFactory.getLogger(FindServer.class);
    private static String[] servers = null;
    private static Name[] searchlist = null;

    private FindServer() {
    }

    private static void addServer(String server, List list) {
        if (list.contains(server)) {
            return;
        }
        if (Options.check("verbose")) {
            log.debug("adding server " + server);
        }
        list.add(server);
    }

    private static void addSearch(String search, List list) {
        Name name;
        if (Options.check("verbose")) {
            log.debug("adding search " + search);
        }
        try {
            name = Name.fromString(search, Name.root);
        }
        catch (TextParseException e) {
            return;
        }
        if (list.contains(name)) {
            return;
        }
        list.add(name);
    }

    private static void findProperty() {
        StringTokenizer st;
        ArrayList l = new ArrayList(0);
        String prop = System.getProperty("dns.server");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                FindServer.addServer(st.nextToken(), l);
            }
            if (l.size() > 0) {
                servers = l.toArray(new String[l.size()]);
            }
        }
        l.clear();
        prop = System.getProperty("dns.search");
        if (prop != null) {
            st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                FindServer.addSearch(st.nextToken(), l);
            }
            if (l.size() > 0) {
                searchlist = l.toArray(new Name[l.size()]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findResolvConf(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        ArrayList lserver = new ArrayList(0);
        ArrayList lsearch = new ArrayList(0);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st;
                if (line.startsWith("nameserver")) {
                    st = new StringTokenizer(line);
                    st.nextToken();
                    FindServer.addServer(st.nextToken(), lserver);
                    continue;
                }
                if (line.startsWith("domain")) {
                    st = new StringTokenizer(line);
                    st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    FindServer.addSearch(st.nextToken(), lsearch);
                    continue;
                }
                if (!line.startsWith("search")) continue;
                st = new StringTokenizer(line);
                st.nextToken();
                while (st.hasMoreTokens()) {
                    FindServer.addSearch(st.nextToken(), lsearch);
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error(e.toString());
                }
                br = null;
            }
        }
        if (servers == null && lserver.size() > 0) {
            servers = lserver.toArray(new String[lserver.size()]);
        }
        if (searchlist == null && lsearch.size() > 0) {
            searchlist = lsearch.toArray(new Name[lsearch.size()]);
        }
    }

    private static void findUnix() {
        FindServer.findResolvConf("/etc/resolv.conf");
    }

    private static void findNetware() {
        FindServer.findResolvConf("sys:/etc/resolv.cfg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findWin(InputStream in) {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            ArrayList lserver = new ArrayList();
            ArrayList lsearch = new ArrayList();
            String line = null;
            boolean readingServers = false;
            boolean readingSearches = false;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    readingServers = false;
                    readingSearches = false;
                    continue;
                }
                String s = st.nextToken();
                if (line.indexOf(":") != -1) {
                    readingServers = false;
                    readingSearches = false;
                }
                if (line.indexOf("Host Name") != -1) {
                    Name name;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    try {
                        name = Name.fromString(s, null);
                    }
                    catch (TextParseException e) {
                        continue;
                    }
                    if (name.labels() == 1) continue;
                    FindServer.addSearch(s, lsearch);
                    continue;
                }
                if (line.indexOf("Primary Dns Suffix") != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    FindServer.addSearch(s, lsearch);
                    readingSearches = true;
                    continue;
                }
                if (readingSearches || line.indexOf("DNS Suffix") != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    FindServer.addSearch(s, lsearch);
                    readingSearches = true;
                    continue;
                }
                if (!readingServers && line.indexOf("DNS Servers") == -1) continue;
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                }
                if (s.equals(":")) continue;
                FindServer.addServer(s, lserver);
                readingServers = true;
            }
            if (servers == null && lserver.size() > 0) {
                servers = lserver.toArray(new String[lserver.size()]);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void find95() {
        String s = "winipcfg.out";
        try {
            Process p = Runtime.getRuntime().exec("winipcfg /all /batch " + s);
            p.waitFor();
            File f = new File(s);
            FindServer.findWin(new FileInputStream(f));
            boolean fileDel = new File(s).delete();
            if (!fileDel) {
                log.error("File deletion failed");
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private static void findNT() {
        try {
            Process p = Runtime.getRuntime().exec("ipconfig /all");
            FindServer.findWin(p.getInputStream());
            p.destroy();
        }
        catch (Exception e) {
            return;
        }
    }

    public static String[] servers() {
        return servers;
    }

    public static String server() {
        if (servers == null) {
            return null;
        }
        return servers[0];
    }

    public static Name[] searchPath() {
        return searchlist;
    }

    static {
        FindServer.findProperty();
        if (servers == null || searchlist == null) {
            String OS = System.getProperty("os.name");
            if (OS.indexOf("Windows") != -1) {
                if (OS.indexOf("95") != -1 || OS.indexOf("98") != -1 || OS.indexOf("ME") != -1) {
                    FindServer.find95();
                } else {
                    FindServer.findNT();
                }
            } else if (OS.indexOf("NetWare") != -1) {
                FindServer.findNetware();
            } else {
                FindServer.findUnix();
            }
        }
    }
}

