/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.util.Arrays;
import java.util.Iterator;
import pluto.DNS.DNSOutput;
import pluto.DNS.Message;
import pluto.DNS.Mnemonic;
import pluto.DNS.Name;
import pluto.DNS.RRset;
import pluto.DNS.Record;
import pluto.DNS.SIGRecord;

public class DNSSEC {
    public static final int RSAMD5 = 1;
    public static final int RSA = 1;
    public static final int DH = 2;
    public static final int DSA = 3;
    public static final int RSASHA1 = 5;
    public static final int Failed = -1;
    public static final int Insecure = 0;
    public static final int Secure = 1;

    private DNSSEC() {
    }

    private static void digestSIG(DNSOutput out, SIGRecord sig) {
        out.writeU16(sig.getTypeCovered());
        out.writeU8(sig.getAlgorithm());
        out.writeU8(sig.getLabels());
        out.writeU32(sig.getOrigTTL());
        out.writeU32(sig.getExpire().getTime() / 1000L);
        out.writeU32(sig.getTimeSigned().getTime() / 1000L);
        out.writeU16(sig.getFootprint());
        sig.getSigner().toWireCanonical(out);
    }

    public static byte[] digestRRset(SIGRecord sig, RRset rrset) {
        DNSOutput out = new DNSOutput();
        DNSSEC.digestSIG(out, sig);
        int size = rrset.size();
        byte[][] records = new byte[size][];
        Iterator it = rrset.rrs();
        Name name = rrset.getName();
        Name wild = null;
        if (name.labels() > sig.getLabels()) {
            wild = name.wild(name.labels() - sig.getLabels());
        }
        while (it.hasNext()) {
            Record rec = (Record)it.next();
            if (wild != null) {
                rec = rec.withName(wild);
            }
            records[--size] = rec.toWireCanonical();
        }
        Arrays.sort((Object[])records);
        for (int i = 0; i < records.length; ++i) {
            out.writeByteArray(records[i]);
        }
        return out.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sig, Message msg, byte[] previous) {
        DNSOutput out = new DNSOutput();
        DNSSEC.digestSIG(out, sig);
        if (previous != null) {
            out.writeByteArray(previous);
        }
        msg.toWire(out);
        return out.toByteArray();
    }

    public static class Algorithm {
        public static final int RSAMD5 = 1;
        public static final int DH = 2;
        public static final int DSA = 3;
        public static final int ECC = 4;
        public static final int RSASHA1 = 5;
        public static final int INDIRECT = 252;
        public static final int PRIVATEDNS = 253;
        public static final int PRIVATEOID = 254;
        private static Mnemonic algs = new Mnemonic("DNSSEC algorithm", 2);

        private Algorithm() {
        }

        public static String string(int alg) {
            return algs.getText(alg);
        }

        public static int value(String s) {
            return algs.getValue(s);
        }

        static {
            algs.setMaximum(255);
            algs.setNumericAllowed(true);
            algs.add(1, "RSAMD5");
            algs.add(2, "DH");
            algs.add(3, "DSA");
            algs.add(4, "ECC");
            algs.add(5, "RSASHA1");
            algs.add(252, "INDIRECT");
            algs.add(253, "PRIVATEDNS");
            algs.add(254, "PRIVATEOID");
        }
    }
}

