/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.DNS.CNAMERecord;
import pluto.DNS.DNAMERecord;
import pluto.DNS.Master;
import pluto.DNS.Message;
import pluto.DNS.Name;
import pluto.DNS.NameSet;
import pluto.DNS.NameTooLongException;
import pluto.DNS.Options;
import pluto.DNS.RRset;
import pluto.DNS.Record;
import pluto.DNS.SOARecord;
import pluto.DNS.SetResponse;
import pluto.DNS.Type;
import pluto.DNS.TypedObject;
import pluto.DNS.Verifier;

public class Cache
extends NameSet {
    private static final Logger log = LoggerFactory.getLogger(Cache.class);
    private static final int defaultCleanInterval = 30;
    private Verifier verifier;
    private boolean secure;
    private int maxncache = -1;
    private int maxcache = -1;
    private CacheCleaner cleaner;

    public Cache(int dclass, int cleanInterval) {
        super(true);
        this.setCleanInterval(cleanInterval);
    }

    public Cache(int dclass) {
        this(dclass, 30);
    }

    public Cache() {
        this(1, 30);
    }

    public void clearCache() {
        this.clear();
    }

    public Cache(String file) throws IOException {
        super(true);
        Record record;
        this.cleaner = new CacheCleaner(this, 30);
        Master m = new Master(file);
        while ((record = m.nextRecord()) != null) {
            this.addRecord(record, 0, m);
        }
    }

    public void addRecord(Record r, int cred, Object o) {
        Name name = r.getName();
        int type = r.getRRsetType();
        if (!Type.isRR(type)) {
            return;
        }
        Element element = (Element)this.findExactSet(name, type);
        if (element == null || cred > element.credibility) {
            RRset rrset = new RRset();
            rrset.addRR(r);
            this.addRRset(rrset, cred);
        } else if (cred == element.credibility && element instanceof PositiveElement) {
            PositiveElement pe = (PositiveElement)element;
            pe.rrset.addRR(r);
        }
    }

    public void addRRset(RRset rrset, int cred) {
        long ttl = rrset.getTTL();
        Name name = rrset.getName();
        int type = rrset.getType();
        if (this.verifier != null) {
            rrset.setSecurity(this.verifier.verify(rrset, this));
        }
        if (this.secure && rrset.getSecurity() < 1) {
            return;
        }
        Element element = (Element)this.findExactSet(name, type);
        if (ttl == 0L) {
            if (element != null && cred >= element.credibility) {
                this.removeSet(name, type, element);
            }
        } else if (element == null || cred >= element.credibility) {
            this.addSet(name, type, new PositiveElement(rrset, cred, this.maxcache));
        }
    }

    public void addNegative(Name name, int type, SOARecord soa, int cred) {
        if (this.verifier != null && this.secure) {
            return;
        }
        Element element = (Element)this.findExactSet(name, type);
        if ((soa == null || soa.getTTL() == 0L) && element != null && cred >= element.credibility) {
            this.removeSet(name, type, element);
        }
        if (element == null || cred >= element.credibility) {
            this.addSet(name, type, new NegativeElement(name, type, soa, cred, this.maxncache));
        }
    }

    private void logLookup(Name name, int type, String msg) {
        System.err.println("lookupRecords(" + name + " " + Type.string(type) + "): " + msg);
    }

    public SetResponse lookupRecords(Name name, int type, int minCred) {
        Element element;
        int i;
        SetResponse cr = null;
        boolean verbose = Options.check("verbosecache");
        Object o = this.lookup(name, type);
        if (verbose) {
            this.logLookup(name, type, "Starting");
        }
        if (o == null || o == NXRRSET) {
            if (verbose) {
                this.logLookup(name, type, "no information found");
            }
            return SetResponse.ofType(0);
        }
        Object[] objects = o instanceof Element ? new Object[]{o} : (Object[])o;
        int nelements = 0;
        for (i = 0; i < objects.length; ++i) {
            element = (Element)objects[i];
            if (element.expired()) {
                if (verbose) {
                    this.logLookup(name, type, element.toString());
                    this.logLookup(name, type, "expired: ignoring");
                }
                this.removeSet(name, type, element);
                objects[i] = null;
                continue;
            }
            if (element.credibility < minCred) {
                if (verbose) {
                    this.logLookup(name, type, element.toString());
                    this.logLookup(name, type, "not credible: ignoring");
                }
                objects[i] = null;
                continue;
            }
            ++nelements;
        }
        if (nelements == 0) {
            if (verbose) {
                this.logLookup(name, type, "no useful data found");
            }
            return SetResponse.ofType(0);
        }
        for (i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            element = (Element)objects[i];
            if (verbose) {
                this.logLookup(name, type, element.toString());
            }
            RRset rrset = null;
            if (element instanceof PositiveElement) {
                rrset = ((PositiveElement)element).rrset;
            }
            if (rrset == null) {
                if (element.getType() == 0) {
                    if (verbose) {
                        this.logLookup(name, type, "NXDOMAIN");
                    }
                    return SetResponse.ofType(1);
                }
                if (type != 255) {
                    if (verbose) {
                        this.logLookup(name, type, "NXRRSET");
                    }
                    return SetResponse.ofType(2);
                }
                if (!verbose) continue;
                this.logLookup(name, type, "ANY query; ignoring NXRRSET");
                continue;
            }
            int rtype = rrset.getType();
            Name rname = rrset.getName();
            if (name.equals(rname)) {
                if (type != 5 && type != 255 && rtype == 5) {
                    if (verbose) {
                        this.logLookup(name, type, "cname");
                    }
                    return new SetResponse(4, rrset);
                }
                if (type != 2 && type != 255 && rtype == 2) {
                    if (verbose) {
                        this.logLookup(name, type, "exact delegation");
                    }
                    return new SetResponse(3, rrset);
                }
                if (verbose) {
                    this.logLookup(name, type, "exact match");
                }
                if (cr == null) {
                    cr = new SetResponse(6);
                }
                cr.addRRset(rrset);
                continue;
            }
            if (name.subdomain(rname)) {
                if (rtype == 39) {
                    if (verbose) {
                        this.logLookup(name, type, "dname");
                    }
                    return new SetResponse(5, rrset);
                }
                if (rtype == 2) {
                    if (verbose) {
                        this.logLookup(name, type, "parent delegation");
                    }
                    return new SetResponse(3, rrset);
                }
                if (!verbose) continue;
                this.logLookup(name, type, "ignoring rrset (" + rname + " " + Type.string(rtype) + ")");
                continue;
            }
            if (!verbose) continue;
            this.logLookup(name, type, "ignoring rrset (" + rname + " " + Type.string(rtype) + ")");
        }
        if (cr == null && type == 255) {
            return SetResponse.ofType(0);
        }
        if (cr == null) {
            throw new IllegalStateException("looking up (" + name + " " + Type.string(type) + "): cr == null.");
        }
        return cr;
    }

    private RRset[] findRecords(Name name, int type, int minCred) {
        SetResponse cr = this.lookupRecords(name, type, minCred);
        if (cr.isSuccessful()) {
            return cr.answers();
        }
        return null;
    }

    public RRset[] findRecords(Name name, int type) {
        return this.findRecords(name, type, 3);
    }

    public RRset[] findAnyRecords(Name name, int type) {
        return this.findRecords(name, type, 2);
    }

    private final int getCred(int section, boolean isAuth) {
        if (section == 1) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 2) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static void markAdditional(RRset rrset, Set names) {
        Record first = rrset.first();
        if (first.getAdditionalName() == null) {
            return;
        }
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            Name name = r.getAdditionalName();
            if (name == null) continue;
            names.add(name);
        }
    }

    public SetResponse addMessage(Message in) {
        int i;
        int cred;
        boolean isAuth = in.getHeader().getFlag(5);
        Record question = in.getQuestion();
        int rcode = in.getHeader().getRcode();
        boolean completed = false;
        SetResponse response = null;
        boolean verbose = Options.check("verbosecache");
        if (rcode != 0 && rcode != 3 || question == null) {
            return null;
        }
        Name qname = question.getName();
        int qtype = question.getType();
        int qclass = question.getDClass();
        Name curname = qname;
        HashSet additionalNames = new HashSet();
        RRset[] answers = in.getSectionRRsets(1);
        for (int i2 = 0; i2 < answers.length; ++i2) {
            if (answers[i2].getDClass() != qclass) continue;
            int type = answers[i2].getType();
            Name name = answers[i2].getName();
            cred = this.getCred(1, isAuth);
            if ((type == qtype || qtype == 255) && name.equals(curname)) {
                this.addRRset(answers[i2], cred);
                completed = true;
                if (curname == qname) {
                    if (response == null) {
                        response = new SetResponse(6);
                    }
                    response.addRRset(answers[i2]);
                }
                Cache.markAdditional(answers[i2], additionalNames);
                continue;
            }
            if (type == 5 && name.equals(curname)) {
                this.addRRset(answers[i2], cred);
                if (curname == qname) {
                    response = new SetResponse(4, answers[i2]);
                }
                CNAMERecord cname = (CNAMERecord)answers[i2].first();
                curname = cname.getTarget();
                continue;
            }
            if (type != 39 || !curname.subdomain(name)) continue;
            this.addRRset(answers[i2], cred);
            if (curname == qname) {
                response = new SetResponse(5, answers[i2]);
            }
            DNAMERecord dname = (DNAMERecord)answers[i2].first();
            try {
                curname = curname.fromDNAME(dname);
                continue;
            }
            catch (NameTooLongException e) {
                break;
            }
        }
        RRset[] auth = in.getSectionRRsets(2);
        RRset soa = null;
        RRset ns = null;
        for (i = 0; i < auth.length; ++i) {
            if (auth[i].getType() == 6 && curname.subdomain(auth[i].getName())) {
                soa = auth[i];
                continue;
            }
            if (auth[i].getType() != 2 || !curname.subdomain(auth[i].getName())) continue;
            ns = auth[i];
        }
        if (!completed) {
            int cachetype;
            int n = cachetype = rcode == 3 ? 0 : qtype;
            if (soa != null || ns == null) {
                cred = this.getCred(2, isAuth);
                SOARecord soarec = null;
                if (soa != null) {
                    soarec = (SOARecord)soa.first();
                }
                this.addNegative(curname, cachetype, soarec, cred);
                if (response == null) {
                    int responseType = rcode == 3 ? 1 : 2;
                    response = SetResponse.ofType(responseType);
                }
            } else {
                cred = this.getCred(2, isAuth);
                this.addRRset(ns, cred);
                Cache.markAdditional(ns, additionalNames);
                if (response == null) {
                    response = new SetResponse(3, ns);
                }
            }
        } else if (rcode == 0 && ns != null) {
            cred = this.getCred(2, isAuth);
            this.addRRset(ns, cred);
            Cache.markAdditional(ns, additionalNames);
        }
        RRset[] addl = in.getSectionRRsets(3);
        for (i = 0; i < addl.length; ++i) {
            Name name;
            int type = addl[i].getType();
            if (type != 1 && type != 28 && type != 38 || !additionalNames.contains(name = addl[i].getName())) continue;
            cred = this.getCred(3, isAuth);
            this.addRRset(addl[i], cred);
        }
        if (verbose) {
            log.debug("addMessage: " + response);
        }
        return response;
    }

    public void flushSet(Name name, int type) {
        Element element = (Element)this.findExactSet(name, type);
        if (element == null) {
            return;
        }
        this.removeSet(name, type, element);
    }

    public void flushName(Name name) {
        this.removeName(name);
    }

    public void setVerifier(Verifier v) {
        this.verifier = v;
    }

    public void setSecurePolicy() {
        this.secure = true;
    }

    public void setMaxNCache(int seconds) {
        this.maxncache = seconds;
    }

    public void setMaxCache(int seconds) {
        this.maxcache = seconds;
    }

    public void setCleanInterval(int cleanInterval) {
        if (this.cleaner != null) {
            this.cleaner.interrupt();
        }
        if (cleanInterval > 0) {
            this.cleaner = new CacheCleaner(this, cleanInterval);
        }
    }

    protected void finalize() throws Throwable {
        this.setCleanInterval(0);
    }

    private static class CacheCleaner
    extends Thread {
        private Reference cacheref;
        private long interval;

        public CacheCleaner(Cache cache, int cleanInterval) {
            this.cacheref = new WeakReference<Cache>(cache);
            this.interval = (long)(cleanInterval * 60) * 1000L;
            this.setDaemon(true);
            this.setName("pluto.DNS.Cache.CacheCleaner");
            this.start();
        }

        private boolean clean(Cache cache) {
            Iterator it = cache.names();
            while (it.hasNext()) {
                Name name;
                try {
                    name = (Name)it.next();
                }
                catch (ConcurrentModificationException e) {
                    return false;
                }
                Object[] elements = cache.findExactSets(name);
                for (int i = 0; i < elements.length; ++i) {
                    Element element = (Element)elements[i];
                    if (!element.expired()) continue;
                    cache.removeSet(name, element.getType(), element);
                }
            }
            return true;
        }

        @Override
        public void run() {
            block2: while (true) {
                long now = System.currentTimeMillis();
                long next = now + this.interval;
                while (now < next) {
                    try {
                        Thread.sleep(next - now);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    now = System.currentTimeMillis();
                }
                Cache cache = (Cache)this.cacheref.get();
                if (cache == null) {
                    return;
                }
                int i = 0;
                while (true) {
                    if (i >= 4 || this.clean(cache)) continue block2;
                    ++i;
                }
                break;
            }
        }
    }

    private static class NegativeElement
    extends Element {
        int type;
        Name name;
        SOARecord soa;

        public NegativeElement(Name name, int type, SOARecord soa, int cred, long maxttl) {
            this.name = name;
            this.type = type;
            this.soa = soa;
            long cttl = 0L;
            if (soa != null) {
                cttl = soa.getMinimum();
                if (maxttl >= 0L) {
                    cttl = Math.min(cttl, maxttl);
                }
            }
            this.setValues(cred, cttl);
        }

        @Override
        public int getType() {
            return this.type;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.type == 0) {
                sb.append("NXDOMAIN " + this.name);
            } else {
                sb.append("NXRRSET " + this.name + " " + Type.string(this.type));
            }
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static class PositiveElement
    extends Element {
        RRset rrset;

        public PositiveElement(RRset r, int cred, long maxttl) {
            this.rrset = r;
            long ttl = r.getTTL();
            if (maxttl >= 0L && maxttl < ttl) {
                ttl = maxttl;
            }
            this.setValues(cred, ttl);
        }

        @Override
        public int getType() {
            return this.rrset.getType();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.rrset);
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static abstract class Element
    implements TypedObject {
        int credibility;
        int expire;

        private Element() {
        }

        protected void setValues(int credibility, long ttl) {
            this.credibility = credibility;
            this.expire = (int)(System.currentTimeMillis() / 1000L + ttl);
            if (this.expire < 0 || this.expire > Integer.MAX_VALUE) {
                this.expire = Integer.MAX_VALUE;
            }
        }

        public final boolean expired() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            return now >= this.expire;
        }

        @Override
        public abstract int getType();
    }
}

