/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.mass.webresearch;

import java.util.Properties;
import java.util.Vector;
import mercury.contents.mass.research.AnsProperty;
import mercury.contents.mass.research.FormTokenizer;
import mercury.contents.mass.webresearch.WebResearchMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.util.StringConvertUtil;

public class WebResearchModifier
extends Vector {
    private static final Logger log = LoggerFactory.getLogger(WebResearchModifier.class);
    public static String RESEARCH_FORM_START = null;
    public static String RESEARCH_SUBMIT_BUTTON = null;
    public static String RESEARCH_SCRIPT = null;
    public static String RESEARCH_MEMBER_ID = null;
    public static String RESEARCH_MEMBER_NAME = null;
    public static String RESEARCH_EMAIL_ID = null;
    public static String RESEARCH_USER_ID = null;
    public static String RESEARCH_FIELD1 = null;
    public static String RESEARCH_FIELD2 = null;
    public static String RESEARCH_FIELD3 = null;
    public static String RESEARCH_FIELD4 = null;
    public static String RESEARCH_FIELD5 = null;
    public static String RESEARCH_FIELD6 = null;
    public static String RESEARCH_FIELD7 = null;
    public static String RESEARCH_FIELD8 = null;
    private String body = null;
    private int link_index = 0;
    FormTokenizer myFormTokenizer = new FormTokenizer();
    private String PARSED_RESULT_STRING = null;
    protected Properties SCHEDULE_INFO = null;

    public WebResearchModifier() throws Exception {
    }

    public WebResearchModifier(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
    }

    public String getModify() {
        return this.PARSED_RESULT_STRING;
    }

    public boolean process(String content, int idx) {
        this.body = content;
        this.link_index = idx + 1;
        String source = this.body.toLowerCase();
        if (source.indexOf("${map_re}") < 0) {
            return false;
        }
        if (source.indexOf("<form") < 0) {
            this.body = this.addForm(this.body);
            source = this.body.toLowerCase();
        }
        if (source.indexOf("<script") < 0) {
            this.body = this.addScript(this.body);
            source = this.body.toLowerCase();
        }
        int idx1 = 0;
        int idx2 = 0;
        int idxSF = 0;
        int idxEF = 0;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            while ((idx1 = source.indexOf("<form", idx2)) >= 0) {
                buffer.append(this.body.substring(idx2, idx1));
                idxSF = source.indexOf(">", idx1);
                if (idxSF < 0) break;
                ++idxSF;
                idxEF = source.indexOf("</form", idx1);
                if (idxEF < 0 || (idx2 = source.indexOf(">", idxEF)) < 0) break;
                if (source.substring(idx1, ++idx2).indexOf("${map_re}") > 0) {
                    try {
                        buffer.append(this.convertForm(this.body.substring(idxSF, idxEF)));
                    }
                    catch (Exception e) {
                        log.error("Exception", (Throwable)e);
                        buffer.append(this.body.substring(idx1, idx2));
                    }
                    continue;
                }
                buffer.append(this.body.substring(idx1, idx2));
            }
            if (idx1 < 0) {
                buffer.append(this.body.substring(idx2));
            }
            if (idx2 < 0) {
                buffer.append(this.body.substring(idx1));
            }
            this.PARSED_RESULT_STRING = buffer.toString();
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
        return true;
    }

    protected String convertForm(String src) throws Exception {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, RESEARCH_FORM_START, this.SCHEDULE_INFO, "${", "}", false, true);
            buffer.append("\r\n");
            buffer.append("<input type=\"hidden\" name=\"emsinfo_");
            buffer.append(String.valueOf(this.link_index++));
            buffer.append("\" value=\"-1\">\r\n");
            this.myFormTokenizer.process(src);
            for (int i = 0; i < this.myFormTokenizer.size(); ++i) {
                AnsProperty oneAp = (AnsProperty)this.myFormTokenizer.elementAt(i);
                String name = oneAp.getNAME();
                short type = oneAp.getTYPE();
                Vector values = oneAp.getVALUE();
                for (int j = 0; j < values.size(); ++j) {
                    String typeStr = null;
                    switch (type) {
                        case 5: {
                            typeStr = "SELECT";
                            break;
                        }
                        case 1: {
                            typeStr = "TEXT";
                            break;
                        }
                        case 4: {
                            typeStr = "RADIO BOX";
                            break;
                        }
                        case 3: {
                            typeStr = "CHECK BOX";
                            break;
                        }
                        case 2: {
                            typeStr = "TEXT AREA";
                            break;
                        }
                        default: {
                            typeStr = "Unknown";
                        }
                    }
                    String oneValue = (String)values.elementAt(j);
                    String tempValue = type + "_" + name + "_" + oneValue;
                    String desc = name + "(" + oneValue + ") : " + typeStr;
                    String tempName = "emsinfo_" + this.link_index;
                    this.addElement(new WebResearchMetaData(this.link_index, desc, name, oneValue, type));
                    if (log.isDebugEnabled()) {
                        log.debug("Debug: " + desc);
                    }
                    buffer.append("<input type=\"hidden\" name=\"");
                    buffer.append(tempName);
                    buffer.append("\" value=\"");
                    buffer.append(tempValue);
                    buffer.append("\">\r\n");
                    ++this.link_index;
                }
            }
            buffer.append(src);
            buffer.append("\r\n</form>");
            String result_source = buffer.toString();
            result_source = result_source.replaceAll("\\$\\{map_re\\}", RESEARCH_SUBMIT_BUTTON);
            result_source = result_source.replaceAll("\\$\\{MAP_RE\\}", RESEARCH_SUBMIT_BUTTON);
            result_source = result_source.replaceAll("\\$\\{tms_m_id\\}", RESEARCH_MEMBER_ID);
            result_source = result_source.replaceAll("\\$\\{TMS_M_ID\\}", RESEARCH_MEMBER_ID);
            result_source = result_source.replaceAll("\\$\\{tms_m_name\\}", RESEARCH_MEMBER_NAME);
            result_source = result_source.replaceAll("\\$\\{TMS_M_NAME\\}", RESEARCH_MEMBER_NAME);
            result_source = result_source.replaceAll("\\$\\{tms_m_token\\}", RESEARCH_EMAIL_ID);
            result_source = result_source.replaceAll("\\$\\{TMS_M_TOKEN\\}", RESEARCH_EMAIL_ID);
            result_source = result_source.replaceAll("\\$\\{field1\\}", RESEARCH_FIELD1);
            result_source = result_source.replaceAll("\\$\\{FIELD1\\}", RESEARCH_FIELD1);
            result_source = result_source.replaceAll("\\$\\{field2\\}", RESEARCH_FIELD2);
            result_source = result_source.replaceAll("\\$\\{FIELD2\\}", RESEARCH_FIELD2);
            result_source = result_source.replaceAll("\\$\\{field3\\}", RESEARCH_FIELD3);
            result_source = result_source.replaceAll("\\$\\{FIELD3\\}", RESEARCH_FIELD3);
            result_source = result_source.replaceAll("\\$\\{field4\\}", RESEARCH_FIELD4);
            result_source = result_source.replaceAll("\\$\\{FIELD4\\}", RESEARCH_FIELD4);
            result_source = result_source.replaceAll("\\$\\{field5\\}", RESEARCH_FIELD5);
            result_source = result_source.replaceAll("\\$\\{FIELD5\\}", RESEARCH_FIELD5);
            result_source = result_source.replaceAll("\\$\\{field6\\}", RESEARCH_FIELD6);
            result_source = result_source.replaceAll("\\$\\{FIELD6\\}", RESEARCH_FIELD6);
            result_source = result_source.replaceAll("\\$\\{field7\\}", RESEARCH_FIELD7);
            result_source = result_source.replaceAll("\\$\\{FIELD7\\}", RESEARCH_FIELD7);
            result_source = result_source.replaceAll("\\$\\{field8\\}", RESEARCH_FIELD8);
            String string = result_source = result_source.replaceAll("\\$\\{FIELD8\\}", RESEARCH_FIELD8);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addScript(String source) {
        String src = source.toLowerCase();
        int idx1 = src.indexOf("</head");
        if (idx1 < 0) {
            return src;
        }
        int idx2 = src.indexOf(">", idx1);
        if (idx2 < 0) {
            return src;
        }
        int insert_start_point = idx1;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            buffer.append(source);
            buffer.insert(insert_start_point, RESEARCH_SCRIPT);
            String string = buffer.toString();
            return string;
        }
        finally {
            buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addForm(String source) {
        String src = source.toLowerCase();
        int idx1 = src.indexOf("<body");
        if (idx1 < 0) {
            return src;
        }
        int idx2 = src.indexOf(">", idx1);
        if (idx2 < 0) {
            return src;
        }
        int insert_start_point = idx2 + 1;
        idx1 = src.indexOf("</body", insert_start_point);
        if (idx1 < 0) {
            return src;
        }
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            buffer.append(source);
            buffer.insert(idx1, "</form>");
            buffer.insert(insert_start_point, "<form>");
            String string = buffer.toString();
            return string;
        }
        finally {
            buffer = null;
        }
    }

    static {
        RESEARCH_FORM_START = eMsSystem.getProperty("ems.webresearch.tag", "defaultadd");
        RESEARCH_SUBMIT_BUTTON = eMsSystem.getProperty("ems.submit.webresearch", "submit button");
        RESEARCH_SCRIPT = eMsSystem.getProperty("ems.webresearch.script", "defaultadd");
        RESEARCH_MEMBER_ID = eMsSystem.getProperty("ems.mapping.member_id", "member_id");
        RESEARCH_MEMBER_NAME = eMsSystem.getProperty("ems.mapping.member_name", "member_name");
        RESEARCH_EMAIL_ID = eMsSystem.getProperty("ems.mapping.email_id", "email_id");
        RESEARCH_USER_ID = eMsSystem.getProperty("ems.mapping.user_id", "user_id");
        RESEARCH_FIELD1 = eMsSystem.getProperty("ems.mapping.field1", "field1");
        RESEARCH_FIELD2 = eMsSystem.getProperty("ems.mapping.field2", "field2");
        RESEARCH_FIELD3 = eMsSystem.getProperty("ems.mapping.field3", "field3");
        RESEARCH_FIELD4 = eMsSystem.getProperty("ems.mapping.field4", "field4");
        RESEARCH_FIELD5 = eMsSystem.getProperty("ems.mapping.field5", "field5");
        RESEARCH_FIELD6 = eMsSystem.getProperty("ems.mapping.field6", "field6");
        RESEARCH_FIELD7 = eMsSystem.getProperty("ems.mapping.field7", "field7");
        RESEARCH_FIELD8 = eMsSystem.getProperty("ems.mapping.field8", "field8");
    }
}

