/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.mass.webproducer;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.producer.CommonContentPD;
import mercury.contents.common.util.LinkContent;
import mercury.contents.common.util.MappingImgStripper;
import mercury.contents.common.util.TrackingInfoConvertor;
import mercury.contents.mass.research.ResearchMetaData;
import mercury.contents.mass.research.ResearchModifier;
import mercury.contents.mass.webpoll.WebPollModifier;
import mercury.contents.mass.webresearch.WebResearchMetaData;
import mercury.contents.mass.webresearch.WebResearchModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class SingleRcptTrackingContentPD
extends CommonContentPD {
    private static final Logger log = LoggerFactory.getLogger(SingleRcptTrackingContentPD.class);
    protected static String QUERY_INSERT_LINKINFO = null;
    protected static String QUERY_UPDATE_LINKINFO = null;
    protected static String QUERY_INSERT_RESEARCH_INFO = null;
    protected static String QUERY_DELETE_TRACKING_INFO = null;
    protected static String QUERY_UPDATE_RESEARCH_CONTENT_PATTERN = null;
    protected static String QUERY_SELECT_POLLHTML_INFO = null;
    protected static String TRACKING_URL = null;
    protected static String ALPHA2_TRACKING_URL = null;
    public static String DEFAULT_SINGLE_MAPPING_HEADER = null;
    protected String instance_TRACKING_URL = null;
    protected String instance_ADD_URL_STRING = null;

    @Override
    protected void initProperty(Properties info) throws Exception {
        super.initProperty(info);
        this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");
        this.setName(this.POST_ID + "_MassTrackingContentPD");
        this.WORK_FILE_ID = this.POST_ID.concat("_o_real_").concat(Cal.getSerialDate());
        this.TMP_BUFFER.setLength(0);
        this.TMP_BUFFER.append(TRACKING_URL);
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_LIST_TABLE(this.SCHEDULE_INFO.getProperty("LIST_TABLE")));
        this.TMP_BUFFER.append("&");
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_MAIL_ID(this.POST_ID));
        this.TMP_BUFFER.append("&");
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_CLOSE(this.SCHEDULE_INFO.getProperty("CLOSE_DATE")));
        this.TMP_BUFFER.append("&");
        this.instance_TRACKING_URL = this.TMP_BUFFER.toString();
        this.instance_ATTACH_CONTENT_SELECT_QUERY = StringUtil.ConvertString(SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_SELECT_ATTACH_CONTENT"), this.SCHEDULE_INFO, "${", "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String execute_ContentProcess(String source) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("src=>", (Object)source);
        }
        String strip_img_source = MappingImgStripper.process(source);
        if (log.isDebugEnabled()) {
            log.debug("result=>", (Object)source);
        }
        if (this.SCHEDULE_INFO.getProperty("TRACKING_YN", "N").equalsIgnoreCase("Y") && this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H")) {
            StringBuffer tmpBuffer = null;
            try {
                tmpBuffer = new StringBuffer(2048);
                String string = this.execute_ContentTrackingParsing(strip_img_source, tmpBuffer);
                return string;
            }
            finally {
                tmpBuffer = null;
            }
        }
        return strip_img_source;
    }

    @Override
    protected String getMappingHeader() throws Exception {
        return this.SCHEDULE_INFO.getProperty("MAPPINGHEADER", DEFAULT_SINGLE_MAPPING_HEADER);
    }

    protected String execute_ContentTrackingParsing(String source, StringBuffer tmpBuffer) throws Exception {
        LinkContent __LINK_CONTENT__ = null;
        int __LINK_INDEX__ = 0;
        boolean TRACKING_INFO_PROCESS = this.SCHEDULE_INFO.getProperty("CONTENT_INFO_UPDATE_FLAG", "Y").equals("Y");
        if (this.SCHEDULE_INFO.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y")) {
            this.TMP_BUFFER.setLength(0);
            log.debug("Start Link Parsing");
            LinkParser __LINK_PARSER__ = new LinkParser();
            __LINK_PARSER__.parse(source);
            String addedParam = this.SCHEDULE_INFO.getProperty("WEB_TRACKING_FLAG", "N").equals("Y") ? ALPHA2_TRACKING_URL : "";
            Iterator iter = __LINK_PARSER__.iterator();
            while (iter.hasNext()) {
                Object __TMP_CONTENT__ = iter.next();
                if (__TMP_CONTENT__ instanceof LinkContent) {
                    ++__LINK_INDEX__;
                    __LINK_CONTENT__ = (LinkContent)__TMP_CONTENT__;
                    if (__LINK_CONTENT__.getUrl().startsWith("http")) {
                        tmpBuffer.setLength(0);
                        tmpBuffer.append(this.instance_TRACKING_URL);
                        tmpBuffer.append(TrackingInfoConvertor.enc_KIND("C"));
                        tmpBuffer.append("&");
                        tmpBuffer.append(TrackingInfoConvertor.enc_CID(__LINK_CONTENT__.getID()));
                        if (addedParam.length() > 0) {
                            tmpBuffer.append("&WEBTRACK=${FIELD1}${FIELD2}${FIELD3}${FIELD4}");
                        }
                        tmpBuffer.append("&c_id=");
                        tmpBuffer.append(__LINK_CONTENT__.getID());
                        tmpBuffer.append("&URL=");
                        tmpBuffer.append(__LINK_CONTENT__.getUrl());
                        if (this.instance_ADD_URL_STRING != null) {
                            if (__LINK_CONTENT__.getUrl().indexOf("?") > 0) {
                                tmpBuffer.append("&");
                            } else {
                                tmpBuffer.append("?");
                            }
                            tmpBuffer.append(this.instance_ADD_URL_STRING);
                        }
                        this.TMP_BUFFER.append(__LINK_CONTENT__.getLinkConvert(tmpBuffer.toString()));
                        continue;
                    }
                    this.TMP_BUFFER.append(__TMP_CONTENT__.toString());
                    iter.remove();
                    continue;
                }
                this.TMP_BUFFER.append(__TMP_CONTENT__.toString());
                iter.remove();
            }
            source = this.TMP_BUFFER.toString();
            if (TRACKING_INFO_PROCESS) {
                log.debug("Delete Current Link Info");
                this.deleteTrackingInfo();
                log.debug("Insert Parsed Link Info");
                this.StroreTrackingInfoToDB(__LINK_PARSER__);
            } else {
                log.debug("Skip Parsed Link Info");
            }
            log.debug("End Link Parsing");
        }
        if (source.indexOf("${map_link}") > -1) {
            log.info("[WEB RESEARCH START!!!!!!!!!!!]");
            WebPollModifier __WEB_POLL_MODIFIER__ = new WebPollModifier(this.SCHEDULE_INFO);
            WebResearchModifier __WEB_RESEARCH_MODIFIER__ = new WebResearchModifier(this.SCHEDULE_INFO);
            if (__WEB_POLL_MODIFIER__.process(source, __LINK_INDEX__++)) {
                source = __WEB_POLL_MODIFIER__.getModify();
            }
            log.info("[WEB RESEARCH END!!!!!!!!!!!]");
        } else {
            ResearchModifier __RESEARCH_MODIFIER__ = new ResearchModifier(this.SCHEDULE_INFO);
            if (__RESEARCH_MODIFIER__.process(source, __LINK_INDEX__++)) {
                if (TRACKING_INFO_PROCESS) {
                    log.debug("Research data DB update");
                    this.setResearchInfo(__RESEARCH_MODIFIER__);
                } else {
                    log.debug("JOB_STATUS : " + this.SCHEDULE_INFO.getProperty("JOB_STATUS", "35"));
                    log.debug("SO DB INSERT SKIP ");
                }
                source = __RESEARCH_MODIFIER__.getModify();
            }
        }
        log.debug("Research Parsing [END]");
        this.TMP_BUFFER.setLength(0);
        String addedInclude = this.SCHEDULE_INFO.getProperty("WEB_TRACKING_INCLUDE", "");
        this.TMP_BUFFER.append(addedInclude);
        this.TMP_BUFFER.append(source);
        int __BODY_INDEX__ = source.toLowerCase().indexOf("</body");
        __BODY_INDEX__ += addedInclude.length();
        if (this.SCHEDULE_INFO.getProperty("DUR_YN", "N").equalsIgnoreCase("Y")) {
            tmpBuffer.setLength(0);
            tmpBuffer.append("\r\n<iframe src=\"");
            tmpBuffer.append(this.instance_TRACKING_URL);
            tmpBuffer.append(TrackingInfoConvertor.enc_KIND("D"));
            tmpBuffer.append("\" frameborder=\"0\" width=\"1\" height=\"1\"></iframe>\r\n");
            if (__BODY_INDEX__ > 0) {
                this.TMP_BUFFER.insert(__BODY_INDEX__, tmpBuffer.toString());
            } else {
                this.TMP_BUFFER.append(tmpBuffer.toString());
            }
        }
        if (this.SCHEDULE_INFO.getProperty("OPEN_YN", "N").equalsIgnoreCase("Y")) {
            tmpBuffer.setLength(0);
            tmpBuffer.append("<div style=\"display:none\">");
            tmpBuffer.append("<img src=\"");
            tmpBuffer.append(this.instance_TRACKING_URL);
            tmpBuffer.append(TrackingInfoConvertor.enc_KIND("O"));
            tmpBuffer.append("\" width=1 height=1>");
            tmpBuffer.append("</div>");
            if (__BODY_INDEX__ > 0) {
                this.TMP_BUFFER.insert(__BODY_INDEX__, tmpBuffer.toString());
            } else {
                this.TMP_BUFFER.append(tmpBuffer.toString());
            }
        }
        return this.TMP_BUFFER.toString();
    }

    protected void StroreTrackingInfoToDB(List __LINK_INFOS__) throws Exception {
        this.refreshDBConnection();
        eMsPreparedStatement __PS_INSERT_LINKINFO__ = null;
        eMsPreparedStatement __PS_UPDATE_LINKINFO__ = null;
        Exception ex = null;
        try {
            __PS_INSERT_LINKINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_LINKINFO, "${", "}");
            __PS_UPDATE_LINKINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_UPDATE_LINKINFO, "${", "}");
            LinkContent __LINK_CONTENT__2 = null;
            String __TMP_CONTENT__ = null;
            Properties __LINK_UPDATE_PROPERTIES__ = new Properties();
            String __GUME_ID_BUFFER_ECPID__ = "";
            String __GUME_ID_BUFFER_HI_PRDID__ = "";
            String __GUME_ID_BUFFER_PLANSEQ__ = "";
            __LINK_UPDATE_PROPERTIES__.putAll((Map<?, ?>)this.SCHEDULE_INFO);
            for (LinkContent __LINK_CONTENT__2 : __LINK_INFOS__) {
                __TMP_CONTENT__ = __LINK_CONTENT__2.getContent();
                if (__TMP_CONTENT__.length() > eMsLocale.LINK_LENGTH_LIMIT) {
                    __TMP_CONTENT__ = __TMP_CONTENT__.substring(0, eMsLocale.LINK_LENGTH_LIMIT);
                }
                __LINK_UPDATE_PROPERTIES__.setProperty("CLICK_ID", __LINK_CONTENT__2.getID());
                __LINK_UPDATE_PROPERTIES__.setProperty("CLICK_DESC", __TMP_CONTENT__);
                __LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL", __LINK_CONTENT__2.getUrl());
                String Gume_id_value_eshop = null;
                String Gume_id_value_estore = null;
                String Gume_id_value_plan = null;
                String Url = null;
                boolean Url_lenght = false;
                int Gume_length = 0;
                Gume_id_value_eshop = eMsSystem.getProperty("gume.click.delimiter1");
                Gume_id_value_estore = eMsSystem.getProperty("gume.click.delimiter2");
                Gume_id_value_plan = eMsSystem.getProperty("gume.click.delimiter3");
                Url = __LINK_CONTENT__2.getUrl();
                if (Url.indexOf(Gume_id_value_eshop) > 0 || Url.indexOf(Gume_id_value_estore) > 0 || Url.indexOf(Gume_id_value_plan) > 0) {
                    if (Url.indexOf(Gume_id_value_eshop) > 0) {
                        __LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "true");
                        Gume_length = Url.indexOf(Gume_id_value_eshop) + Gume_id_value_eshop.length() + 1;
                        __GUME_ID_BUFFER_ECPID__ = Url.indexOf("&") > 0 && Url.indexOf(Gume_id_value_eshop) < Url.indexOf("&") ? __GUME_ID_BUFFER_ECPID__ + "|" + Url.substring(Gume_length, Url.indexOf("&")) + "|" : __GUME_ID_BUFFER_ECPID__ + "|" + Url.substring(Gume_length) + "|";
                    } else if (Url.indexOf(Gume_id_value_estore) > 0) {
                        __LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "true");
                        __GUME_ID_BUFFER_HI_PRDID__ = Url.indexOf("&") > 0 && Url.indexOf(Gume_id_value_estore) < Url.indexOf("&") ? __GUME_ID_BUFFER_HI_PRDID__ + "|" + Url.substring(Gume_length, Url.indexOf("&")) + "|" : __GUME_ID_BUFFER_HI_PRDID__ + "|" + Url.substring(Gume_length) + "|";
                    } else if (Url.indexOf(Gume_id_value_plan) > 0) {
                        __LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "planseq");
                        Gume_length = Url.indexOf(Gume_id_value_plan) + Gume_id_value_plan.length() + 1;
                        __GUME_ID_BUFFER_PLANSEQ__ = Url.indexOf("&") > 0 && Url.indexOf(Gume_id_value_plan) < Url.indexOf("&") ? __GUME_ID_BUFFER_PLANSEQ__ + "|" + Url.substring(Gume_length, Url.indexOf("&")) + "|" : __GUME_ID_BUFFER_PLANSEQ__ + "|" + Url.substring(Gume_length) + "|";
                    }
                } else {
                    __LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL_GUME_YN", "false");
                }
                try {
                    __PS_INSERT_LINKINFO__.executeUpdate(__LINK_UPDATE_PROPERTIES__);
                }
                catch (SQLException e) {
                    log.error(this.getName(), (Throwable)e);
                }
            }
            __LINK_UPDATE_PROPERTIES__.setProperty("GUME_ID_ECPID", __GUME_ID_BUFFER_ECPID__);
            __LINK_UPDATE_PROPERTIES__.setProperty("GUME_ID_HI_PRDID", __GUME_ID_BUFFER_HI_PRDID__);
            __LINK_UPDATE_PROPERTIES__.setProperty("GUME_ID_PLANSEQ", __GUME_ID_BUFFER_PLANSEQ__);
            try {
                __PS_UPDATE_LINKINFO__.executeUpdate(__LINK_UPDATE_PROPERTIES__);
            }
            catch (SQLException e) {
                log.info(this.getName(), (Throwable)e);
            }
        }
        catch (Throwable e) {
            log.error(this.getName(), e);
            ex = new Exception(e.toString());
            throw ex;
        }
        finally {
            try {
                __PS_INSERT_LINKINFO__.close();
                __PS_UPDATE_LINKINFO__.close();
            }
            catch (Exception __LINK_CONTENT__2) {}
        }
    }

    protected void deleteTrackingInfo() throws Exception {
        this.refreshDBConnection();
        eMsStatement stmt = null;
        try {
            stmt = this.EMS_CONNECTION.createStatement();
            this.TMP_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_BUFFER, QUERY_DELETE_TRACKING_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
            stmt.executeUpdate(this.TMP_BUFFER.toString());
        }
        finally {
            this.EMS_CONNECTION.recycleStatement(stmt);
        }
    }

    protected void setResearchInfo(List __RESEARCH_MODIFIER__) throws Exception {
        this.refreshDBConnection();
        eMsPreparedStatement __PS_INSERT_REINFO__ = null;
        eMsStatement stmt = null;
        try {
            stmt = this.EMS_CONNECTION.createStatement();
            stmt.executeUpdate(QUERY_UPDATE_RESEARCH_CONTENT_PATTERN, this.SCHEDULE_INFO, "${", "}");
            __PS_INSERT_REINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_RESEARCH_INFO, "${", "}");
            Properties __RESEARCH_PROPERTIES__ = new Properties();
            __RESEARCH_PROPERTIES__.putAll((Map<?, ?>)this.SCHEDULE_INFO);
            for (ResearchMetaData tmp : __RESEARCH_MODIFIER__) {
                __RESEARCH_PROPERTIES__.setProperty("CLICK_ID", tmp.getClickId());
                __RESEARCH_PROPERTIES__.setProperty("CLICK_DESC", tmp.getDesc());
                __RESEARCH_PROPERTIES__.setProperty("Q_NO", tmp.getName());
                __RESEARCH_PROPERTIES__.setProperty("ANSWER_B", tmp.getValue());
                __RESEARCH_PROPERTIES__.setProperty("Q_TYPE", tmp.getType());
                __PS_INSERT_REINFO__.executeUpdate(__RESEARCH_PROPERTIES__);
            }
        }
        catch (Throwable e) {
            throw new Exception(e.toString());
        }
        finally {
            this.EMS_CONNECTION.recycleStatement(stmt);
            try {
                if (__PS_INSERT_REINFO__ != null) {
                    __PS_INSERT_REINFO__.close();
                }
            }
            catch (Exception __RESEARCH_PROPERTIES__) {}
        }
    }

    protected void setWebResearchInfo(List __RESEARCH_MODIFIER__) throws Exception {
        this.refreshDBConnection();
        eMsPreparedStatement __PS_INSERT_REINFO__ = null;
        eMsStatement stmt = null;
        try {
            stmt = this.EMS_CONNECTION.createStatement();
            stmt.executeUpdate(QUERY_UPDATE_RESEARCH_CONTENT_PATTERN, this.SCHEDULE_INFO, "${", "}");
            __PS_INSERT_REINFO__ = this.EMS_CONNECTION.prepareStatement(QUERY_INSERT_RESEARCH_INFO, "${", "}");
            Properties __RESEARCH_PROPERTIES__ = new Properties();
            __RESEARCH_PROPERTIES__.putAll((Map<?, ?>)this.SCHEDULE_INFO);
            for (WebResearchMetaData tmp : __RESEARCH_MODIFIER__) {
                __RESEARCH_PROPERTIES__.setProperty("CLICK_ID", tmp.getClickId());
                __RESEARCH_PROPERTIES__.setProperty("CLICK_DESC", tmp.getDesc());
                __RESEARCH_PROPERTIES__.setProperty("Q_NO", tmp.getName());
                __RESEARCH_PROPERTIES__.setProperty("ANSWER_B", tmp.getValue());
                __RESEARCH_PROPERTIES__.setProperty("Q_TYPE", tmp.getType());
                __PS_INSERT_REINFO__.executeUpdate(__RESEARCH_PROPERTIES__);
            }
        }
        catch (Throwable e) {
            throw new Exception(e.toString());
        }
        finally {
            this.EMS_CONNECTION.recycleStatement(stmt);
            try {
                if (__PS_INSERT_REINFO__ != null) {
                    __PS_INSERT_REINFO__.close();
                }
            }
            catch (Exception __RESEARCH_PROPERTIES__) {}
        }
    }

    static {
        try {
            QUERY_INSERT_LINKINFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_INSERT_LINKINFO");
            QUERY_UPDATE_LINKINFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_UPDATE_LINKINFO");
            QUERY_INSERT_RESEARCH_INFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_INSERT_RESEARCH_INFO");
            QUERY_UPDATE_RESEARCH_CONTENT_PATTERN = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_UPDATE_RESEARCH_CONTENT_PATTERN");
            QUERY_DELETE_TRACKING_INFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_DELETE_TRACKING_INFO");
            QUERY_SELECT_POLLHTML_INFO = SqlManager.getQuery("WINDFORCE_TR_INFO_PROCESS", "QUERY_SELECT_POLLHTML_INFO");
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
        DEFAULT_SINGLE_MAPPING_HEADER = eMsSystem.getProperty("default.single.mapping.header");
        TRACKING_URL = eMsSystem.getProperty("tracking.url").concat("?${enc_mid}&${enc_s_type}&p_id=${real_p_id}&m_id=${m_id}&s_tp=${s_type}&");
        ALPHA2_TRACKING_URL = eMsSystem.getProperty("alpha2.tracking.url");
    }
}

