/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.mass.research;

import java.util.Properties;
import java.util.Vector;
import mercury.contents.mass.research.AnsProperty;
import mercury.contents.mass.research.FormTokenizer;
import mercury.contents.mass.research.ResearchMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.util.StringConvertUtil;

public class ResearchModifier
extends Vector {
    private static final Logger log = LoggerFactory.getLogger(ResearchModifier.class);
    public static String RESEARCH_FORM_START = null;
    public static String RESEARCH_SUBMIT_BUTTON = null;
    private String body = null;
    private int link_index = 0;
    FormTokenizer myFormTokenizer = new FormTokenizer();
    private String PARSED_RESULT_STRING = null;
    protected Properties SCHEDULE_INFO = null;

    public ResearchModifier() throws Exception {
    }

    public ResearchModifier(Properties prop) throws Exception {
        this.SCHEDULE_INFO = prop;
    }

    public String getModify() {
        return this.PARSED_RESULT_STRING;
    }

    public boolean process(String content, int idx) {
        this.body = content;
        this.link_index = idx + 1;
        String source = this.body.toLowerCase();
        if (source.indexOf("${map_re}") < 0) {
            return false;
        }
        if (source.indexOf("<form") < 0) {
            this.body = this.addForm(this.body);
            source = this.body.toLowerCase();
        }
        int idx1 = 0;
        int idx2 = 0;
        int idxSF = 0;
        int idxEF = 0;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            while ((idx1 = source.indexOf("<form", idx2)) >= 0) {
                buffer.append(this.body.substring(idx2, idx1));
                idxSF = source.indexOf(">", idx1);
                if (idxSF < 0) break;
                ++idxSF;
                idxEF = source.indexOf("</form", idx1);
                if (idxEF < 0 || (idx2 = source.indexOf(">", idxEF)) < 0) break;
                if (source.substring(idx1, ++idx2).indexOf("${map_re}") > 0) {
                    try {
                        buffer.append(this.convertForm(this.body.substring(idxSF, idxEF)));
                    }
                    catch (Exception e) {
                        log.error("Exception", (Throwable)e);
                        buffer.append(this.body.substring(idx1, idx2));
                    }
                    continue;
                }
                buffer.append(this.body.substring(idx1, idx2));
            }
            if (idx1 < 0) {
                buffer.append(this.body.substring(idx2));
            }
            if (idx2 < 0) {
                buffer.append(this.body.substring(idx1));
            }
            this.PARSED_RESULT_STRING = buffer.toString();
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
        return true;
    }

    protected String convertForm(String src) throws Exception {
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, RESEARCH_FORM_START, this.SCHEDULE_INFO, "${", "}", false, true);
            buffer.append("\r\n");
            buffer.append("<input type=\"hidden\" name=\"emsinfo_");
            buffer.append(String.valueOf(this.link_index++));
            buffer.append("\" value=\"-1\">\r\n");
            this.myFormTokenizer.process(src);
            for (int i = 0; i < this.myFormTokenizer.size(); ++i) {
                AnsProperty oneAp = (AnsProperty)this.myFormTokenizer.elementAt(i);
                String name = oneAp.getNAME();
                short type = oneAp.getTYPE();
                Vector values = oneAp.getVALUE();
                for (int j = 0; j < values.size(); ++j) {
                    String typeStr = null;
                    switch (type) {
                        case 5: {
                            typeStr = "SELECT";
                            break;
                        }
                        case 1: {
                            typeStr = "TEXT";
                            break;
                        }
                        case 4: {
                            typeStr = "RADIO BOX";
                            break;
                        }
                        case 3: {
                            typeStr = "CHECK BOX";
                            break;
                        }
                        case 2: {
                            typeStr = "TEXT AREA";
                            break;
                        }
                        default: {
                            typeStr = "Unknown";
                        }
                    }
                    String oneValue = (String)values.elementAt(j);
                    String tempValue = type + "_" + name + "_" + oneValue;
                    String desc = name + "(" + oneValue + ") : " + typeStr;
                    String tempName = "emsinfo_" + this.link_index;
                    this.addElement(new ResearchMetaData(this.link_index, desc, name, oneValue, type));
                    if (log.isDebugEnabled()) {
                        log.debug("Debug: " + desc);
                    }
                    buffer.append("<input type=\"hidden\" name=\"");
                    buffer.append(tempName);
                    buffer.append("\" value=\"");
                    buffer.append(tempValue);
                    buffer.append("\">\r\n");
                    ++this.link_index;
                }
            }
            buffer.append(src);
            buffer.append("\r\n</form>");
            String i = buffer.toString().replaceAll("\\$\\{map_re\\}", RESEARCH_SUBMIT_BUTTON);
            return i;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addForm(String source) {
        String src = source.toLowerCase();
        int idx1 = src.indexOf("<body");
        if (idx1 < 0) {
            return src;
        }
        int idx2 = src.indexOf(">", idx1);
        if (idx2 < 0) {
            return src;
        }
        int insert_start_point = idx2 + 1;
        idx1 = src.indexOf("</body", insert_start_point);
        if (idx1 < 0) {
            return src;
        }
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(1024);
            buffer.setLength(0);
            buffer.append(source);
            buffer.insert(idx1, "</form>");
            buffer.insert(insert_start_point, "<form>");
            String string = buffer.toString();
            return string;
        }
        finally {
            buffer = null;
        }
    }

    static {
        RESEARCH_FORM_START = eMsSystem.getProperty("ems.research.tag", "defaultadd");
        RESEARCH_SUBMIT_BUTTON = eMsSystem.getProperty("ems.submit.button", "submit button");
    }
}

