/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.mass.research;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Vector;
import mercury.contents.mass.research.AnsProperty;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.util.StringUtil;

public class FormTokenizer
extends Vector {
    private static final String TAG_START = "<";
    private static final String TAG_END = ">";
    protected static ByteArrayOutputStream INNER_BUFFER = new ByteArrayOutputStream(1024);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File src) throws Exception {
        String body = null;
        ByteArrayOutputStream byteArrayOutputStream = INNER_BUFFER;
        synchronized (byteArrayOutputStream) {
            INNER_BUFFER.reset();
            FileElement.putFileBody(src, INNER_BUFFER);
            body = INNER_BUFFER.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
        }
        this.process(body);
    }

    public void process(String src) {
        this.clear();
        String source = src.toLowerCase();
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        String tag = null;
        while ((idx1 = source.indexOf(TAG_START, idx2)) >= 0 && (idx2 = source.indexOf(TAG_END, idx1)) >= 0) {
            if ((tag = source.substring(idx1, ++idx2)).startsWith("<select ")) {
                idx3 = source.indexOf("/select>", idx2);
                if (idx3 < 0) continue;
                idx2 = idx3 + 8;
                this.parseSelect(src.substring(idx1, idx2));
                continue;
            }
            if (tag.startsWith("<input ")) {
                this.parseInput(src.substring(idx1, idx2));
                continue;
            }
            if (!tag.startsWith("<textarea ") || (idx3 = source.indexOf("/textarea>", idx2)) < 0) continue;
            idx2 = idx3 + 10;
            this.parseTextArea(source.substring(idx1, idx2));
        }
    }

    private void parseSelect(String src) {
        String source = src.toLowerCase();
        int idx3 = 0;
        int idx1 = 0;
        int idx2 = source.indexOf(TAG_END);
        if (idx2 < 0) {
            return;
        }
        String tag = src.substring(0, idx2 + 1);
        String name = StringUtil.getAttribute(tag, "name");
        String tmpValue = null;
        Vector<String> listValue = new Vector<String>();
        while ((idx1 = source.indexOf("<option", idx2)) >= 0 && (idx2 = source.indexOf(TAG_END, idx1)) >= 0) {
            if ((tmpValue = StringUtil.getAttribute(src.substring(idx1, ++idx2), "value")) == null || tmpValue.length() == 0) {
                idx3 = source.indexOf("</option", idx2);
                if (idx3 < 0) continue;
                tmpValue = src.substring(idx2, idx3);
            }
            listValue.addElement(tmpValue);
        }
        AnsProperty ans = new AnsProperty();
        ans.setNAME(name);
        ans.setTYPE((short)5);
        ans.setVALUE(listValue);
        this.addElement(ans);
    }

    private void parseInput(String tag) {
        String type = StringUtil.getAttribute(tag, "type");
        String name = StringUtil.getAttribute(tag, "name");
        if (type == null || type.equals("")) {
            type = "text";
        }
        if ((type = type.toLowerCase()).equals("text")) {
            AnsProperty ans = new AnsProperty();
            ans.setNAME(name);
            ans.setTYPE((short)1);
            this.addElement(ans);
            return;
        }
        if (type.equals("radio")) {
            String value = StringUtil.getAttribute(tag, "value");
            for (int i = 0; i < this.size(); ++i) {
                AnsProperty tempap = (AnsProperty)this.elementAt(i);
                if (!tempap.getNAME().equals(name) || tempap.getTYPE() != 4) continue;
                tempap.addVALUE(value);
                return;
            }
            AnsProperty oneap = new AnsProperty();
            oneap.setNAME(name);
            oneap.setTYPE((short)4);
            oneap.addVALUE(value);
            this.addElement(oneap);
            return;
        }
        if (type.equals("checkbox")) {
            String value = StringUtil.getAttribute(tag, "value");
            for (int i = 0; i < this.size(); ++i) {
                AnsProperty tempap = (AnsProperty)this.elementAt(i);
                if (!tempap.getNAME().equals(name) || tempap.getTYPE() != 3) continue;
                tempap.addVALUE(value);
                return;
            }
            AnsProperty oneap = new AnsProperty();
            oneap.setNAME(name);
            oneap.setTYPE((short)3);
            oneap.addVALUE(value);
            this.addElement(oneap);
        }
    }

    private void parseTextArea(String tag) {
        String name = StringUtil.getAttribute(tag, "name");
        if (name == null || name.length() == 0) {
            return;
        }
        AnsProperty oneap = new AnsProperty();
        oneap.setNAME(name);
        oneap.setTYPE((short)2);
        this.addElement(oneap);
    }
}

