/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.parser;

import freemarker20.template.SimpleHash;
import freemarker20.template.Template;
import freemarker20.template.TemplateModelRoot;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import mercury.contents.common.parser.SimpleBodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsStringWriter;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;

public class FreemarkerBodyParser
extends SimpleBodyParser {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerBodyParser.class);
    protected Template body = null;
    protected PrintWriter writerContentComposer = null;
    protected eMsStringWriter writerStringBuffer = new eMsStringWriter();

    public FreemarkerBodyParser() throws Exception {
        this.writerContentComposer = new PrintWriter(this.writerStringBuffer);
    }

    @Override
    public synchronized void setContents(String src) throws Exception {
        this.origin = src;
        FileElement fe = null;
        eMsByteArrayOutputStream INNER_BYTE_ARRAY_STREAM = null;
        try {
            INNER_BYTE_ARRAY_STREAM = eMsByteArrayOutputStream.getInstance();
            INNER_BYTE_ARRAY_STREAM.reset();
            fe = FileElement.getFileElement(src);
            fe.putStream(INNER_BYTE_ARRAY_STREAM);
            this.contents = INNER_BYTE_ARRAY_STREAM.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
            if (log.isDebugEnabled()) {
                log.debug("read template", (Object)this.contents);
            }
            this.setName(fe.getName());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fe != null) {
                fe.close();
            }
            eMsByteArrayOutputStream.recycleInstance(INNER_BYTE_ARRAY_STREAM);
        }
        this.body = new Template();
        this.body.compileFromString(this.contents);
    }

    @Override
    public void setContents(String original, String contents, String name) throws Exception {
        this.origin = original;
        this.contents = contents;
        this.setName(name);
        if (log.isDebugEnabled()) {
            log.debug("recover template", (Object)this.contents);
        }
        this.body = new Template();
        this.body.compileFromString(this.contents);
    }

    @Override
    public synchronized String convert(Object info1, Object info2, Properties prop) throws Exception {
        SimpleHash map = null;
        if (info1 instanceof Map) {
            map = FreemarkerBodyParser.ConvertMapToSimpleHash((Map)info1);
        } else if (info1 instanceof SimpleHash) {
            map = (SimpleHash)info1;
        } else {
            throw new RuntimeException(" INVALID MAPPING OBJECT ");
        }
        String returnValue = null;
        if (prop != null) {
            map.putMissedElement((Map)prop);
        }
        this.writerContentComposer.flush();
        this.writerStringBuffer.reset();
        this.body.process((TemplateModelRoot)map, this.writerContentComposer);
        this.writerContentComposer.flush();
        returnValue = this.writerStringBuffer.toString();
        StringBuffer buffer = this.writerStringBuffer.getBuffer();
        if (info2 != null) {
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, returnValue, info2, "@{", "}", info1, "${", "}", false, false);
            returnValue = buffer.toString();
        }
        return returnValue;
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.writerStringBuffer != null) {
            this.writerStringBuffer.close();
            this.writerStringBuffer = null;
        }
    }

    protected static SimpleHash ConvertMapToSimpleHash(Map src) {
        SimpleHash returnValue = new SimpleHash();
        Iterator ENUM = src.keySet().iterator();
        Object key = null;
        while (ENUM.hasNext()) {
            key = ENUM.next();
            returnValue.put((String)key, (String)src.get(key));
        }
        return returnValue;
    }
}

