/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.body;

import freemarker20.template.SimpleHash;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.convert.BASE64;
import pluto.util.convert.MimeConvertor;
import pluto.util.convert.TrackingInfoConvertor;

public class SmsSimpleMailBody
implements MailBody {
    private static final Logger log = LoggerFactory.getLogger(SmsSimpleMailBody.class);
    protected static final byte[] NEW_LINE = "\r\n".getBytes();
    protected Vector myMessages = new Vector();
    protected Properties ETC_HEADER = null;
    protected String SUBJECT = null;
    protected String FROM_NAME = null;
    protected String FROM_EMAIL = null;
    protected String TO_NAME = null;
    protected String TO_EMAIL = null;
    protected String ETC_HEADER_STRING = null;
    protected String HeaderString = null;
    protected String Body = null;
    protected int BODY_TYPE = 2;
    protected ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);

    @Override
    public synchronized void setEtcHeader(Properties prop) throws Exception {
        this.ETC_HEADER = prop;
        Enumeration<?> keys = this.ETC_HEADER.propertyNames();
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);
        String key = null;
        String value = null;
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (!key.startsWith("X-")) continue;
            value = this.ETC_HEADER.getProperty(key);
            byteBuffer.write(key.getBytes(eMsLocale.CHAR_SET));
            byteBuffer.write(": ".getBytes());
            byteBuffer.write(value.getBytes(eMsLocale.CHAR_SET));
            byteBuffer.write(NEW_LINE);
        }
        keys = this.ETC_HEADER.propertyNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            if (key.startsWith("X-")) continue;
            value = this.ETC_HEADER.getProperty(key);
            byteBuffer.write(key.getBytes(eMsLocale.CHAR_SET));
            byteBuffer.write(": ".getBytes());
            byteBuffer.write(value.getBytes(eMsLocale.CHAR_SET));
            byteBuffer.write(NEW_LINE);
        }
        this.ETC_HEADER_STRING = byteBuffer.toString();
    }

    @Override
    public synchronized Properties getEtcHeader() {
        return this.ETC_HEADER;
    }

    @Override
    public void setSubject(String Subject) {
        this.SUBJECT = Subject;
    }

    @Override
    public String getSubject() {
        return this.SUBJECT;
    }

    @Override
    public void setFromName(String from_name) {
        this.FROM_NAME = from_name;
    }

    @Override
    public String getFromName() {
        return this.FROM_NAME;
    }

    @Override
    public void setFromEmail(String from_email) {
        this.FROM_EMAIL = from_email;
    }

    @Override
    public String getFromEmail() {
        return this.FROM_EMAIL;
    }

    @Override
    public void setToName(String to_name) {
        this.TO_NAME = to_name;
    }

    @Override
    public String getToName() {
        return this.TO_NAME;
    }

    @Override
    public void setToEmail(String to_email) {
        this.TO_EMAIL = to_email;
    }

    @Override
    public String getToEmail() {
        return this.TO_EMAIL;
    }

    @Override
    public void setMessage(Message msg) {
        this.myMessages.addElement(msg);
        this.BODY_TYPE = this.myMessages.size() > 1 ? 1 : 2;
    }

    @Override
    public Vector getMessage() {
        return this.myMessages;
    }

    @Override
    public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(512);
        String returnStr = "";
        String subject = this.SUBJECT;
        StringBuffer buffer = new StringBuffer(128);
        try {
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, subject, info1, "${", "}", false, false);
            subject = buffer.toString();
            if (log.isDebugEnabled()) {
                log.debug("subject", (Object)subject);
            }
            ((Message)this.myMessages.get(0)).putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
            returnStr = byteBuffer.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            byteBuffer.close();
            byteBuffer = null;
        }
        return returnStr;
    }

    protected void setHeaderString(Object info1, Object info2, Properties prop, ByteArrayOutputStream tmpOutStream) throws Exception {
        Map INFO_MAP1 = null;
        String mail_id = null;
        String tbl_id = null;
        Object member_id = null;
        Object send_type = null;
        boolean HEADER_ENCODE = prop.getProperty("HEADER_ENCODE", "none").equals("none") ? eMsLocale.HEADER_ENCODE : prop.getProperty("HEADER_ENCODE").equals("true");
        String HEADER_BASE_CHAR_SET = prop.getProperty("HEADER_BASE_CHAR_SET", eMsLocale.HEADER_BASE_CHAR_SET);
        String HEADER_MIME_CHAR_SET = prop.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
        if (info1 != null) {
            if (info1 instanceof Map) {
                INFO_MAP1 = (Map)info1;
            } else if (info1 instanceof SimpleHash) {
                INFO_MAP1 = ((SimpleHash)info1).getAsHashmap();
            } else {
                throw new RuntimeException("UNSUPPORTED HASH TYPE");
            }
            mail_id = prop.getProperty("POST_ID");
            mail_id = mail_id == null ? null : TrackingInfoConvertor.enc_MAIL_ID(mail_id.toString());
            tbl_id = prop.getProperty("LIST_TABLE");
            tbl_id = tbl_id == null ? null : TrackingInfoConvertor.enc_LIST_TABLE(tbl_id.toString());
            member_id = INFO_MAP1.get("enc_mid");
            send_type = INFO_MAP1.get("enc_s_type");
        }
        String from_name = this.FROM_NAME;
        String from_email = this.FROM_EMAIL;
        String to_name = this.TO_NAME;
        String to_email = this.TO_EMAIL;
        String subject = this.SUBJECT;
        String TEST_ATTACH_HEADER = prop.getProperty("TEST_ATTACH_HEADER");
        if (TEST_ATTACH_HEADER != null) {
            subject = this.SUBJECT.concat(TEST_ATTACH_HEADER);
        }
        String etc_header_string = this.ETC_HEADER_STRING;
        StringBuffer buffer = new StringBuffer(128);
        if (info1 != null) {
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, from_name, info1, "${", "}", false, false);
            from_name = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, from_email, info1, "${", "}", false, false);
            from_email = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, to_name, info1, "${", "}", false, false);
            to_name = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, to_email, info1, "${", "}", false, false);
            to_email = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, subject, info1, "${", "}", false, false);
            subject = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, etc_header_string, info1, "${", "}", false, false);
            etc_header_string = buffer.toString();
        }
        if (info2 != null) {
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, from_name, info2, "@{", "}", false, false);
            from_name = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, from_email, info2, "@{", "}", false, false);
            from_email = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, to_name, info2, "@{", "}", false, false);
            to_name = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, to_email, info2, "@{", "}", false, false);
            to_email = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, subject, info2, "@{", "}", false, false);
            subject = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, etc_header_string, info2, "@{", "}", false, false);
            etc_header_string = buffer.toString();
        }
        tmpOutStream.write("From: \"".getBytes(HEADER_BASE_CHAR_SET));
        if (HEADER_ENCODE) {
            MimeConvertor.putHeaderToStream(tmpOutStream, from_name, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, (short)1);
        } else {
            tmpOutStream.write(from_name.getBytes(HEADER_BASE_CHAR_SET));
        }
        tmpOutStream.write("\" <".getBytes());
        tmpOutStream.write(from_email.getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        tmpOutStream.write("To: \"".getBytes());
        if (HEADER_ENCODE) {
            MimeConvertor.putHeaderToStream(tmpOutStream, to_name, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, (short)1);
        } else {
            tmpOutStream.write(to_name.getBytes(HEADER_BASE_CHAR_SET));
        }
        tmpOutStream.write("\" <".getBytes());
        tmpOutStream.write(to_email.getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        tmpOutStream.write("Reply-to: <".getBytes());
        tmpOutStream.write(prop.getProperty("REPLY_TO", from_email).getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        tmpOutStream.write("Subject: ".getBytes(HEADER_BASE_CHAR_SET));
        MimeConvertor.putSubjectToStream(tmpOutStream, subject, HEADER_BASE_CHAR_SET, HEADER_MIME_CHAR_SET, HEADER_ENCODE);
        tmpOutStream.write("\r\n".getBytes());
        tmpOutStream.write("Date: ".getBytes());
        tmpOutStream.write(Cal.getHeaderDate().getBytes());
        tmpOutStream.write("\r\n".getBytes());
        tmpOutStream.write("X-WORKER_ID: <".getBytes());
        tmpOutStream.write(Thread.currentThread().getName().getBytes());
        tmpOutStream.write(">\r\n".getBytes());
        if (mail_id != null) {
            tmpOutStream.write("X-MAIL_ID: <".getBytes());
            tmpOutStream.write(mail_id.toString().getBytes());
            tmpOutStream.write(">\r\n".getBytes());
        }
        if (member_id != null) {
            tmpOutStream.write("X-MEMBER_ID: <".getBytes());
            tmpOutStream.write(member_id.toString().getBytes(HEADER_BASE_CHAR_SET));
            tmpOutStream.write(">\r\n".getBytes());
        }
        if (send_type != null) {
            tmpOutStream.write("X-SEND_TYPE: <".getBytes());
            tmpOutStream.write(send_type.toString().getBytes());
            tmpOutStream.write(">\r\n".getBytes());
        }
        if (tbl_id != null) {
            tmpOutStream.write("X-LIST_TABLE: <".getBytes());
            tmpOutStream.write(tbl_id.toString().getBytes());
            tmpOutStream.write(">\r\n".getBytes());
        }
        tmpOutStream.write(etc_header_string.getBytes());
    }

    protected String getBoundaryString() {
        return "_nextpart_" + Cal.getBoundaryDate() + "." + System.currentTimeMillis();
    }

    @Override
    public String getPreViewMailBody(Object info1, Object info2, Properties prop) throws Exception {
        String content = ((Message)this.myMessages.get(0)).getStringMessage(info1, info2, null);
        return BASE64.encode(content);
    }

    @Override
    public String getSpoolPrev(Object info1, Object info2, Properties prop) throws Exception {
        String content = ((Message)this.myMessages.get(0)).getStringMessage(info1, info2, null);
        return content;
    }

    protected void finalize() throws Throwable {
    }
}

