/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.body;

import freemarker20.template.SimpleHash;
import java.io.ByteArrayOutputStream;
import java.util.Properties;
import mercury.contents.common.body.SimpleMailBody;
import mercury.contents.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.convert.MimeConvertor;

public abstract class SecureMailBody
extends SimpleMailBody {
    private static final Logger log = LoggerFactory.getLogger(SecureMailBody.class);
    protected static boolean DEFAULT_ATTACH = false;
    protected static String SECURE_INTRO_TEMPLATE = null;
    protected static String EXCEPT_DOMAIN = null;
    protected static String SECURE_ATTACH_FILE_NAME = null;
    protected String REAL_ATTACH_TEMPLATE = null;
    protected String NO_SECURE_INTRO_TEMPLATE = null;
    protected static boolean NON_SECURE_ATTACH_FLAG = false;
    public static String CONTENTS_BASE_URL = null;
    public static String NO_ATTACH_INTRO = "/samsunglife/intro/intro_no_secure.html";

    protected abstract String getSecureMailBody(Object var1, Object var2, Properties var3) throws Exception;

    protected String getOriginalMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        return super.getMailBody(info1, info2, SCHEDULE_INFO);
    }

    protected String getNoSecureBodyNBase(Object info1, Object info2, Properties SCHEDULE_INFO) {
        String body_string = "";
        return body_string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        SimpleHash __INFO1__ = (SimpleHash)info1;
        String body_string = this.getSecureMailBody(info1, info2, SCHEDULE_INFO);
        if (body_string == null) {
            return super.getMailBody(info1, info2, SCHEDULE_INFO);
        }
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(2048);
        StringBuffer buffer = new StringBuffer(2048);
        String returnStr = "";
        try {
            eMsByteArrayOutputStream out;
            String ATTACH_TEMPLATE;
            String base_template;
            this.setHeaderString(info1, info2, SCHEDULE_INFO, byteBuffer);
            String boundary = this.getBoundaryString();
            byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
            byteBuffer.write("\tboundary=\"".getBytes());
            byteBuffer.write(boundary.getBytes(eMsLocale.MAIL_BASE_CHAR_SET));
            byteBuffer.write("\"\r\n\r\n\r\n".getBytes());
            byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
            String INTRO_TEMPLATE = "";
            String EMS_M_SECURE = __INFO1__.getAsString("EMS_M_SECURE", "Y");
            if (EMS_M_SECURE.equalsIgnoreCase("N") || EMS_M_SECURE.equalsIgnoreCase("1")) {
                if (this.NO_SECURE_INTRO_TEMPLATE == null) {
                    base_template = "";
                    ATTACH_TEMPLATE = NO_ATTACH_INTRO;
                    if (log.isDebugEnabled()) {
                        log.debug("attach_key", (Object)ATTACH_TEMPLATE);
                    }
                    if (ATTACH_TEMPLATE == null) {
                        throw new RuntimeException("NO_SECURE_INTRO_TEMPLATE IS NOT SET!!!");
                    }
                    if (ATTACH_TEMPLATE.startsWith("/")) {
                        buffer.setLength(0);
                        buffer.append(CONTENTS_BASE_URL);
                        buffer.append(ATTACH_TEMPLATE);
                        base_template = buffer.toString();
                    } else {
                        base_template = ATTACH_TEMPLATE;
                    }
                    out = null;
                    try {
                        out = eMsByteArrayOutputStream.getInstance();
                        out.reset();
                        FileElement.putFileBodyToStream(base_template, out);
                        this.NO_SECURE_INTRO_TEMPLATE = out.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
                    }
                    finally {
                        eMsByteArrayOutputStream.recycleInstance(out);
                    }
                    this.NO_SECURE_INTRO_TEMPLATE = StringConvertUtil.GeneralizeMailContents(this.NO_SECURE_INTRO_TEMPLATE);
                    if (log.isDebugEnabled()) {
                        log.debug("SECURE ATTACH CHOICE", (Object)"default attache template");
                    }
                }
                INTRO_TEMPLATE = this.NO_SECURE_INTRO_TEMPLATE;
            } else {
                if (this.REAL_ATTACH_TEMPLATE == null) {
                    base_template = "";
                    ATTACH_TEMPLATE = SCHEDULE_INFO.getProperty("SECURE_INTRO_TEMPLATE", SECURE_INTRO_TEMPLATE);
                    if (log.isDebugEnabled()) {
                        log.debug("attach_key", (Object)ATTACH_TEMPLATE);
                    }
                    if (ATTACH_TEMPLATE == null) {
                        throw new RuntimeException("SECURE_INTRO_TEMPLATE IS NOT SET!!!");
                    }
                    if (ATTACH_TEMPLATE.startsWith("/")) {
                        buffer.setLength(0);
                        buffer.append(CONTENTS_BASE_URL);
                        buffer.append(ATTACH_TEMPLATE);
                        base_template = buffer.toString();
                    } else {
                        base_template = ATTACH_TEMPLATE;
                    }
                    out = null;
                    try {
                        out = eMsByteArrayOutputStream.getInstance();
                        out.reset();
                        FileElement.putFileBodyToStream(base_template, out);
                        this.REAL_ATTACH_TEMPLATE = out.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
                    }
                    finally {
                        eMsByteArrayOutputStream.recycleInstance(out);
                    }
                    this.REAL_ATTACH_TEMPLATE = StringConvertUtil.GeneralizeMailContents(this.REAL_ATTACH_TEMPLATE);
                    if (log.isDebugEnabled()) {
                        log.debug("SECURE ATTACH CHOICE", (Object)"default attache template");
                    }
                }
                INTRO_TEMPLATE = this.REAL_ATTACH_TEMPLATE;
            }
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, INTRO_TEMPLATE, SCHEDULE_INFO, "${", "}", false, true);
            String tmpStr = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, tmpStr, info1, "${", "}", false, false);
            byteBuffer.write("\r\n--".getBytes());
            byteBuffer.write(boundary.getBytes());
            byteBuffer.write("\r\n".getBytes());
            byteBuffer.write("Content-Type: text/html;\r\n\tcharset=\"".getBytes());
            byteBuffer.write(eMsLocale.MAIL_MIME_CHAR_SET.getBytes());
            byteBuffer.write("\"\r\nContent-Transfer-Encoding: 8bit\r\n\r\n".getBytes());
            byteBuffer.write(buffer.toString().getBytes());
            byteBuffer.write("\r\n\r\n".getBytes());
            byteBuffer.write("\r\n--".getBytes());
            byteBuffer.write(boundary.getBytes());
            byteBuffer.write("\r\n".getBytes());
            byteBuffer.write("Content-Type: text/html;\r\n\tname=\"".getBytes());
            byteBuffer.write(SECURE_ATTACH_FILE_NAME.getBytes());
            byteBuffer.write("\"\r\nContent-Transfer-Encoding: base64\r\n".getBytes());
            byteBuffer.write("Content-Disposition: attachment;\r\n\tfilename=\"".getBytes());
            byteBuffer.write(SECURE_ATTACH_FILE_NAME.getBytes());
            byteBuffer.write("\"\r\n\r\n".getBytes());
            MimeConvertor.putMimeToStream(byteBuffer, body_string, eMsLocale.MAIL_BASE_CHAR_SET, eMsLocale.MAIL_MIME_CHAR_SET, (short)1);
            byteBuffer.write("\r\n".getBytes());
            if (NON_SECURE_ATTACH_FLAG) {
                Message tmpMessage = null;
                for (int i = 1; i < this.myMessages.size(); ++i) {
                    tmpMessage = (Message)this.myMessages.get(i);
                    byteBuffer.write("\n--".getBytes());
                    byteBuffer.write(boundary.getBytes());
                    byteBuffer.write(NEW_LINE);
                    tmpMessage.putHeaderToStream(byteBuffer);
                    byteBuffer.write(NEW_LINE);
                    tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
                    byteBuffer.write(NEW_LINE);
                }
            }
            byteBuffer.write("\r\n--".getBytes());
            byteBuffer.write(boundary.getBytes());
            byteBuffer.write("--\r\n\r\n".getBytes());
            returnStr = byteBuffer.toString();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            byteBuffer.close();
            byteBuffer = null;
        }
        return returnStr;
    }

    private void makeExceptMailBody(ByteArrayOutputStream byteBuffer, String body_string, Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        switch (this.BODY_TYPE) {
            case 2: {
                ((Message)this.myMessages.get(0)).putHeaderToStream(byteBuffer);
                byteBuffer.write(NEW_LINE);
                byteBuffer.write(body_string.getBytes());
                byteBuffer.write(NEW_LINE);
                break;
            }
            case 1: {
                String boundary = this.getBoundaryString();
                byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
                byteBuffer.write("\tboundary=\"".getBytes());
                byteBuffer.write(boundary.getBytes(eMsLocale.MAIL_BASE_CHAR_SET));
                byteBuffer.write("\"\r\n\r\n\r\n".getBytes());
                byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
                Message tmpMessage = null;
                tmpMessage = (Message)this.myMessages.get(0);
                byteBuffer.write("\n--".getBytes());
                byteBuffer.write(boundary.getBytes());
                byteBuffer.write(NEW_LINE);
                tmpMessage.putHeaderToStream(byteBuffer);
                byteBuffer.write(NEW_LINE);
                byteBuffer.write(body_string.getBytes());
                byteBuffer.write(NEW_LINE);
                for (int i = 1; i < this.myMessages.size(); ++i) {
                    tmpMessage = (Message)this.myMessages.get(i);
                    byteBuffer.write("\n--".getBytes());
                    byteBuffer.write(boundary.getBytes());
                    byteBuffer.write(NEW_LINE);
                    tmpMessage.putHeaderToStream(byteBuffer);
                    byteBuffer.write(NEW_LINE);
                    tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
                    byteBuffer.write(NEW_LINE);
                }
                byteBuffer.write("\r\n--".getBytes());
                byteBuffer.write(boundary.getBytes());
                byteBuffer.write("--\r\n\r\n".getBytes());
            }
        }
    }

    static {
        CONTENTS_BASE_URL = eMsSystem.getProperty("contents.base.url");
    }
}

