/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.body;

import freemarker20.template.SimpleHash;
import java.util.Iterator;
import java.util.Properties;
import mercury.contents.common.body.SimpleMailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.message.SimpleMessage;
import mercury.contents.common.parser.BinaryAttachBodyParser;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.util.LinkContent;
import mercury.contents.common.util.TrackingInfoConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.lang.eMsStringBuffer;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class OneByOneContentMailBody
extends SimpleMailBody {
    private static final Logger log = LoggerFactory.getLogger(OneByOneContentMailBody.class);
    protected static String TR_URL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        String ctnt_call_url = ((SimpleHash)info1).getAsString("CONTENTS");
        String MIME_BASE_CHAR_SET = SCHEDULE_INFO.getProperty("MAIL_BASE_CHAR_SET", eMsLocale.URLCALL_BASE_CHAR_SET);
        String realContent = FileElement.getFileBody(ctnt_call_url, MIME_BASE_CHAR_SET, eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
        if (SCHEDULE_INFO.getProperty("TRACKING_YN", "N").equalsIgnoreCase("Y") && SCHEDULE_INFO.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H")) {
            eMsStringBuffer tmpBuffer = null;
            try {
                tmpBuffer = eMsStringBuffer.getInstance();
                realContent = this.addClickURL(realContent, tmpBuffer, SCHEDULE_INFO, (SimpleHash)info1);
            }
            finally {
                eMsStringBuffer.recycleInstance(tmpBuffer);
            }
        }
        ((SimpleHash)info1).put("MAIL_CONTENT", realContent);
        Object[] attachMsg = this.makeAttachFiles((SimpleHash)info1, MIME_BASE_CHAR_SET);
        int BODY_TYPE = 0;
        BODY_TYPE = attachMsg != null && attachMsg.length != 0 ? 1 : 2;
        this.byteBuffer.reset();
        this.setHeaderString(info1, info2, SCHEDULE_INFO, this.byteBuffer);
        if (log.isDebugEnabled()) {
            log.debug("header", (Object)this.byteBuffer.toString());
        }
        switch (BODY_TYPE) {
            case 2: {
                ((Message)this.myMessages.get(0)).putHeaderToStream(this.byteBuffer);
                this.byteBuffer.write(NEW_LINE);
                if (log.isDebugEnabled()) {
                    log.debug("add message HEADER => " + this.byteBuffer.toString());
                }
                ((Message)this.myMessages.get(0)).putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
                this.byteBuffer.write(NEW_LINE);
                if (!log.isDebugEnabled()) break;
                log.debug("add message BODY => " + this.byteBuffer.toString());
                break;
            }
            case 1: {
                int i;
                String boundary = this.getBoundaryString();
                this.byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
                this.byteBuffer.write("\tboundary=\"".getBytes());
                this.byteBuffer.write(boundary.getBytes());
                this.byteBuffer.write("\"\r\n\r\n".getBytes());
                this.byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
                Message tmpMessage = null;
                for (i = 0; i < this.myMessages.size(); ++i) {
                    tmpMessage = (Message)this.myMessages.get(i);
                    this.byteBuffer.write("\n--".getBytes());
                    this.byteBuffer.write(boundary.getBytes());
                    this.byteBuffer.write(NEW_LINE);
                    tmpMessage.putHeaderToStream(this.byteBuffer);
                    this.byteBuffer.write(NEW_LINE);
                    tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
                    this.byteBuffer.write(NEW_LINE);
                }
                if (attachMsg != null) {
                    for (i = 0; i < attachMsg.length; ++i) {
                        tmpMessage = (Message)attachMsg[i];
                        if (tmpMessage == null) continue;
                        this.byteBuffer.write("\n--".getBytes());
                        this.byteBuffer.write(boundary.getBytes());
                        this.byteBuffer.write(NEW_LINE);
                        tmpMessage.putHeaderToStream(this.byteBuffer);
                        this.byteBuffer.write(NEW_LINE);
                        tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
                        this.byteBuffer.write(NEW_LINE);
                    }
                }
                this.byteBuffer.write("\r\n--".getBytes());
                this.byteBuffer.write(boundary.getBytes());
                this.byteBuffer.write("--\r\n\r\n".getBytes());
            }
        }
        return this.byteBuffer.toString(eMsLocale.MAIL_BASE_CHAR_SET);
    }

    public Object[] makeAttachFiles(SimpleHash userInfo, String charSet) throws Exception {
        String[] attachPath = this.getAttachFilePathFromMapping(userInfo);
        if (attachPath == null) {
            return null;
        }
        Object[] attachMsg = new Object[attachPath.length];
        BinaryAttachBodyParser bodyParser = null;
        SimpleMessage msg = null;
        for (int i = 0; i < attachPath.length; ++i) {
            if (attachPath[i].equals("")) continue;
            bodyParser = new BinaryAttachBodyParser();
            try {
                bodyParser.setContents(attachPath[i]);
            }
            catch (Exception e) {
                log.debug("[\ud574\ub2f9 \uacbd\ub85c\uc5d0 \ucca8\ubd80\ud30c\uc77c\uc774  \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.]");
                log.debug("Path = [" + attachPath[i] + "]");
                attachMsg[i] = null;
                continue;
            }
            msg = new SimpleMessage();
            msg.setContent(bodyParser);
            msg.setContentType(new Short(5));
            msg.setCharSet(charSet);
            msg.setContentEncoding(new Short(1));
            msg.setMessageID(Thread.currentThread().getName());
            msg.setContentName(attachPath[i].substring(attachPath[i].lastIndexOf(47) + 1));
            attachMsg[i] = msg;
        }
        return attachMsg;
    }

    public String[] getAttachFilePathFromMapping(SimpleHash userInfo) {
        String letter1 = userInfo.getAsString("ATTACH01");
        String letter2 = userInfo.getAsString("ATTACH02");
        String letter3 = userInfo.getAsString("ATTACH03");
        String letter4 = userInfo.getAsString("ATTACH04");
        String letter5 = userInfo.getAsString("ATTACH05");
        String[] letterList = new String[5];
        if (letter1 == null && letter2 == null && letter3 == null && letter4 == null && letter5 == null) {
            letterList = null;
        } else if (letter1 != null && letter2 != null && letter3 != null && letter4 != null && letter5 != null && letter1.equals("") && letter2.equals("") && letter3.equals("") && letter4.equals("") && letter5.equals("")) {
            letterList = null;
        } else {
            letterList[0] = letter1 == null ? "" : letter1.replace('\\', '/');
            letterList[1] = letter2 == null ? "" : letter2.replace('\\', '/');
            letterList[2] = letter3 == null ? "" : letter3.replace('\\', '/');
            letterList[3] = letter4 == null ? "" : letter4.replace('\\', '/');
            letterList[4] = letter5 == null ? "" : letter5.replace('\\', '/');
        }
        return letterList;
    }

    protected String addClickURL(String source, eMsStringBuffer tmpBuffer, Properties SCHEDULE_INFO, SimpleHash shash) throws Exception {
        String __FINAL_OUTPUT__ = source;
        String INSTANCE_TR_URL = null;
        StringBuffer TMP_BUFFER = new StringBuffer();
        String tmpTR_URL = StringConvertUtil.ConvertString(TR_URL, shash, "${", "}", false, false);
        TMP_BUFFER.setLength(0);
        TMP_BUFFER.append(tmpTR_URL);
        TMP_BUFFER.append(TrackingInfoConvertor.enc_LIST_TABLE(SCHEDULE_INFO.getProperty("LIST_TABLE")));
        TMP_BUFFER.append("&");
        TMP_BUFFER.append(TrackingInfoConvertor.enc_MAIL_ID(SCHEDULE_INFO.getProperty("POST_ID")));
        TMP_BUFFER.append("&");
        TMP_BUFFER.append(TrackingInfoConvertor.enc_CLOSE(SCHEDULE_INFO.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(7))));
        INSTANCE_TR_URL = TMP_BUFFER.toString();
        if (SCHEDULE_INFO.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y")) {
            LinkParser __LINK_PARSER__ = new LinkParser();
            __LINK_PARSER__.parse(__FINAL_OUTPUT__);
            LinkContent __LINK_CONTENT__ = null;
            Object __LINK_ELEMENT__ = null;
            TMP_BUFFER.setLength(0);
            Iterator __ITERATOR__ = __LINK_PARSER__.iterator();
            while (__ITERATOR__.hasNext()) {
                __LINK_ELEMENT__ = __ITERATOR__.next();
                if (__LINK_ELEMENT__ instanceof LinkContent) {
                    __LINK_CONTENT__ = (LinkContent)__LINK_ELEMENT__;
                    if (__LINK_CONTENT__.getUrl().startsWith("http")) {
                        tmpBuffer.setLength(0);
                        tmpBuffer.append(INSTANCE_TR_URL);
                        tmpBuffer.append("&");
                        tmpBuffer.append(TrackingInfoConvertor.enc_KIND("C"));
                        tmpBuffer.append("&");
                        tmpBuffer.append(TrackingInfoConvertor.enc_CID(__LINK_CONTENT__.getID()));
                        tmpBuffer.append("&URL=");
                        tmpBuffer.append(__LINK_CONTENT__.getUrl());
                        TMP_BUFFER.append(__LINK_CONTENT__.getLinkConvert(tmpBuffer.toString()));
                        continue;
                    }
                    TMP_BUFFER.append(__LINK_ELEMENT__.toString());
                    __ITERATOR__.remove();
                    continue;
                }
                TMP_BUFFER.append(__LINK_ELEMENT__.toString());
                __ITERATOR__.remove();
            }
            __FINAL_OUTPUT__ = TMP_BUFFER.toString();
            __LINK_PARSER__.clear();
        }
        return TMP_BUFFER.toString();
    }

    static {
        TR_URL = eMsSystem.getProperty("tracking.url").concat("?${enc_mid}&${enc_s_type}&");
    }
}

