/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.auto.producer;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import mercury.contents.common.parser.LinkParser;
import mercury.contents.common.producer.CommonContentPD;
import mercury.contents.common.util.LinkContent;
import mercury.contents.common.util.MappingImgStripper;
import mercury.contents.common.util.TrackingInfoConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.util.Cal;
import pluto.util.StringUtil;

public class SmsBasicContentPD
extends CommonContentPD {
    private static final Logger log = LoggerFactory.getLogger(SmsBasicContentPD.class);
    protected static String CONTENT_STORE_DIRECTORY = null;
    protected static String TR_URL = null;
    protected static String QUERY_INSERT_LINK_INFO = null;
    protected String INSTANCE_TR_URL = null;

    @Override
    protected void initProperty(Properties prop) throws Exception {
        super.initProperty(prop);
        this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");
        this.setName(this.POST_ID + " 's SmsBasicContentPD");
        this.WORK_FILE_ID = this.POST_ID + "_real_" + Cal.getSerialDate();
        this.TMP_BUFFER.setLength(0);
        this.TMP_BUFFER.append(TR_URL);
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_LIST_TABLE(this.SCHEDULE_INFO.getProperty("LIST_TABLE")));
        this.TMP_BUFFER.append("&");
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_MAIL_ID(this.POST_ID));
        this.TMP_BUFFER.append("&");
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_SERVER_ID(this.SCHEDULE_INFO.getProperty("SERVER_ID")));
        this.TMP_BUFFER.append("&");
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_CLOSE(this.SCHEDULE_INFO.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(7))));
        this.INSTANCE_TR_URL = this.TMP_BUFFER.toString();
        this.instance_ATTACH_CONTENT_SELECT_QUERY = StringUtil.ConvertString(SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_ATTACH_CONTENT"), this.SCHEDULE_INFO, "${", "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String execute_ContentProcess(String source) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("src=>", (Object)source);
        }
        String strip_img_source = MappingImgStripper.process(source);
        if (log.isDebugEnabled()) {
            log.debug("result=>", (Object)source);
        }
        if (this.SCHEDULE_INFO.getProperty("TRACKING_YN", "N").equalsIgnoreCase("Y") && this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "T").equalsIgnoreCase("H")) {
            StringBuffer buffer = null;
            try {
                buffer = new StringBuffer(1024);
                String string = this.execute_ContentTrackingParsing(strip_img_source, buffer);
                return string;
            }
            finally {
                buffer = null;
            }
        }
        return strip_img_source;
    }

    @Override
    protected String getMappingHeader() throws Exception {
        return this.SCHEDULE_INFO.getProperty("MAPPINGHEADER", " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_createContentInfo() throws Exception {
        String send_type = this.SCHEDULE_INFO.getProperty("SEND_TYPE");
        String send_state = this.SCHEDULE_INFO.getProperty("SEND_STATE");
        String mail_enc_type = this.SCHEDULE_INFO.getProperty("MAIL_ENC_TYPE", "");
        String header_mime_char_set = this.SCHEDULE_INFO.getProperty("HEADER_MIME_CHAR_SET", eMsLocale.HEADER_MIME_CHAR_SET);
        Short nMailEncType = mail_enc_type.equals("") ? new Short(eMsLocale.MAIL_ENC_TYPE) : new Short(mail_enc_type);
        BodyParser __BODY_PARSER__ = (BodyParser)InstanceFactory.getInstance(send_type, send_state, (short)1);
        __BODY_PARSER__.setContents(this.SCHEDULE_INFO.getProperty("CONTENT"));
        Message myMessage = (Message)InstanceFactory.getInstance(send_type, send_state, (short)2);
        myMessage.setContent(__BODY_PARSER__);
        if (this.SCHEDULE_INFO.getProperty("CONTENT_TYPE", "H").equals("H")) {
            myMessage.setContentType(new Short(2));
        } else {
            myMessage.setContentType(new Short(1));
        }
        myMessage.setCharSet(header_mime_char_set.equals("") ? eMsLocale.MAIL_MIME_CHAR_SET : header_mime_char_set);
        myMessage.setContentEncoding(nMailEncType);
        myMessage.setMessageID(this.POST_ID);
        MailBody __MAILBODY__ = (MailBody)InstanceFactory.getInstance(send_type, send_state, (short)3);
        __MAILBODY__.setFromEmail(this.SCHEDULE_INFO.getProperty("FROM_NUMBER"));
        __MAILBODY__.setFromName(this.SCHEDULE_INFO.getProperty("FROM_NAME"));
        __MAILBODY__.setToEmail(this.SCHEDULE_INFO.getProperty("TO_EMAIL", "${TMS_M_TOKEN}"));
        __MAILBODY__.setToName(this.SCHEDULE_INFO.getProperty("TO_NAME", "${TMS_M_NAME}"));
        __MAILBODY__.setSubject(this.SCHEDULE_INFO.getProperty("SUBJECT"));
        __MAILBODY__.setEtcHeader(eMsLocale.DEFAULT_HEADER);
        __MAILBODY__.setMessage(myMessage);
        if (eMsLocale.ATTACH_LOGIC_EXECUTE_FLAG && this.instance_ATTACH_CONTENT_SELECT_QUERY != null) {
            this.refreshDBConnection();
            eMsStatement stmt = null;
            eMsResultSet rs = null;
            try {
                stmt = this.EMS_CONNECTION.createStatement();
                rs = stmt.executeQuery(this.instance_ATTACH_CONTENT_SELECT_QUERY);
                Properties prop = new Properties();
                int file_cnt = 0;
                while (rs.next()) {
                    rs.putToMap(prop, false);
                    String aAttachFileUrl = prop.getProperty("ATTACH_FILE");
                    String aAttachFileName = prop.getProperty("ATTACH_NAME");
                    String aAttachFileId = prop.getProperty("ATTACH_FILE_ID", "");
                    this.SCHEDULE_INFO.setProperty("MMS_ATTACH_PATH_" + ++file_cnt, aAttachFileUrl);
                    this.SCHEDULE_INFO.setProperty("MMS_ATTACH_FILE_ID_" + file_cnt, aAttachFileId);
                }
                this.SCHEDULE_INFO.setProperty("MMS_ATTACH_CNT", Integer.toString(file_cnt));
            }
            finally {
                this.EMS_CONNECTION.recycleStatement(stmt);
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.SEND_CONTENT_INFO = new ContentInfo();
        this.SEND_CONTENT_INFO.setID(this.POST_ID);
        this.SEND_CONTENT_INFO.setScheduleInfo(this.SCHEDULE_INFO);
        this.SEND_CONTENT_INFO.setMappingHeader(this.getMappingHeader());
        this.SEND_CONTENT_INFO.setMailBody(__MAILBODY__);
        this.SEND_CONTENT_INFO.setReturnPath(this.SCHEDULE_INFO.getProperty("RETURN_PATH"));
        this.SEND_CONTENT_INFO.setSendType(this.SCHEDULE_INFO.getProperty("SEND_TYPE"));
    }

    protected String execute_ContentTrackingParsing(String source, StringBuffer tmpBuffer) throws Exception {
        String __FINAL_OUTPUT__ = source;
        if (this.SCHEDULE_INFO.getProperty("CLICK_YN", "N").equalsIgnoreCase("Y")) {
            LinkParser __LINK_PARSER__ = new LinkParser();
            __LINK_PARSER__.parse(__FINAL_OUTPUT__);
            LinkContent __LINK_CONTENT__ = null;
            Object __LINK_ELEMENT__ = null;
            this.TMP_BUFFER.setLength(0);
            Iterator __ITERATOR__ = __LINK_PARSER__.iterator();
            while (__ITERATOR__.hasNext()) {
                __LINK_ELEMENT__ = __ITERATOR__.next();
                if (__LINK_ELEMENT__ instanceof LinkContent) {
                    __LINK_CONTENT__ = (LinkContent)__LINK_ELEMENT__;
                    if (__LINK_CONTENT__.getUrl().startsWith("http")) {
                        tmpBuffer.setLength(0);
                        tmpBuffer.append(this.INSTANCE_TR_URL);
                        tmpBuffer.append("&");
                        tmpBuffer.append(TrackingInfoConvertor.enc_KIND("C"));
                        tmpBuffer.append("&");
                        tmpBuffer.append(TrackingInfoConvertor.enc_CID(__LINK_CONTENT__.getID()));
                        tmpBuffer.append("&URL=");
                        tmpBuffer.append(__LINK_CONTENT__.getUrl());
                        this.TMP_BUFFER.append(__LINK_CONTENT__.getLinkConvert(tmpBuffer.toString()));
                        continue;
                    }
                    this.TMP_BUFFER.append(__LINK_ELEMENT__.toString());
                    __ITERATOR__.remove();
                    continue;
                }
                this.TMP_BUFFER.append(__LINK_ELEMENT__.toString());
                __ITERATOR__.remove();
            }
            __FINAL_OUTPUT__ = this.TMP_BUFFER.toString();
            this.StroreTrackingInfoToDB(__LINK_PARSER__);
            __LINK_PARSER__.clear();
        }
        String head = null;
        String tail = null;
        int idxBodyEnd = __FINAL_OUTPUT__.toLowerCase().indexOf("</body");
        if (idxBodyEnd > 0) {
            head = __FINAL_OUTPUT__.substring(0, idxBodyEnd);
            tail = __FINAL_OUTPUT__.substring(idxBodyEnd);
        } else {
            head = __FINAL_OUTPUT__;
            tail = "";
        }
        this.TMP_BUFFER.setLength(0);
        this.TMP_BUFFER.append(head);
        this.TMP_BUFFER.append("<div style=\"display:none\">");
        this.TMP_BUFFER.append("<IMG width=0 height=0 src=\"");
        this.TMP_BUFFER.append(this.INSTANCE_TR_URL);
        this.TMP_BUFFER.append("&");
        this.TMP_BUFFER.append(TrackingInfoConvertor.enc_KIND("O"));
        this.TMP_BUFFER.append("\">");
        this.TMP_BUFFER.append("</div>");
        this.TMP_BUFFER.append(tail);
        return this.TMP_BUFFER.toString();
    }

    protected void StroreTrackingInfoToDB(List __LINK_INFOS__) throws Exception {
        this.refreshDBConnection();
        eMsPreparedStatement __PS_INSERT_LINK_INFO__ = null;
        try {
            __PS_INSERT_LINK_INFO__ = new eMsPreparedStatement(QUERY_INSERT_LINK_INFO, "${", "}");
            __PS_INSERT_LINK_INFO__.connectTo(this.EMS_CONNECTION);
            LinkContent __LINK_CONTENT__2 = null;
            String __TMP_CONTENT__ = null;
            Properties __LINK_UPDATE_PROPERTIES__ = new Properties();
            __LINK_UPDATE_PROPERTIES__.putAll((Map<?, ?>)this.SCHEDULE_INFO);
            for (LinkContent __LINK_CONTENT__2 : __LINK_INFOS__) {
                __TMP_CONTENT__ = __LINK_CONTENT__2.getContent();
                if (__TMP_CONTENT__.length() > eMsLocale.LINK_LENGTH_LIMIT) {
                    __TMP_CONTENT__ = __TMP_CONTENT__.substring(0, eMsLocale.LINK_LENGTH_LIMIT);
                }
                __LINK_UPDATE_PROPERTIES__.setProperty("CLICK_ID", __LINK_CONTENT__2.getID());
                __LINK_UPDATE_PROPERTIES__.setProperty("CLICK_DESC", __TMP_CONTENT__);
                __LINK_UPDATE_PROPERTIES__.setProperty("LINK_URL", __LINK_CONTENT__2.getUrl());
                if (log.isDebugEnabled()) {
                    log.debug("ID: " + __LINK_CONTENT__2.getID());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Content: " + __TMP_CONTENT__);
                }
                if (log.isDebugEnabled()) {
                    log.debug("URL:  " + __LINK_CONTENT__2.getUrl());
                }
                try {
                    __PS_INSERT_LINK_INFO__.executeUpdate(__LINK_UPDATE_PROPERTIES__);
                }
                catch (SQLException e) {
                    log.error(this.getName() + e);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e.toString());
        }
        finally {
            try {
                __PS_INSERT_LINK_INFO__.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        try {
            QUERY_INSERT_LINK_INFO = SqlManager.getQuery("COMMON", "QUERY_INSERT_LINK_INFO");
            CONTENT_STORE_DIRECTORY = eMsSystem.getProperty("content.store.directory");
            TR_URL = eMsSystem.getProperty("tracking.url").concat("?${enc_mid}&${enc_s_type}&");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

