/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.send.task;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;

public class PersonalResendTask
extends CommonStepMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(PersonalResendTask.class);
    public ArrayList SPOOLINFO_LIST = new ArrayList();
    protected static String QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = null;
    protected static String QUERY_UPDATE_LIST_STATE_QUERY = null;
    protected static String QUERY_SELECT_LIST_LOAD_QUERY = null;
    protected static String QUERY_SELECT_RESEND_TABLE_INFO = null;
    protected static String instance_QUERY_TARGET_TABLE_INFO = null;
    protected static String QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = null;

    public PersonalResendTask() throws Exception {
        super((short)2, 1L);
        this.setName("PersonalResendTask");
        this.setTaskID("PersonalResendTask");
        if (log.isDebugEnabled()) {
            log.debug("PERSONAL RESEND Instance Create...");
        }
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        if (log.isDebugEnabled()) {
            log.debug("PERSONAL RESEND INIT...");
        }
    }

    @Override
    public void setTaskProperty(Properties prop) {
    }

    @Override
    public void doErrorProcess(Throwable thr) {
    }

    @Override
    protected void execute_ListMake() throws Exception {
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        this.WORK_FILE_ID = "personal_resend_".concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
        this.SPOOL_ANALYZER.setStep(0);
        if (log.isDebugEnabled()) {
            log.debug("REAL TIME Instance Initiate...");
        }
    }

    @Override
    public void release_Resource() {
        super.release_Resource();
    }

    @Override
    protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_ListLoad() throws Exception {
        this.SPOOLINFO_LIST.clear();
        SpoolInfo spInfo = null;
        Vector v = null;
        eMsConnection conn = null;
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        eMsResultSet rs = null;
        String sPostId = "";
        try {
            conn = ConnectionPool.getConnection();
            __EMS_EXEC_STATEMENT__ = conn.createStatement();
            rs = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_PERSONAL_RESEND_WORK_INFO);
            Properties prop = new Properties();
            while (rs.next()) {
                prop.clear();
                rs.putToMap(prop, false);
                prop.setProperty("MAPPINGHEADER", SpoolInfoManager.getSpoolInfo(prop.getProperty("POST_ID")).getMappingHeader());
                SpoolControlTask targetTask = (SpoolControlTask)InstanceFactory.getInstance(prop, (short)7);
                targetTask.setTaskProperty(prop);
                targetTask.internal_execute();
                spInfo = targetTask.getSpoolInfo();
                SpoolInfoManager.registSpoolInfo(spInfo, spInfo.getID() + "_" + spInfo.getSendState() + Cal.getSerialDate());
                v = spInfo.getSpoolFilesInfo();
                if (v != null && v.size() > 0) {
                    this.SPOOLINFO_LIST.add(spInfo);
                }
                try {
                    this.wait_thread(1000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            try {
                Properties oProp = new Properties();
                oProp.setProperty("POST_ID", sPostId);
                if (log.isDebugEnabled()) {
                    log.debug("QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO : " + QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO);
                    log.debug("oProp : " + oProp);
                    log.debug("__EMS_EXEC_STATEMENT__ :  " + __EMS_EXEC_STATEMENT__);
                }
                __EMS_EXEC_STATEMENT__.executeUpdate(StringConvertUtil.ConvertString(QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO, oProp, "${", "}", false, false));
            }
            catch (Exception e2) {
                log.error(this.getName(), (Throwable)e2);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            __EMS_EXEC_STATEMENT__.close();
            conn.recycle();
        }
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    @Override
    protected void execute_Finish() throws Exception {
    }

    @Override
    protected synchronized void execute_ListSend() throws Exception {
        if (this.SPOOLINFO_LIST == null) {
            log.debug(" No Real Data.... So Skip ");
        } else {
            for (SpoolInfo this.mailSpoolInfo : this.SPOOLINFO_LIST) {
                super.execute_MassResend_ListSend();
                this.wait(100L);
            }
        }
        BufferedAgentPool.flushAll();
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    private synchronized void wait_thread(long time) throws InterruptedException {
        try {
            this.wait(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_PERSONAL_RESEND_WORK_INFO");
            QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_LIST_STATE_QUERY");
            QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_LIST_LOAD_QUERY");
            QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_RESEND_TABLE_INFO");
            QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

