/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Properties;
import jupiter.mass.log.updator.sync.SwitchingFactory;
import jupiter.mass.log.updator.sync.SwitchingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;

public class PushToTmsTransfer
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PushToTmsTransfer.class);
    private static ConnectInfo TARGET_CONNECT_INFO = null;
    private eMsPreparedStatement PSTMT = null;
    protected eMsConnection LOCAL_CONNECTION = null;
    private eMsConnection EX_PUSH_CONNECTION = null;
    private eMsStatement MODULE_PUSH_SELECT_STMT = null;
    private String QUERY_TARGET_PUSH_RESULT_QUERY = null;
    private String INSERT_TMS_SENDED_LOG = null;
    private String LOCAL_MAX_PUSH_LOG_ID = null;
    private String EXTERNAL_MAX_PUSH_LOG_ID = null;
    private int preExternalMaxValue = 0;
    private int intervalCount = 5;

    public PushToTmsTransfer() {
        super((short)2, 2L);
        this.setName("PushToTmsTransfer");
        this.setTaskID("PushToTmsTransfer");
        this.LOCAL_MAX_PUSH_LOG_ID = SqlManager.getQuery("MASS_UPDATE", "LOCAL_MAX_PUSH_LOG_ID");
        this.EXTERNAL_MAX_PUSH_LOG_ID = SqlManager.getQuery("MASS_UPDATE", "EXTERNAL_MAX_PUSH_LOG_ID");
        this.QUERY_TARGET_PUSH_RESULT_QUERY = SqlManager.getQuery("MASS_UPDATE", "QUERY_TARGET_PUSH_RESULT_QUERY");
        this.INSERT_TMS_SENDED_LOG = SqlManager.getQuery("MASS_UPDATE", "INSERT_TMS_SENDED_LOG");
    }

    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushToTmsTransfer===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("CALL execute() ERROR", thw);
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushToTmsTransfer===> execute_init()");
        }
        this.LOCAL_CONNECTION = ConnectionPool.getConnection();
        this.EX_PUSH_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
        this.MODULE_PUSH_SELECT_STMT = this.EX_PUSH_CONNECTION.createStatement();
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL PushToTmsTransfer===> releaseResource()");
        }
        if (this.LOCAL_CONNECTION != null) {
            this.LOCAL_CONNECTION.recycle();
        }
        if (this.EX_PUSH_CONNECTION != null) {
            this.EX_PUSH_CONNECTION.close();
        }
    }

    protected void execute_main() throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug("CALL PushToTmsTransfer===> execute_main()");
            }
            this.update_process("TB_SEND_QUE_LOG");
        }
        catch (Exception e) {
            log.error("execute_main", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int singlePushSendLogToTmsRepository(eMsResultSet rs) throws Exception {
        int insertedCount = 0;
        try {
            this.PSTMT = this.LOCAL_CONNECTION.prepareStatement(this.INSERT_TMS_SENDED_LOG, "${", "}");
            int count = 0;
            while (rs.next()) {
                try {
                    Properties p = new Properties();
                    rs.putToMap(p, false);
                    this.PSTMT.executeQuery(p);
                }
                catch (Exception e) {
                    log.error("pushSendLogToTmsRepository", (Throwable)e);
                    int n = 0;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.PSTMT != null) {
                            this.PSTMT.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return n;
                }
                ++count;
            }
        }
        catch (Exception e) {
            log.error("pushSendLogToTmsRepository_finish ", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.PSTMT != null) {
                    this.PSTMT.close();
                }
            }
            catch (Exception exception) {}
        }
        return insertedCount;
    }

    public synchronized int pushSendLogToTmsRepository(eMsResultSet rs) throws Exception {
        int insertedCount = 0;
        try {
            this.LOCAL_CONNECTION.setAutoCommit(false);
            this.PSTMT = this.LOCAL_CONNECTION.prepareStatement(this.INSERT_TMS_SENDED_LOG, "${", "}");
            int count = 0;
            while (rs.next()) {
                try {
                    Properties p = new Properties();
                    rs.putToMap(p, false);
                    this.PSTMT.addBatchLong(p);
                }
                catch (Exception e) {
                    log.error("pushSendLogToTmsRepository", (Throwable)e);
                    int n = 0;
                    if (rs != null) {
                        rs.close();
                    }
                    if (this.PSTMT != null) {
                        this.PSTMT.close();
                    }
                    this.LOCAL_CONNECTION.commit();
                    this.LOCAL_CONNECTION.setAutoCommit(true);
                    return n;
                }
                ++count;
            }
            log.debug("External Push select Count[" + count + "] Local Insert Count [" + (insertedCount += PushToTmsTransfer.getBatchResultCnt(this.PSTMT.executeBatch())) + "]");
        }
        catch (Exception e) {
            this.LOCAL_CONNECTION.rollback();
            log.error("pushSendLogToTmsRepository_finish ", (Throwable)e);
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (this.PSTMT != null) {
                this.PSTMT.close();
            }
            this.LOCAL_CONNECTION.commit();
            this.LOCAL_CONNECTION.setAutoCommit(true);
        }
        return insertedCount;
    }

    private static int getBatchResultCnt(int[] updates) {
        int tmpCnt = 0;
        for (int i = 0; i < updates.length; ++i) {
            if (updates[i] == -2) {
                ++tmpCnt;
                continue;
            }
            if (updates[i] == -3) {
                log.error("Push Result Insert Fail Position[" + i + "]");
                log.debug("Push Result Insert Fail Position[" + i + "]");
                continue;
            }
            tmpCnt += updates[i];
        }
        return tmpCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        eMsResultSet modulePushResult = null;
        Properties prePushSendResultValue = new Properties();
        try {
            prePushSendResultValue.setProperty("PUSH_LIST_TABLE", list_table);
            String localMax = "";
            String externalMax = "";
            SwitchingService switching = SwitchingFactory.getSwitchingFactory().getInstance("push");
            switching.doLock();
            for (int i = 0; i < 20; ++i) {
                localMax = this.getLocalPushLogMaxId();
                prePushSendResultValue.setProperty("ID", localMax);
                externalMax = this.getExternalPushLogMaxId();
                prePushSendResultValue.setProperty("MAX_ID", externalMax);
                if (Long.parseLong(localMax) - 1L == Long.parseLong(externalMax)) {
                    log.debug("external Push data(MAX_ID=" + externalMax + ") --> local push log(MAX_ID=" + (Long.parseLong(localMax) - 1L) + ")");
                    switching.unLock();
                    return;
                }
                modulePushResult = this.MODULE_PUSH_SELECT_STMT.executeQuery(this.QUERY_TARGET_PUSH_RESULT_QUERY, prePushSendResultValue, "${", "}");
                this.pushSendLogToTmsRepository(modulePushResult);
            }
            switching.unLock();
            log.debug("external Push data(MAX_ID=" + externalMax + ") --> local push log(MAX_ID=" + localMax + "-1 )");
        }
        catch (Exception e) {
            log.debug("Exception external Push data --> local push log =" + e.toString());
            log.error("execute_main", (Throwable)e);
        }
        finally {
            try {
                prePushSendResultValue.clear();
                if (modulePushResult != null) {
                    modulePushResult.close();
                }
                if (this.MODULE_PUSH_SELECT_STMT != null) {
                    this.MODULE_PUSH_SELECT_STMT.close();
                }
                if (this.LOCAL_CONNECTION != null) {
                    this.LOCAL_CONNECTION.setAutoCommit(true);
                }
            }
            catch (Exception e2) {
                log.error("execute_main", (Throwable)e2);
            }
        }
    }

    private boolean waiting(int localMax, int externalMax) {
        if (externalMax - this.preExternalMaxValue < 2) {
            --this.intervalCount;
            return this.intervalCount != 0;
        }
        return externalMax - localMax <= 10000;
    }

    private String getLocalPushLogMaxId() throws Exception {
        eMsStatement statement = null;
        statement = this.LOCAL_CONNECTION.createStatement();
        return this.getPushLogMaxId(statement, this.LOCAL_MAX_PUSH_LOG_ID);
    }

    private String getExternalPushLogMaxId() throws Exception {
        eMsStatement statement = null;
        statement = this.EX_PUSH_CONNECTION.createStatement();
        return this.getPushLogMaxId(statement, this.EXTERNAL_MAX_PUSH_LOG_ID);
    }

    private String getPushLogMaxId(eMsStatement statement, String sql) throws Exception {
        eMsResultSet localResultSet = null;
        String id = "1";
        try {
            localResultSet = statement.executeQuery(sql);
            if (localResultSet.next()) {
                id = localResultSet.getString("ID");
            }
            String string = id;
            return string;
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (localResultSet != null) {
                    localResultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void release_Resource() {
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("PushToTmsTransfer_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("init error", thw);
    }

    static {
        TARGET_CONNECT_INFO = new ConnectInfo();
        TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("push.db.driver"));
        TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("push.db.url"));
        TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("push.db.id"));
        TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("push.db.pass"));
        TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("push.db.init"));
        TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("push.db.base.charset"));
        TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("push.db.out.charset"));
        TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("push.db.in.charset"));
    }
}

