/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;

public class MmsUpdatorCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(MmsUpdatorCheckTask.class);
    private static String MAX_THREAD_SIZE = "10";
    private static String ONE_THREAD_CNT = "1000";
    private static String CHANNEL_TYPE = "";
    private static String UPDATE_CLASS_NAME = "";
    public static String QUERY_SELECT_TARGET_RANGE = null;
    public static String QUERY_SELECT_TARGET_MMS_LIST_TABLE = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement __SELECT_SEARCH_STATEMENT__ = null;

    public MmsUpdatorCheckTask() {
        super((short)2);
        this.setName("MmsUpdatorCheckTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("MmsUpdatorCheckTask");
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        ONE_THREAD_CNT = prop.getProperty("one.thread.cnt", "1000");
        MAX_THREAD_SIZE = prop.getProperty("max.thread.size", "10");
        CHANNEL_TYPE = prop.getProperty("channel.type", "PU");
        UPDATE_CLASS_NAME = prop.getProperty("update.class.name", "");
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("MmsUpdatorCheckTask_at_".concat(Cal.getSerialDate()));
        if (log.isDebugEnabled()) {
            log.info("MmsUpdatorCheckTask_START");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        try {
            this.__SELECT_SEARCH_STATEMENT__ = this.EMS_CONNECTION.createStatement();
        }
        catch (Exception e) {
            this.EMS_CONNECTION = ConnectionPool.getConnection();
            this.__SELECT_SEARCH_STATEMENT__ = this.EMS_CONNECTION.createStatement();
        }
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), (Object)" Request Connection Error");
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycleStatement(this.__SELECT_SEARCH_STATEMENT__);
            this.EMS_CONNECTION.recycle();
        }
    }

    @Override
    public void execute() throws Exception {
        eMsResultSet __RESULT_OF_TARGET_RANGE = null;
        eMsResultSet __SMS_LIST_TABLE = null;
        Properties TARGET_RANGE_INFO = new Properties();
        Hashtable info = null;
        Properties tValue = new Properties();
        try {
            __SMS_LIST_TABLE = this.__SELECT_SEARCH_STATEMENT__.executeQuery(QUERY_SELECT_TARGET_MMS_LIST_TABLE);
            while (__SMS_LIST_TABLE.next()) {
                if (__SMS_LIST_TABLE.getString("LIST_TABLE1").equals(__SMS_LIST_TABLE.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", __SMS_LIST_TABLE.getString("LIST_TABLE1").toString());
                    continue;
                }
                __SMS_LIST_TABLE.putToMap(tValue, false);
            }
            int th_id = 1;
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String smsListTable = iter.next().toString();
                info = new Hashtable();
                info.put("SMS_LIST_TABLE", smsListTable);
                __RESULT_OF_TARGET_RANGE = this.__SELECT_SEARCH_STATEMENT__.executeQuery(QUERY_SELECT_TARGET_RANGE, info, "${", "}");
                while (__RESULT_OF_TARGET_RANGE.next()) {
                    __RESULT_OF_TARGET_RANGE.putToMap(TARGET_RANGE_INFO, false);
                }
                if (TARGET_RANGE_INFO.size() > 0) {
                    if (Integer.parseInt(TARGET_RANGE_INFO.getProperty("TO_CNT")) <= 0) continue;
                    info = MmsUpdatorCheckTask.getThreadInfo(TARGET_RANGE_INFO.getProperty("MIN_ID"), TARGET_RANGE_INFO.getProperty("MAX_ID"), smsListTable, th_id++);
                    Enumeration myEnum = info.elements();
                    while (myEnum.hasMoreElements()) {
                        TARGET_RANGE_INFO = (Properties)myEnum.nextElement();
                        try {
                            log.debug("TEST", (Object)TARGET_RANGE_INFO.toString());
                            this.execute_createTask(TARGET_RANGE_INFO);
                        }
                        catch (Exception e) {
                            log.error("POOL FLUSH EXCEPTION", (Throwable)e);
                        }
                    }
                    continue;
                }
                log.info("no data skip .....[OK]");
            }
        }
        catch (Exception e) {
            log.error("MMS update error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (__RESULT_OF_TARGET_RANGE != null) {
                    __RESULT_OF_TARGET_RANGE.close();
                }
                if (__SMS_LIST_TABLE != null) {
                    __SMS_LIST_TABLE.close();
                }
            }
            catch (Exception exception) {}
        }
        if (log.isDebugEnabled()) {
            log.debug("START is execute execute_createTask method...[OK]");
        }
    }

    private synchronized void execute_createTask(Properties info) throws Exception {
        try {
            try {
                Task make_info = (Task)this.getInstance(UPDATE_CLASS_NAME);
                make_info.setTaskProperty(info);
                TaskManager.executeTask(make_info);
                try {
                    this.wait(500L);
                }
                catch (Exception exception) {
                }
            }
            catch (AlreadyRegistTaskException e) {
                log.error("AlreadyRegistTaskException is skip");
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    public static Hashtable getThreadInfo(String min, String max, String listTable, int th_id) throws Exception {
        int oneThreadCnt = Integer.parseInt(ONE_THREAD_CNT);
        int threadSize = 1;
        long maxSeq = Long.parseLong(max);
        long minSeq = Long.parseLong(min);
        int range = (int)(maxSeq - minSeq);
        Properties info = null;
        Hashtable<String, Properties> selectInfo = new Hashtable<String, Properties>();
        int remain = range;
        log.info("range ==> {}", (Object)range);
        threadSize = MmsUpdatorCheckTask.divideCeil(remain, oneThreadCnt);
        if (threadSize > 10) {
            threadSize = 10;
            oneThreadCnt = MmsUpdatorCheckTask.divideCeil(remain, threadSize);
        }
        log.info("threadSize ==> {}", (Object)threadSize);
        log.info("oneThreadCnt ==> {}", (Object)oneThreadCnt);
        if (threadSize == 1 || maxSeq == minSeq) {
            info = new Properties();
            info.setProperty("MAX_ID", Long.toString(maxSeq));
            info.setProperty("MIN_ID", Long.toString(minSeq));
            info.setProperty("SMS_LIST_TABLE", listTable);
            info.setProperty("THREAD_ID", Integer.toString(th_id));
            selectInfo.put("1", info);
            return selectInfo;
        }
        long maxVal = 0L;
        long minVal = 0L;
        for (int i = 0; i < threadSize; ++i) {
            info = new Properties();
            maxVal = maxSeq - (long)(oneThreadCnt * i);
            minVal = i + 1 == threadSize ? minSeq : maxVal - (long)oneThreadCnt;
            info.setProperty("MAX_ID", Long.toString(maxVal));
            info.setProperty("MIN_ID", Long.toString(minVal));
            info.setProperty("THREAD_ID", Integer.toString(i));
            log.info("info : {}", (Object)info.toString());
            selectInfo.put(Integer.toString(i), info);
        }
        return selectInfo;
    }

    public Object getInstance(String className) throws Exception {
        Class<?> classes = Class.forName(className);
        return classes.newInstance();
    }

    public static int divideCeil(int a1, int b1) {
        int returnStr = 0;
        try {
            float leaves = a1 % b1;
            int temp = 0;
            temp = leaves != 0.0f ? a1 / b1 + 1 : a1 / b1;
            returnStr = temp;
            return returnStr;
        }
        catch (Exception e) {
            return returnStr;
        }
    }

    static {
        try {
            QUERY_SELECT_TARGET_RANGE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_RANGE");
            QUERY_SELECT_TARGET_MMS_LIST_TABLE = SqlManager.getQuery("COMMON_UPDATE", "QUERY_SELECT_TARGET_MMS_LIST_TABLE");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

