/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.log.updator;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import jupiter.mass.log.updator.ScheduleTblBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.common.bean.PlanBean;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

public class LmsAutoUpdator
extends Task {
    private static final Logger log = LoggerFactory.getLogger(LmsAutoUpdator.class);
    private static ConnectInfo TARGET_CONNECT_INFO = null;
    private eMsConnection SOURCE_CONNECTION = null;
    private eMsConnection TARGET_CONNECTION = null;
    private eMsStatement TMS_SMS_SELECT_STMT = null;
    private eMsStatement TMS_SMS_UPDATE_STMT = null;
    private eMsStatement MODULE_SMS_SELECT_STMT = null;
    private eMsPreparedStatement MODULE_SMS_UPDATE_STMT = null;
    private String QUERY_SELECT_TARGET_SMS_LIST_TABLE = null;
    private String QUERY_TARGET_SMS_RESULT_QUERY = null;
    private String QUERY_UPDATE_MASS_RESULT_QUERY = null;
    private String QUERY_UPDATE_SMS_TRAN_FLAG_QUERY = null;
    private String QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = null;
    private static Hashtable CAMP_SCHEDULE_PPT;
    private String QUERY_UPDATE_RESULT = null;
    private static eMsPreparedStatement PPS_SELECT_FLOW_DATA;
    private static eMsPreparedStatement PPS_INSERT_FLOW_DATA;
    private static String QUERY_SELECT_PLAN_INFO;
    private static String QUERY_INSERT_FLOW_DATA;

    public LmsAutoUpdator() {
        super((short)2, 2L);
        this.setName("LmsAutoUpdator");
        this.setTaskID("LmsAutoUpdator");
        this.QUERY_SELECT_TARGET_SMS_LIST_TABLE = SqlManager.getQuery("AUTO_UPDATE", "QUERY_SELECT_TARGET_LMS_LIST_TABLE");
        this.QUERY_TARGET_SMS_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_LMS_RESULT_QUERY");
        this.QUERY_UPDATE_MASS_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_MASS_RESULT_QUERY");
        this.QUERY_UPDATE_SMS_TRAN_FLAG_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_LMS_TRAN_FLAG_QUERY");
        this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY");
        this.QUERY_UPDATE_RESULT = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_RESULT");
    }

    @Override
    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsAutoUpdator===> execute()");
        }
        try {
            this.execute_init();
            this.execute_main();
        }
        catch (Throwable thw) {
            log.error("CALL execute() ERROR", thw);
        }
        finally {
            this.releaseResource();
        }
    }

    protected void execute_init() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsAutoUpdator===> execute_init()");
        }
        this.SOURCE_CONNECTION = ConnectionPool.getConnection();
        CAMP_SCHEDULE_PPT.clear();
        this.TARGET_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
        this.TMS_SMS_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
        this.TMS_SMS_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
        this.MODULE_SMS_SELECT_STMT = this.TARGET_CONNECTION.createStatement();
        this.MODULE_SMS_UPDATE_STMT = null;
    }

    protected void releaseResource() {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsAutoUpdator===> releaseResource()");
        }
        if (PPS_SELECT_FLOW_DATA != null) {
            PPS_SELECT_FLOW_DATA.close();
            PPS_SELECT_FLOW_DATA = null;
        }
        if (PPS_INSERT_FLOW_DATA != null) {
            PPS_INSERT_FLOW_DATA.close();
            PPS_INSERT_FLOW_DATA = null;
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_SELECT_STMT);
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_UPDATE_STMT);
            this.SOURCE_CONNECTION.recycle();
        }
        if (this.TARGET_CONNECTION != null) {
            this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_UPDATE_STMT);
            this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_SELECT_STMT);
            this.TARGET_CONNECTION.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute_main() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("CALL LmsAutoUpdator===> execute_main()");
        }
        Properties tValue = new Properties();
        try (eMsResultSet smsListTableResult = null;){
            smsListTableResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_SMS_LIST_TABLE);
            while (smsListTableResult.next()) {
                if (smsListTableResult.getString("LIST_TABLE1").equals(smsListTableResult.getString("LIST_TABLE2"))) {
                    tValue.setProperty("LIST_TABLE", smsListTableResult.getString("LIST_TABLE1").toString());
                    continue;
                }
                smsListTableResult.putToMap(tValue, false);
            }
            if (smsListTableResult != null) {
                smsListTableResult.close();
            }
            Iterator<Object> iter = tValue.values().iterator();
            while (iter.hasNext()) {
                String smsListTable = iter.next().toString();
                if (!smsListTable.equals("") && smsListTable != null) {
                    this.update_process(smsListTable);
                    continue;
                }
                log.debug("TARGET TABLE null ", (Object)this.QUERY_SELECT_TARGET_SMS_LIST_TABLE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update_process(String list_table) throws Exception {
        eMsResultSet moduleSMSResult = null;
        Properties sMsSendResultValue = new Properties();
        Properties summaryValue = new Properties();
        ScheduleTblBean stBean = null;
        Object updateBean = null;
        int result = 0;
        int count = 0;
        boolean updateFlag = false;
        StringBuffer buff = new StringBuffer(512);
        String postId = "";
        String memberId = "";
        try {
            sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
            moduleSMSResult = this.MODULE_SMS_SELECT_STMT.executeQuery(this.QUERY_TARGET_SMS_RESULT_QUERY, sMsSendResultValue, "${", "}");
            Properties tableNameProp = new Properties();
            tableNameProp.setProperty("LMS_LIST_TABLE", list_table);
            StringBuffer buffer = new StringBuffer();
            StringConvertUtil.ConvertString(buffer, this.QUERY_UPDATE_SMS_TRAN_FLAG_QUERY, tableNameProp, "${", "}", true, true);
            this.MODULE_SMS_UPDATE_STMT = new eMsPreparedStatement(buffer.toString(), "${", "}");
            this.MODULE_SMS_UPDATE_STMT.connectTo(this.TARGET_CONNECTION);
            while (moduleSMSResult.next()) {
                updateFlag = true;
                sMsSendResultValue.clear();
                sMsSendResultValue.setProperty("LMS_LIST_TABLE", list_table);
                moduleSMSResult.putToMap(sMsSendResultValue, false);
                postId = sMsSendResultValue.getProperty("POST_ID").trim();
                memberId = sMsSendResultValue.getProperty("MEMBER_ID").trim();
                stBean = (ScheduleTblBean)CAMP_SCHEDULE_PPT.get(postId);
                if (stBean == null) {
                    stBean = new ScheduleTblBean(postId);
                    CAMP_SCHEDULE_PPT.put(postId, stBean);
                }
                int posPostid = postId.indexOf("_");
                String workDay = postId.substring(0, posPostid);
                String seqNo = postId.substring(posPostid + 1);
                sMsSendResultValue.setProperty("WORKDAY", workDay);
                sMsSendResultValue.setProperty("SEQNO", seqNo);
                if (sMsSendResultValue.getProperty("MEMBER_ID").indexOf("^") > 0) {
                    int pos = memberId.lastIndexOf("^");
                    int pos2 = memberId.lastIndexOf("_");
                    String mId = memberId.substring(0, pos2);
                    String mIdSeq = memberId.substring(pos2 + 1, pos);
                    String workSeq = memberId.substring(pos + 1);
                    sMsSendResultValue.setProperty("M_ID", mId);
                    sMsSendResultValue.setProperty("M_ID_SEQ", mIdSeq);
                    sMsSendResultValue.setProperty("WORK_SEQ", workSeq);
                    this.TMS_SMS_UPDATE_STMT.executeUpdate(this.QUERY_UPDATE_RESULT, sMsSendResultValue, "${", "}");
                    this.MODULE_SMS_UPDATE_STMT.executeUpdate(sMsSendResultValue);
                    updateFlag = false;
                    continue;
                }
                int posMid = memberId.lastIndexOf("_");
                String mId = memberId.substring(0, posMid);
                String mIdSeq = memberId.substring(posMid + 1);
                sMsSendResultValue.setProperty("MEMBER_ID", mId);
                sMsSendResultValue.setProperty("MEMBER_ID_SEQ", mIdSeq);
                this.TMS_SMS_UPDATE_STMT.executeUpdate(this.QUERY_UPDATE_MASS_RESULT_QUERY, sMsSendResultValue, "${", "}");
                this.MODULE_SMS_UPDATE_STMT.executeUpdate(sMsSendResultValue);
                if (Integer.parseInt(sMsSendResultValue.getProperty("FAIL_CNT")) > 0) {
                    stBean.addFailCnt();
                    stBean.addErrorCnt(sMsSendResultValue.getProperty("ERROR_CODE"));
                }
                stBean.addPush();
            }
            if (CAMP_SCHEDULE_PPT.size() <= 0) {
                return;
            }
            if (updateFlag) {
                Enumeration e = CAMP_SCHEDULE_PPT.elements();
                while (e.hasMoreElements()) {
                    stBean = (ScheduleTblBean)e.nextElement();
                    buff.setLength(0);
                    if (log.isDebugEnabled()) {
                        log.debug("[stBean content]\n\t" + stBean.toString());
                    }
                    StringConvertUtil.ConvertString(buff, this.QUERY_UPDATE_SCHEDULE_INFO_SUMMARY_QUERY, stBean.getElement("AUTO"), "${", "}", true, false);
                    result = this.TMS_SMS_UPDATE_STMT.executeUpdate(buff.toString());
                    if (result < 1) {
                        log.debug("[SCHEDULE SUMMARY FAIL]:" + stBean.getName());
                        continue;
                    }
                    ++count;
                }
                if (count == CAMP_SCHEDULE_PPT.size()) {
                    // empty if block
                }
            }
            this.insertFlowPlanData(sMsSendResultValue);
        }
        catch (Exception e) {
            log.error("LmsAutoUpdator", (Object)"execute_main", (Object)e);
        }
        finally {
            if (moduleSMSResult != null) {
                moduleSMSResult.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String insertFlowPlanData(Object target) throws Exception {
        Properties propLogData = (Properties)target;
        boolean isResend = propLogData.getProperty("IS_RESEND", "false").equals("true");
        int failCnt = Integer.parseInt(propLogData.getProperty("FAIL_CNT"));
        String postId = propLogData.getProperty("POST_ID");
        String actType = "SKIP";
        actType = failCnt > 0 ? "FAIL" : (isResend ? "SUCCESS_RETRY" : "SUCCESS_FIRST");
        PlanBean bean = PlanBean.getPlanBean(postId);
        if (bean == null) {
            bean = new PlanBean();
            if (PPS_SELECT_FLOW_DATA == null) {
                PPS_SELECT_FLOW_DATA = this.SOURCE_CONNECTION.prepareStatement(QUERY_SELECT_PLAN_INFO, "${", "}");
            }
            ArrayList<Properties> arrTarget = new ArrayList<Properties>();
            eMsResultSet rsFlowData = null;
            try {
                rsFlowData = PPS_SELECT_FLOW_DATA.executeQuery(propLogData);
                while (rsFlowData.next()) {
                    Properties prop = new Properties();
                    prop.setProperty("MSG_TYPE", rsFlowData.getString("MSG_TYPE"));
                    prop.setProperty("MSG_TYPE_SEQ", rsFlowData.getString("MSG_TYPE_SEQ"));
                    prop.setProperty("PLAN_DAY", rsFlowData.getString("PLAN_DAY"));
                    prop.setProperty("PLAN_HOUR", rsFlowData.getString("PLAN_HOUR"));
                    prop.setProperty("PLAN_STATUS", rsFlowData.getString("PLAN_STATUS"));
                    arrTarget.add(prop);
                }
            }
            catch (Exception prop) {
            }
            finally {
                if (rsFlowData != null) {
                    rsFlowData.close();
                    rsFlowData = null;
                }
            }
            bean.setPostId(postId);
            bean.setArrTarget(arrTarget);
            PlanBean.setPlanBean(bean);
        }
        if (!bean.isPlanYn()) {
            return "SKIP";
        }
        ArrayList<Properties> dataList = bean.getArrTarget();
        int dataCnt = dataList.size();
        String msgType = "";
        String msgTypeSeq = "";
        String planStatus = "";
        String planDay = "";
        String planHour = "";
        boolean actFlag = false;
        for (int i = 0; i < dataCnt; ++i) {
            int cnt_insert;
            Properties propPlanData = dataList.get(i);
            msgType = propPlanData.getProperty("MSG_TYPE");
            msgTypeSeq = propPlanData.getProperty("MSG_TYPE_SEQ");
            planStatus = propPlanData.getProperty("PLAN_STATUS");
            planDay = propPlanData.getProperty("PLAN_DAY");
            planHour = propPlanData.getProperty("PLAN_HOUR");
            if (log.isDebugEnabled()) {
                log.debug("[planStatus]" + planStatus + "[actType]" + actType);
            }
            if ("A".equals(planStatus)) {
                if (!"SUCCESS_FIRST".equals(actType) && !"FAIL".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:ALL> SUCCESS_FIRST / FAIL");
                }
            } else if ("S".equals(planStatus)) {
                if (!"SUCCESS_FIRST".equals(actType) && !"SUCCESS_RETRY".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:SUCCESS> SUCCESS_FIRST / SUCCESS_RETRY");
                }
            } else {
                if (!"F".equals(planStatus) || !"FAIL".equals(actType)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("[TARGET_AREA]<Type:FAIL> FAIL_FIRST");
                }
            }
            propLogData.setProperty("MSG_TYPE", msgType);
            propLogData.setProperty("MSG_TYPE_SEQ", msgTypeSeq);
            propLogData.setProperty("PLAN_STATUS", planStatus);
            propLogData.setProperty("PLAN_DAY", StringUtil.isNull(planDay) ? "0" : planDay);
            propLogData.setProperty("PLAN_HOUR", StringUtil.isNull(planHour) ? "0" : planHour);
            if (PPS_INSERT_FLOW_DATA == null) {
                PPS_INSERT_FLOW_DATA = this.SOURCE_CONNECTION.prepareStatement(QUERY_INSERT_FLOW_DATA, "${", "}");
            }
            if ((cnt_insert = PPS_INSERT_FLOW_DATA.executeUpdate(propLogData)) != 1) {
                log.debug("[ERROR] insert fail <FLOW_DATA> " + propLogData.toString());
                continue;
            }
            actFlag = true;
        }
        if (!actFlag) {
            actType = "no Match";
        }
        return actType;
    }

    @Override
    public void release_Resource() {
        if (PPS_SELECT_FLOW_DATA != null) {
            PPS_SELECT_FLOW_DATA.close();
            PPS_SELECT_FLOW_DATA = null;
        }
        if (PPS_INSERT_FLOW_DATA != null) {
            PPS_INSERT_FLOW_DATA.close();
            PPS_INSERT_FLOW_DATA = null;
        }
        if (this.SOURCE_CONNECTION != null) {
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_SELECT_STMT);
            this.SOURCE_CONNECTION.recycleStatement(this.TMS_SMS_UPDATE_STMT);
            this.SOURCE_CONNECTION.recycle();
        }
        if (this.TARGET_CONNECTION != null) {
            this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_UPDATE_STMT);
            this.TARGET_CONNECTION.recycleStatement(this.MODULE_SMS_SELECT_STMT);
            this.TARGET_CONNECTION.recycle();
        }
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("LmsAutoUpdator_at_".concat(Cal.getSerialDate()));
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error("LmsAutoUpdator", (Object)"init error", (Object)thw);
    }

    static {
        TARGET_CONNECT_INFO = new ConnectInfo();
        TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
        TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("sms.db.url"));
        TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("sms.db.id"));
        TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
        TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
        TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
        TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
        TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
        CAMP_SCHEDULE_PPT = new Hashtable();
        PPS_SELECT_FLOW_DATA = null;
        PPS_INSERT_FLOW_DATA = null;
        QUERY_SELECT_PLAN_INFO = SqlManager.getQuery("FLOW_PLAN", "QUERY_SELECT_PLAN_INFO");
        QUERY_INSERT_FLOW_DATA = SqlManager.getQuery("FLOW_PLAN", "QUERY_INSERT_FLOW_DATA");
    }
}

